/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom.ls;

import gnu.xml.dom.DomDOMException;
import gnu.xml.dom.ls.DomLSException;
import gnu.xml.dom.ls.DomLSOutput;
import gnu.xml.transform.StreamSerializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSException;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.w3c.dom.ls.LSSerializerFilter;

public class DomLSSerializer
extends StreamSerializer
implements LSSerializer,
DOMConfiguration,
DOMStringList {
    private static final List SUPPORTED_PARAMETERS = Arrays.asList("discard-default-content", "xml-declaration");
    private LSSerializerFilter filter;
    private StreamSerializer serializer;

    public DomLSSerializer() {
        this.discardDefaultContent = true;
    }

    public DOMConfiguration getDomConfig() {
        return this;
    }

    public String getNewLine() {
        return this.eol;
    }

    public void setNewLine(String newLine) {
        if (newLine == null) {
            newLine = System.getProperty("line.separator");
        }
        this.eol = newLine;
    }

    public LSSerializerFilter getFilter() {
        return this.filter;
    }

    public void setFilter(LSSerializerFilter filter) {
        this.filter = filter;
    }

    public boolean write(Node node2, LSOutput output) throws LSException {
        OutputStream out = output.getByteStream();
        try {
            if (out == null) {
                String systemId = output.getSystemId();
                try {
                    URL url = new URL(systemId);
                    URLConnection connection = url.openConnection();
                    connection.setDoOutput(true);
                    if (connection instanceof HttpURLConnection) {
                        ((HttpURLConnection)connection).setRequestMethod("PUT");
                    }
                    out = connection.getOutputStream();
                }
                catch (MalformedURLException malformedURLException) {
                    File file = new File(systemId);
                    out = new FileOutputStream(file);
                }
            }
            this.serialize(node2, out);
            out.flush();
            return true;
        }
        catch (IOException e) {
            throw new DomLSException(82, e);
        }
    }

    public boolean writeToURI(Node node2, String uri) throws LSException {
        DomLSOutput output = new DomLSOutput();
        output.setSystemId(uri);
        return this.write(node2, output);
    }

    public String writeToString(Node node2) throws DOMException, LSException {
        StringWriter writer = new StringWriter();
        DomLSOutput output = new DomLSOutput();
        output.setCharacterStream(writer);
        this.write(node2, output);
        return ((Object)writer).toString();
    }

    public void serialize(Node node2, OutputStream out) throws IOException {
        if (this.filter == null) {
            super.serialize(node2, out);
        } else {
            int wts = this.filter.getWhatToShow();
            if (wts != -1) {
                switch (node2.getNodeType()) {
                    case 2: {
                        if ((wts & 2) != 0) break;
                        super.serialize(node2, out);
                        return;
                    }
                    case 3: {
                        if ((wts & 4) != 0) break;
                        super.serialize(node2, out);
                        return;
                    }
                    case 1: {
                        if ((wts & 1) != 0) break;
                        super.serialize(node2, out);
                        return;
                    }
                    case 4: {
                        if ((wts & 8) != 0) break;
                        super.serialize(node2, out);
                        return;
                    }
                    case 8: {
                        if ((wts & 0x80) != 0) break;
                        super.serialize(node2, out);
                        return;
                    }
                    case 9: {
                        if ((wts & 0x100) != 0) break;
                        super.serialize(node2, out);
                        return;
                    }
                    case 10: {
                        if ((wts & 0x200) != 0) break;
                        super.serialize(node2, out);
                        return;
                    }
                    case 7: {
                        if ((wts & 0x40) != 0) break;
                        super.serialize(node2, out);
                        return;
                    }
                    case 11: {
                        if ((wts & 0x400) != 0) break;
                        super.serialize(node2, out);
                        return;
                    }
                    case 6: {
                        if ((wts & 0x20) != 0) break;
                        super.serialize(node2, out);
                        return;
                    }
                    case 5: {
                        if ((wts & 0x10) != 0) break;
                        super.serialize(node2, out);
                        return;
                    }
                    case 12: {
                        if ((wts & 0x800) != 0) break;
                        super.serialize(node2, out);
                        return;
                    }
                }
            }
            switch (this.filter.acceptNode(node2)) {
                case 1: {
                    super.serialize(node2, out);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    Node first = node2.getFirstChild();
                    if (first == null) break;
                    this.serialize(first, out);
                }
            }
        }
    }

    public void setParameter(String name, Object value) throws DOMException {
        if ("discard-default-content".equals(name)) {
            this.discardDefaultContent = "true".equals(value.toString());
        } else if ("xml-declaration".equals(name)) {
            this.xmlDeclaration = "false".equals(value.toString());
        } else {
            throw new DomDOMException(9);
        }
    }

    public Object getParameter(String name) throws DOMException {
        if ("discard-default-content".equals(name)) {
            return this.discardDefaultContent ? "true" : "false";
        }
        if ("xml-declaration".equals(name)) {
            return this.xmlDeclaration ? "true" : "false";
        }
        throw new DomDOMException(9);
    }

    public boolean canSetParameter(String name, Object value) {
        return this.contains(name);
    }

    public DOMStringList getParameterNames() {
        return this;
    }

    public String item(int i) {
        return (String)SUPPORTED_PARAMETERS.get(i);
    }

    public int getLength() {
        return SUPPORTED_PARAMETERS.size();
    }

    public boolean contains(String str) {
        return SUPPORTED_PARAMETERS.contains(str);
    }
}

