/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import gnu.xml.dom.DomDocumentBuilderFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;

public abstract class DocumentBuilderFactory {
    private boolean namespaceAware;
    private boolean validating;
    private boolean ignoringElementContentWhitespace;
    private boolean expandEntityReferences = true;
    private boolean ignoringComments;
    private boolean coalescing;
    private Schema schema;
    private boolean xIncludeAware;

    protected DocumentBuilderFactory() {
    }

    public static DocumentBuilderFactory newInstance() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = DocumentBuilderFactory.class.getClassLoader();
        }
        String className = null;
        int count = 0;
        do {
            if ((className = DocumentBuilderFactory.getFactoryClassName(loader, count++)) == null) continue;
            try {
                Class<?> t = loader != null ? loader.loadClass(className) : Class.forName(className);
                return (DocumentBuilderFactory)t.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                className = null;
            }
            catch (Exception e) {
                throw new FactoryConfigurationError(e, "error instantiating class " + className);
            }
        } while (className == null && count < 3);
        return new DomDocumentBuilderFactory();
    }

    private static String getFactoryClassName(ClassLoader loader, int attempt) {
        switch (attempt) {
            case 0: {
                return System.getProperty("javax.xml.parsers.DocumentBuilderFactory");
            }
            case 1: {
                try {
                    File file = new File(System.getProperty("java.home"));
                    file = new File(file, "lib");
                    file = new File(file, "jaxp.properties");
                    FileInputStream in = new FileInputStream(file);
                    Properties props = new Properties();
                    props.load(in);
                    ((InputStream)in).close();
                    return props.getProperty("javax.xml.parsers.DocumentBuilderFactory");
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            case 2: {
                try {
                    InputStream in;
                    String serviceKey = "/META-INF/services/javax.xml.parsers.DocumentBuilderFactory";
                    InputStream inputStream = in = loader != null ? loader.getResourceAsStream(serviceKey) : DocumentBuilderFactory.class.getResourceAsStream(serviceKey);
                    if (in != null) {
                        BufferedReader r = new BufferedReader(new InputStreamReader(in));
                        String ret = r.readLine();
                        r.close();
                        return ret;
                    }
                }
                catch (IOException iOException) {}
                return null;
            }
        }
        return null;
    }

    public abstract DocumentBuilder newDocumentBuilder() throws ParserConfigurationException;

    public void setNamespaceAware(boolean awareness) {
        this.namespaceAware = awareness;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public void setIgnoringElementContentWhitespace(boolean whitespace) {
        this.ignoringElementContentWhitespace = whitespace;
    }

    public void setExpandEntityReferences(boolean expandEntityRef) {
        this.expandEntityReferences = expandEntityRef;
    }

    public void setIgnoringComments(boolean ignoreComments) {
        this.ignoringComments = ignoreComments;
    }

    public void setCoalescing(boolean coalescing) {
        this.coalescing = coalescing;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public boolean isIgnoringElementContentWhitespace() {
        return this.ignoringElementContentWhitespace;
    }

    public boolean isExpandEntityReferences() {
        return this.expandEntityReferences;
    }

    public boolean isIgnoringComments() {
        return this.ignoringComments;
    }

    public boolean isCoalescing() {
        return this.coalescing;
    }

    public abstract void setAttribute(String var1, Object var2) throws IllegalArgumentException;

    public abstract Object getAttribute(String var1) throws IllegalArgumentException;

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public boolean isXIncludeAware() {
        return this.xIncludeAware;
    }

    public void setXIncludeAware(boolean state) {
        this.xIncludeAware = state;
    }

    public abstract void setFeature(String var1, boolean var2) throws ParserConfigurationException;

    public abstract boolean getFeature(String var1) throws ParserConfigurationException;
}

