/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.MultiAttributeSet;
import javax.swing.text.html.StyleSheet;

class ViewAttributeSet
extends MultiAttributeSet {
    private View view;
    private StyleSheet styleSheet;

    ViewAttributeSet(View v, StyleSheet ss) {
        this.styleSheet = ss;
        this.view = v;
        ArrayList<AttributeSet> atts = new ArrayList<AttributeSet>();
        Element el = v.getElement();
        AttributeSet elAtts = el.getAttributes();
        AttributeSet htmlAtts = this.styleSheet.translateHTMLToCSS(elAtts);
        if (htmlAtts.getAttributeCount() > 0) {
            atts.add(htmlAtts);
        }
        if (el.isLeaf()) {
            Enumeration<?> n = elAtts.getAttributeNames();
            while (n.hasMoreElements()) {
                Style rule;
                Object key = n.nextElement();
                if (!(key instanceof HTML.Tag) || (rule = this.styleSheet.getRule((HTML.Tag)key, el)) == null) continue;
                atts.add(rule);
            }
        } else {
            HTML.Tag tag = (HTML.Tag)elAtts.getAttribute(StyleConstants.NameAttribute);
            Style rule = this.styleSheet.getRule(tag, el);
            if (rule != null) {
                atts.add(rule);
            }
        }
        AttributeSet[] atts1 = new AttributeSet[atts.size()];
        atts1 = atts.toArray(atts1);
        this.init(atts1);
    }

    public Object getAttribute(Object key) {
        AttributeSet resolveParent;
        CSS.Attribute cssKey;
        Object val = super.getAttribute(key);
        if (val == null && key instanceof CSS.Attribute && (cssKey = (CSS.Attribute)key).isInherited() && (resolveParent = this.getResolveParent()) != null) {
            val = resolveParent.getAttribute(cssKey);
        }
        return val;
    }

    public AttributeSet getResolveParent() {
        View parentView;
        AttributeSet parent = null;
        if (this.view != null && (parentView = this.view.getParent()) != null) {
            parent = parentView.getAttributes();
        }
        return parent;
    }
}

