/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import gnu.java.lang.CPStringBuilder;
import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultStyledDocument
extends AbstractDocument
implements StyledDocument {
    private static final long serialVersionUID = 940485415728614849L;
    public static final int BUFFER_SIZE_DEFAULT = 4096;
    protected ElementBuffer buffer = new ElementBuffer(this.createDefaultRoot());
    private StyleChangeListener styleChangeListener;

    public DefaultStyledDocument() {
        this((AbstractDocument.Content)new GapContent(4096), new StyleContext());
    }

    public DefaultStyledDocument(StyleContext context) {
        this((AbstractDocument.Content)new GapContent(4096), context);
    }

    public DefaultStyledDocument(AbstractDocument.Content content, StyleContext context) {
        super(content, context);
        this.setLogicalStyle(0, context.getStyle("default"));
    }

    @Override
    public Style addStyle(String nm, Style parent) {
        StyleContext context = (StyleContext)this.getAttributeContext();
        Style newStyle = context.addStyle(nm, parent);
        if (this.styleChangeListener == null) {
            this.styleChangeListener = new StyleChangeListener();
        }
        newStyle.addChangeListener(this.styleChangeListener);
        return newStyle;
    }

    protected AbstractDocument.AbstractElement createDefaultRoot() {
        SectionElement section = new SectionElement();
        AbstractDocument.BranchElement paragraph = new AbstractDocument.BranchElement(section, null);
        Element[] tmp = new Element[]{paragraph};
        section.replace(0, 0, tmp);
        AbstractDocument.LeafElement leaf = new AbstractDocument.LeafElement(paragraph, null, 0, 1);
        tmp = new Element[]{leaf};
        paragraph.replace(0, 0, tmp);
        return section;
    }

    @Override
    public Element getCharacterElement(int position) {
        Element element = this.getDefaultRootElement();
        while (!element.isLeaf()) {
            int index = element.getElementIndex(position);
            element = element.getElement(index);
        }
        return element;
    }

    @Override
    public Color getBackground(AttributeSet attributes) {
        StyleContext context = (StyleContext)this.getAttributeContext();
        return context.getBackground(attributes);
    }

    @Override
    public Element getDefaultRootElement() {
        return this.buffer.getRootElement();
    }

    @Override
    public Font getFont(AttributeSet attributes) {
        StyleContext context = (StyleContext)this.getAttributeContext();
        return context.getFont(attributes);
    }

    @Override
    public Color getForeground(AttributeSet attributes) {
        StyleContext context = (StyleContext)this.getAttributeContext();
        return context.getForeground(attributes);
    }

    @Override
    public Style getLogicalStyle(int position) {
        Element paragraph = this.getParagraphElement(position);
        AttributeSet attributes = paragraph.getAttributes();
        AttributeSet a = attributes.getResolveParent();
        if (a instanceof Style) {
            return (Style)a;
        }
        return null;
    }

    @Override
    public Element getParagraphElement(int position) {
        Element e = this.getDefaultRootElement();
        while (!e.isLeaf()) {
            e = e.getElement(e.getElementIndex(position));
        }
        if (e != null) {
            return e.getParentElement();
        }
        return e;
    }

    @Override
    public Style getStyle(String nm) {
        StyleContext context = (StyleContext)this.getAttributeContext();
        return context.getStyle(nm);
    }

    @Override
    public void removeStyle(String nm) {
        StyleContext context = (StyleContext)this.getAttributeContext();
        context.removeStyle(nm);
    }

    @Override
    public void setCharacterAttributes(int offset, int length, AttributeSet attributes, boolean replace) {
        if (length == 0) {
            return;
        }
        try {
            this.writeLock();
            AbstractDocument.DefaultDocumentEvent ev = new AbstractDocument.DefaultDocumentEvent(offset, length, DocumentEvent.EventType.CHANGE);
            this.buffer.change(offset, length, ev);
            int end = offset + length;
            int pos = offset;
            while (pos < end) {
                Element curr = this.getCharacterElement(pos);
                if (pos == curr.getEndOffset()) break;
                MutableAttributeSet a = (MutableAttributeSet)curr.getAttributes();
                ev.addEdit(new AttributeUndoableEdit(curr, attributes, replace));
                if (replace) {
                    a.removeAttributes(a);
                }
                a.addAttributes(attributes);
                pos = curr.getEndOffset();
            }
            this.fireChangedUpdate(ev);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, ev));
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void setLogicalStyle(int position, Style style) {
        block5: {
            Element el = this.getParagraphElement(position);
            if (el == null) {
                return;
            }
            try {
                this.writeLock();
                if (el instanceof AbstractDocument.AbstractElement) {
                    AbstractDocument.AbstractElement ael = (AbstractDocument.AbstractElement)el;
                    ael.setResolveParent(style);
                    int start = el.getStartOffset();
                    int end = el.getEndOffset();
                    AbstractDocument.DefaultDocumentEvent ev = new AbstractDocument.DefaultDocumentEvent(start, end - start, DocumentEvent.EventType.CHANGE);
                    this.fireChangedUpdate(ev);
                    this.fireUndoableEditUpdate(new UndoableEditEvent(this, ev));
                    break block5;
                }
                throw new AssertionError((Object)"paragraph elements are expected to beinstances of AbstractDocument.AbstractElement");
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    @Override
    public void setParagraphAttributes(int offset, int length, AttributeSet attributes, boolean replace) {
        try {
            this.writeLock();
            AbstractDocument.DefaultDocumentEvent ev = new AbstractDocument.DefaultDocumentEvent(offset, length, DocumentEvent.EventType.CHANGE);
            Element rootElement = this.getDefaultRootElement();
            int startElement = rootElement.getElementIndex(offset);
            int endElement = rootElement.getElementIndex(offset + length - 1);
            if (endElement < startElement) {
                endElement = startElement;
            }
            int i = startElement;
            while (i <= endElement) {
                Element par = rootElement.getElement(i);
                MutableAttributeSet a = (MutableAttributeSet)par.getAttributes();
                ev.addEdit(new AttributeUndoableEdit(par, attributes, replace));
                if (replace) {
                    a.removeAttributes(a);
                }
                a.addAttributes(attributes);
                ++i;
            }
            this.fireChangedUpdate(ev);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, ev));
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent ev, AttributeSet attr) {
        int offs = ev.getOffset();
        int len = ev.getLength();
        int endOffs = offs + len;
        if (attr == null) {
            attr = SimpleAttributeSet.EMPTY;
        }
        Element paragraph = this.getParagraphElement(endOffs);
        AttributeSet pAttr = paragraph.getAttributes();
        Element paragraph2 = this.getParagraphElement(offs);
        int contIndex = paragraph2.getElementIndex(offs);
        Element content = paragraph2.getElement(contIndex);
        AttributeSet cAttr = content.getAttributes();
        boolean insertAtBoundary = content.getEndOffset() == endOffs;
        try {
            ElementSpec lastTag;
            Segment s = new Segment();
            ArrayList<ElementSpec> buf = new ArrayList<ElementSpec>();
            ElementSpec lastStartTag = null;
            boolean insertAfterNewline = false;
            short lastStartDir = 6;
            if (offs > 0) {
                this.getText(offs - 1, 1, s);
                if (s.array[s.offset] == '\n') {
                    insertAfterNewline = true;
                    lastStartDir = this.insertAfterNewline(paragraph, paragraph2, pAttr, buf, offs, endOffs);
                    int i = buf.size() - 1;
                    while (i >= 0 && lastStartTag == null) {
                        ElementSpec tag = (ElementSpec)buf.get(i);
                        if (tag.getType() == 1) {
                            lastStartTag = tag;
                        }
                        --i;
                    }
                }
            }
            if (!insertAfterNewline) {
                pAttr = paragraph2.getAttributes();
            }
            this.getText(offs, len, s);
            int end = s.offset + s.count;
            int last = s.offset;
            int i = s.offset;
            while (i < end) {
                if (s.array[i] == '\n') {
                    int breakOffs = i + 1;
                    buf.add(new ElementSpec(attr, 3, breakOffs - last));
                    buf.add(new ElementSpec(null, 2));
                    lastStartTag = new ElementSpec(pAttr, 1);
                    buf.add(lastStartTag);
                    last = breakOffs;
                }
                ++i;
            }
            if (last < end) {
                buf.add(new ElementSpec(attr, 3, end - last));
            }
            ElementSpec first = (ElementSpec)buf.get(0);
            int doclen = this.getLength();
            if (first.getType() == 3 && cAttr.isEqual(attr)) {
                first.setDirection((short)4);
            }
            if (lastStartTag != null) {
                if (insertAfterNewline) {
                    lastStartTag.setDirection(lastStartDir);
                } else if (paragraph2.getEndOffset() != endOffs) {
                    lastStartTag.setDirection((short)7);
                } else {
                    Element par = paragraph2.getParentElement();
                    int par2Index = par.getElementIndex(offs);
                    if (par2Index + 1 < par.getElementCount() && !par.getElement(par2Index + 1).isLeaf()) {
                        lastStartTag.setDirection((short)5);
                    }
                }
            }
            if (insertAtBoundary && endOffs < doclen) {
                int nextIndex;
                Element nextRun;
                lastTag = (ElementSpec)buf.get(buf.size() - 1);
                if (lastTag.getType() == 3 && (lastStartTag == null && (paragraph == paragraph2 || insertAfterNewline) || lastStartTag != null && lastStartTag.getDirection() != 6) && (nextRun = paragraph.getElement(nextIndex = paragraph.getElementIndex(endOffs))).isLeaf() && attr.isEqual(nextRun.getAttributes())) {
                    lastTag.setDirection((short)5);
                }
            } else if (!insertAtBoundary && lastStartTag != null && lastStartTag.getDirection() == 7 && (lastTag = (ElementSpec)buf.get(buf.size() - 1)).getType() == 3 && lastTag.getDirection() != 4 && attr.isEqual(cAttr)) {
                lastTag.setDirection((short)5);
            }
            ElementSpec[] specs = new ElementSpec[buf.size()];
            specs = buf.toArray(specs);
            this.buffer.insert(offs, len, specs, ev);
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        super.insertUpdate(ev, attr);
    }

    private short insertAfterNewline(Element par1, Element par2, AttributeSet attr, ArrayList buf, int offs, int endOffs) {
        int dir = 0;
        if (par1.getParentElement() == par2.getParentElement()) {
            ElementSpec tag = new ElementSpec(attr, 2);
            buf.add(tag);
            tag = new ElementSpec(attr, 1);
            buf.add(tag);
            if (par2.getEndOffset() != endOffs) {
                dir = 7;
            } else {
                Element par = par2.getParentElement();
                if (par.getElementIndex(offs) + 1 < par.getElementCount()) {
                    dir = 5;
                }
            }
        } else {
            ArrayList<Element> parentsLeft = new ArrayList<Element>();
            ArrayList<Element> parentsRight = new ArrayList<Element>();
            Element e = par2;
            while (e != null) {
                parentsLeft.add(e);
                e = e.getParentElement();
            }
            e = par1;
            int leftIndex = -1;
            while (e != null && (leftIndex = parentsLeft.indexOf(e)) == 1) {
                parentsRight.add(e);
                e = e.getParentElement();
            }
            if (e != null) {
                int c = 0;
                while (c < leftIndex) {
                    buf.add(new ElementSpec(null, 2));
                    ++c;
                }
                c = parentsRight.size() - 1;
                while (c >= 0) {
                    Element el = (Element)parentsRight.get(c);
                    ElementSpec tag = new ElementSpec(el.getAttributes(), 1);
                    if (c > 0) {
                        tag.setDirection((short)5);
                    }
                    buf.add(tag);
                    --c;
                }
                dir = parentsRight.size() > 0 ? 5 : 7;
            } else assert (false);
        }
        return (short)dir;
    }

    short handleInsertAfterNewline(Vector specs, int offset, int endOffset, Element prevParagraph, Element paragraph, AttributeSet a) {
        if (prevParagraph.getParentElement() == paragraph.getParentElement()) {
            specs.add(new ElementSpec(a, 2));
            specs.add(new ElementSpec(a, 1));
            if (paragraph.getStartOffset() != endOffset) {
                return 7;
            }
            Element parent = paragraph.getParentElement();
            if (parent.getElementCount() > parent.getElementIndex(offset) + 1) {
                return 5;
            }
        }
        return 6;
    }

    @Override
    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent ev) {
        super.removeUpdate(ev);
        this.buffer.remove(ev.getOffset(), ev.getLength(), ev);
    }

    public Enumeration<?> getStyleNames() {
        StyleContext context = (StyleContext)this.getAttributeContext();
        return context.getStyleNames();
    }

    protected void styleChanged(Style style) {
    }

    protected void insert(int offset, ElementSpec[] data) throws BadLocationException {
        if (data == null || data.length == 0) {
            return;
        }
        try {
            this.writeLock();
            CPStringBuilder contentBuffer = new CPStringBuilder();
            int i = 0;
            while (i < data.length) {
                ElementSpec spec = data[i];
                if (spec.getArray() != null && spec.getLength() > 0) {
                    contentBuffer.append(spec.getArray(), spec.getOffset(), spec.getLength());
                }
                ++i;
            }
            int length = contentBuffer.length();
            if (length == 0) {
                return;
            }
            AbstractDocument.Content c = this.getContent();
            UndoableEdit edit = c.insertString(offset, contentBuffer.toString());
            AbstractDocument.DefaultDocumentEvent ev = new AbstractDocument.DefaultDocumentEvent(offset, length, DocumentEvent.EventType.INSERT);
            ev.addEdit(edit);
            this.buffer.insert(offset, length, data, ev);
            super.insertUpdate(ev, null);
            ev.end();
            this.fireInsertUpdate(ev);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, ev));
        }
        finally {
            this.writeUnlock();
        }
    }

    protected void create(ElementSpec[] data) {
        try {
            try {
                int len = this.getLength();
                if (len > 0) {
                    this.remove(0, len);
                }
                this.writeLock();
                StringBuilder b = new StringBuilder();
                int i = 0;
                while (i < data.length) {
                    ElementSpec el = data[i];
                    if (el.getArray() != null && el.getLength() > 0) {
                        b.append(el.getArray(), el.getOffset(), el.getLength());
                    }
                    ++i;
                }
                AbstractDocument.Content content = this.getContent();
                UndoableEdit cEdit = content.insertString(0, b.toString());
                len = b.length();
                AbstractDocument.DefaultDocumentEvent ev = new AbstractDocument.DefaultDocumentEvent(0, b.length(), DocumentEvent.EventType.INSERT);
                ev.addEdit(cEdit);
                this.buffer.create(len, data, ev);
                super.insertUpdate(ev, null);
                ev.end();
                this.fireInsertUpdate(ev);
                this.fireUndoableEditUpdate(new UndoableEditEvent(this, ev));
            }
            catch (BadLocationException ex) {
                AssertionError err = new AssertionError((Object)"Unexpected bad location");
                ((Throwable)((Object)err)).initCause(ex);
                throw err;
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public static class AttributeUndoableEdit
    extends AbstractUndoableEdit {
        protected AttributeSet copy;
        protected AttributeSet newAttributes;
        protected boolean isReplacing;
        protected Element element;

        public AttributeUndoableEdit(Element el, AttributeSet newAtts, boolean replacing) {
            this.element = el;
            this.newAttributes = newAtts;
            this.isReplacing = replacing;
            this.copy = el.getAttributes().copyAttributes();
        }

        public void undo() {
            super.undo();
            AttributeSet atts = this.element.getAttributes();
            if (atts instanceof MutableAttributeSet) {
                MutableAttributeSet mutable = (MutableAttributeSet)atts;
                mutable.removeAttributes(atts);
                mutable.addAttributes(this.copy);
            }
        }

        public void redo() {
            super.undo();
            AttributeSet atts = this.element.getAttributes();
            if (atts instanceof MutableAttributeSet) {
                MutableAttributeSet mutable = (MutableAttributeSet)atts;
                if (this.isReplacing) {
                    mutable.removeAttributes(atts);
                }
                mutable.addAttributes(this.newAttributes);
            }
        }
    }

    public class ElementBuffer
    implements Serializable {
        private static final long serialVersionUID = 1688745877691146623L;
        private Element root;
        private int offset;
        private int endOffset;
        private int length;
        private int pos;
        private Element fracturedParent;
        private Element fracturedChild;
        private boolean createdFracture;
        private Stack elementStack;
        private Edit[] insertPath;
        private boolean recreateLeafs;
        private ArrayList edits;
        private boolean offsetLastIndex;
        private boolean offsetLastIndexReplace;

        public ElementBuffer(Element root) {
            this.root = root;
        }

        public Element getRootElement() {
            return this.root;
        }

        public void remove(int offs, int len, AbstractDocument.DefaultDocumentEvent ev) {
            this.prepareEdit(offs, len);
            this.removeUpdate();
            this.finishEdit(ev);
        }

        protected void removeUpdate() {
            this.removeElements(this.root, this.offset, this.endOffset);
        }

        private boolean removeElements(Element elem, int rmOffs0, int rmOffs1) {
            boolean ret = false;
            if (!elem.isLeaf()) {
                int index0 = elem.getElementIndex(rmOffs0);
                int index1 = elem.getElementIndex(rmOffs1);
                this.elementStack.push(new Edit(elem, index0));
                Edit ec = (Edit)this.elementStack.peek();
                if (index0 == index1) {
                    Element child0 = elem.getElement(index0);
                    if (rmOffs0 <= child0.getStartOffset() && rmOffs1 >= child0.getEndOffset()) {
                        ec.removed.add(child0);
                    } else if (this.removeElements(child0, rmOffs0, rmOffs1)) {
                        ec.removed.add(child0);
                    }
                } else {
                    boolean containsOffs1;
                    Element child0 = elem.getElement(index0);
                    Element child1 = elem.getElement(index1);
                    boolean bl = containsOffs1 = rmOffs1 < elem.getEndOffset();
                    if (containsOffs1 && this.canJoin(child0, child1)) {
                        int i = index0;
                        while (i <= index1) {
                            ec.removed.add(elem.getElement(i));
                            ++i;
                        }
                        Element e = this.join(elem, child0, child1, rmOffs0, rmOffs1);
                        ec.added.add(e);
                    } else {
                        int rmIndex0 = index0 + 1;
                        int rmIndex1 = index1 - 1;
                        if (child0.getStartOffset() == rmOffs0 || index0 == 0 && child0.getStartOffset() > rmOffs0 && child0.getEndOffset() <= rmOffs1) {
                            child0 = null;
                            rmIndex0 = index0;
                        }
                        if (!containsOffs1) {
                            child1 = null;
                            ++rmIndex1;
                        } else if (child1.getStartOffset() == rmOffs1) {
                            child1 = null;
                        }
                        if (rmIndex0 <= rmIndex1) {
                            ec.index = rmIndex0;
                        }
                        int i = rmIndex0;
                        while (i <= rmIndex1) {
                            ec.removed.add(elem.getElement(i));
                            ++i;
                        }
                        if (child0 != null && this.removeElements(child0, rmOffs0, rmOffs1)) {
                            ec.removed.add(0, child0);
                            ec.index = index0;
                        }
                        if (child1 != null && this.removeElements(child1, rmOffs0, rmOffs1)) {
                            ec.removed.add(child1);
                        }
                    }
                }
                this.pop();
                if (elem.getElementCount() == ec.removed.size() - ec.added.size()) {
                    ret = true;
                }
            }
            return ret;
        }

        void create(int len, ElementSpec[] data, AbstractDocument.DefaultDocumentEvent ev) {
            this.prepareEdit(this.offset, len);
            Element el = this.root;
            int index = el.getElementIndex(0);
            while (!el.isLeaf()) {
                Element child = el.getElement(index);
                Edit edit = new Edit(el, index, false);
                this.elementStack.push(edit);
                el = child;
                index = el.getElementIndex(0);
            }
            Edit ed = (Edit)this.elementStack.peek();
            Element child = ed.e.getElement(ed.index);
            ed.added.add(DefaultStyledDocument.this.createLeafElement(ed.e, child.getAttributes(), DefaultStyledDocument.this.getLength(), child.getEndOffset()));
            ed.removed.add(child);
            while (this.elementStack.size() > 1) {
                this.pop();
            }
            int n = data.length;
            AttributeSet newAtts = null;
            if (n > 0 && data[0].getType() == 1) {
                newAtts = data[0].getAttributes();
            }
            if (newAtts == null) {
                newAtts = SimpleAttributeSet.EMPTY;
            }
            MutableAttributeSet mAtts = (MutableAttributeSet)this.root.getAttributes();
            ev.addEdit(new AttributeUndoableEdit(this.root, newAtts, true));
            mAtts.removeAttributes(mAtts);
            mAtts.addAttributes(newAtts);
            int i = 1;
            while (i < n) {
                this.insertElement(data[i]);
                ++i;
            }
            while (this.elementStack.size() > 0) {
                this.pop();
            }
            this.finishEdit(ev);
        }

        private boolean canJoin(Element e0, Element e1) {
            boolean isLeaf1;
            boolean isLeaf0;
            boolean ret = false;
            if (e0 != null && e1 != null && (isLeaf0 = e0.isLeaf()) == (isLeaf1 = e1.isLeaf())) {
                if (isLeaf0) {
                    ret = e0.getAttributes().isEqual(e1.getAttributes());
                } else {
                    String name0 = e0.getName();
                    String name1 = e1.getName();
                    ret = name0 != null ? name0.equals(name1) : (name1 != null ? name1.equals(name0) : true);
                }
            }
            return ret;
        }

        private Element join(Element p, Element left, Element right, int rmOffs0, int rmOffs1) {
            Element joined = null;
            if (left.isLeaf() && right.isLeaf()) {
                joined = DefaultStyledDocument.this.createLeafElement(p, left.getAttributes(), left.getStartOffset(), right.getEndOffset());
            } else if (!left.isLeaf() && !right.isLeaf()) {
                Element rj;
                joined = DefaultStyledDocument.this.createBranchElement(p, left.getAttributes());
                int ljIndex = left.getElementIndex(rmOffs0);
                int rjIndex = right.getElementIndex(rmOffs1);
                Element lj = left.getElement(ljIndex);
                if (lj.getStartOffset() >= rmOffs0) {
                    lj = null;
                }
                if ((rj = right.getElement(rjIndex)).getStartOffset() == rmOffs1) {
                    rj = null;
                }
                ArrayList<Element> children = new ArrayList<Element>();
                int i = 0;
                while (i < ljIndex) {
                    children.add(this.clone(joined, left.getElement(i)));
                    ++i;
                }
                if (this.canJoin(lj, rj)) {
                    Element e = this.join(joined, lj, rj, rmOffs0, rmOffs1);
                    children.add(e);
                } else {
                    if (lj != null) {
                        children.add(this.cloneAsNecessary(joined, lj, rmOffs0, rmOffs1));
                    }
                    if (rj != null) {
                        children.add(this.cloneAsNecessary(joined, rj, rmOffs0, rmOffs1));
                    }
                }
                int n = right.getElementCount();
                int i2 = rj == null ? rjIndex : rjIndex + 1;
                while (i2 < n) {
                    children.add(this.clone(joined, right.getElement(i2)));
                    ++i2;
                }
                Element[] c = new Element[children.size()];
                c = children.toArray(c);
                ((AbstractDocument.BranchElement)joined).replace(0, 0, c);
            } else assert (false) : "Must not happen";
            return joined;
        }

        protected void changeUpdate() {
            boolean didEnd = this.split(this.offset, this.length);
            if (!didEnd) {
                while (this.elementStack.size() != 0) {
                    this.pop();
                }
                this.split(this.offset + this.length, 0);
            }
            while (this.elementStack.size() != 0) {
                this.pop();
            }
        }

        public void change(int offset, int length, AbstractDocument.DefaultDocumentEvent ev) {
            this.prepareEdit(offset, length);
            this.changeUpdate();
            this.finishEdit(ev);
        }

        public Element clone(Element parent, Element clonee) {
            Element clone = clonee;
            if (clonee instanceof AbstractDocument.BranchElement) {
                AbstractDocument.BranchElement branchEl = (AbstractDocument.BranchElement)clonee;
                AbstractDocument.BranchElement branchClone = new AbstractDocument.BranchElement(parent, branchEl.getAttributes());
                int numChildren = branchClone.getElementCount();
                Element[] cloneChildren = new Element[numChildren];
                int i = 0;
                while (i < numChildren) {
                    cloneChildren[i] = this.clone(branchClone, branchClone.getElement(i));
                    ++i;
                }
                branchClone.replace(0, 0, cloneChildren);
                clone = branchClone;
            } else if (clonee instanceof AbstractDocument.LeafElement) {
                clone = new AbstractDocument.LeafElement(parent, clonee.getAttributes(), clonee.getStartOffset(), clonee.getEndOffset());
            }
            return clone;
        }

        private Element cloneAsNecessary(Element parent, Element clonee, int rmOffs0, int rmOffs1) {
            Element cloned;
            if (clonee.isLeaf()) {
                cloned = DefaultStyledDocument.this.createLeafElement(parent, clonee.getAttributes(), clonee.getStartOffset(), clonee.getEndOffset());
            } else {
                Element e = DefaultStyledDocument.this.createBranchElement(parent, clonee.getAttributes());
                int n = clonee.getElementCount();
                ArrayList<Element> childrenList = new ArrayList<Element>(n);
                int i = 0;
                while (i < n) {
                    Element elem = clonee.getElement(i);
                    if (elem.getStartOffset() < rmOffs0 || elem.getEndOffset() > rmOffs1) {
                        childrenList.add(this.cloneAsNecessary(e, elem, rmOffs0, rmOffs1));
                    }
                    ++i;
                }
                Element[] children = new Element[childrenList.size()];
                children = childrenList.toArray(children);
                ((AbstractDocument.BranchElement)e).replace(0, 0, children);
                cloned = e;
            }
            return cloned;
        }

        public void insert(int offset, int length, ElementSpec[] data, AbstractDocument.DefaultDocumentEvent ev) {
            if (length > 0) {
                this.prepareEdit(offset, length);
                this.insertUpdate(data);
                this.finishEdit(ev);
            }
        }

        private void prepareEdit(int offset, int length) {
            this.offset = offset;
            this.pos = offset;
            this.endOffset = offset + length;
            this.length = length;
            if (this.edits == null) {
                this.edits = new ArrayList();
            } else {
                this.edits.clear();
            }
            if (this.elementStack == null) {
                this.elementStack = new Stack();
            } else {
                this.elementStack.clear();
            }
            this.fracturedParent = null;
            this.fracturedChild = null;
            this.offsetLastIndex = false;
            this.offsetLastIndexReplace = false;
        }

        private void finishEdit(AbstractDocument.DefaultDocumentEvent ev) {
            for (Edit edits : this.edits) {
                Element[] removed = new Element[edits.removed.size()];
                removed = edits.removed.toArray(removed);
                Element[] added = new Element[edits.added.size()];
                added = edits.added.toArray(added);
                int index = edits.index;
                AbstractDocument.BranchElement parent = (AbstractDocument.BranchElement)edits.e;
                parent.replace(index, removed.length, added);
                AbstractDocument.ElementEdit ee = new AbstractDocument.ElementEdit(parent, index, removed, added);
                ev.addEdit(ee);
            }
            this.edits.clear();
            this.elementStack.clear();
        }

        protected void insertUpdate(ElementSpec[] data) {
            Edit edit;
            Element current = this.root;
            int index = current.getElementIndex(this.offset);
            while (!current.isLeaf()) {
                Element child = current.getElement(index);
                int editIndex = child.isLeaf() ? index : index + 1;
                Edit edit2 = new Edit(current, editIndex);
                this.elementStack.push(edit2);
                current = child;
                index = current.getElementIndex(this.offset);
            }
            this.insertPath = new Edit[this.elementStack.size()];
            this.insertPath = this.elementStack.toArray((S[])this.insertPath);
            this.createdFracture = false;
            int i = 0;
            this.recreateLeafs = false;
            short type = data[0].getType();
            if (type == 3) {
                this.insertFirstContentTag(data);
                this.pos += data[0].length;
                i = 1;
            } else {
                this.createFracture(data);
                i = 0;
            }
            while (i < data.length) {
                this.insertElement(data[i]);
                ++i;
            }
            if (!this.createdFracture) {
                this.fracture(-1);
            }
            while (this.elementStack.size() != 0) {
                this.pop();
            }
            if (this.offsetLastIndex && this.offsetLastIndexReplace) {
                ++this.insertPath[this.insertPath.length - 1].index;
            }
            int p = this.insertPath.length - 1;
            while (p >= 0) {
                edit = this.insertPath[p];
                if (edit.e == this.fracturedParent) {
                    edit.added.add(this.fracturedChild);
                }
                if (!(edit.added.size() <= 0 && edit.removed.size() <= 0 || this.edits.contains(edit))) {
                    this.edits.add(edit);
                }
                --p;
            }
            if (this.offset == 0 && this.fracturedParent != null && data[0].getType() == 2) {
                p = 0;
                while (p < data.length && data[p].getType() == 2) {
                    ++p;
                }
                edit = this.insertPath[this.insertPath.length - p - 1];
                --edit.index;
                edit.removed.add(0, edit.e.getElement(edit.index));
            }
        }

        private void pop() {
            Element e;
            Edit edit = (Edit)this.elementStack.peek();
            this.elementStack.pop();
            if (edit.added.size() > 0 || edit.removed.size() > 0) {
                this.edits.add(edit);
            } else if (!this.elementStack.isEmpty() && (e = edit.e).getElementCount() == 0) {
                edit = (Edit)this.elementStack.peek();
                edit.added.remove(e);
            }
        }

        private void insertElement(ElementSpec spec) {
            if (this.elementStack.isEmpty()) {
                return;
            }
            Edit edit = (Edit)this.elementStack.peek();
            block0 : switch (spec.getType()) {
                case 1: {
                    switch (spec.getDirection()) {
                        case 7: {
                            if (!this.createdFracture) {
                                this.fracture(this.elementStack.size() - 1);
                            }
                            if (!edit.isFracture) {
                                Edit newEdit = new Edit(this.fracturedChild, 0, true);
                                this.elementStack.push(newEdit);
                                break block0;
                            }
                            Element el = edit.e.getElement(0);
                            Edit newEdit = new Edit(el, 0, true);
                            this.elementStack.push(newEdit);
                            break block0;
                        }
                        case 5: {
                            Element parent = edit.e.getElement(edit.index);
                            if (parent.isLeaf()) {
                                if (edit.index + 1 < edit.e.getElementCount()) {
                                    parent = edit.e.getElement(edit.index + 1);
                                } else assert (false);
                            }
                            this.elementStack.push(new Edit(parent, 0, true));
                            break block0;
                        }
                    }
                    Element branch = DefaultStyledDocument.this.createBranchElement(edit.e, spec.getAttributes());
                    edit.added.add(branch);
                    this.elementStack.push(new Edit(branch, 0));
                    break;
                }
                case 2: {
                    this.pop();
                    break;
                }
                case 3: {
                    this.insertContentTag(spec, edit);
                }
            }
        }

        private void insertFirstContentTag(ElementSpec[] data) {
            ElementSpec first = data[0];
            Edit edit = (Edit)this.elementStack.peek();
            Element current = edit.e.getElement(edit.index);
            int firstEndOffset = this.offset + first.length;
            boolean onlyContent = data.length == 1;
            switch (first.getDirection()) {
                case 4: {
                    if (current.getEndOffset() != firstEndOffset && !onlyContent) {
                        Element newEl1 = DefaultStyledDocument.this.createLeafElement(edit.e, current.getAttributes(), current.getStartOffset(), firstEndOffset);
                        edit.added.add(newEl1);
                        edit.removed.add(current);
                        if (current.getEndOffset() != this.endOffset) {
                            this.recreateLeafs = true;
                            break;
                        }
                        this.offsetLastIndex = true;
                        break;
                    }
                    this.offsetLastIndex = true;
                    this.offsetLastIndexReplace = true;
                    break;
                }
                case 5: {
                    if (this.offset == 0) break;
                    Element newEl1 = DefaultStyledDocument.this.createLeafElement(edit.e, current.getAttributes(), current.getStartOffset(), this.offset);
                    edit.added.add(newEl1);
                    Element next = edit.e.getElement(edit.index + 1);
                    newEl1 = onlyContent ? DefaultStyledDocument.this.createLeafElement(edit.e, next.getAttributes(), this.offset, next.getEndOffset()) : DefaultStyledDocument.this.createLeafElement(edit.e, next.getAttributes(), this.offset, firstEndOffset);
                    edit.added.add(newEl1);
                    edit.removed.add(current);
                    edit.removed.add(next);
                    break;
                }
                default: {
                    if (current.getStartOffset() != this.offset) {
                        Element newEl = DefaultStyledDocument.this.createLeafElement(edit.e, current.getAttributes(), current.getStartOffset(), this.offset);
                        edit.added.add(newEl);
                    }
                    edit.removed.add(current);
                    Element newEl1 = DefaultStyledDocument.this.createLeafElement(edit.e, first.getAttributes(), this.offset, firstEndOffset);
                    edit.added.add(newEl1);
                    if (current.getEndOffset() != this.endOffset) {
                        this.recreateLeafs = true;
                        break;
                    }
                    this.offsetLastIndex = true;
                }
            }
        }

        private void insertContentTag(ElementSpec tag, Edit edit) {
            int len = tag.getLength();
            short dir = tag.getDirection();
            if (dir == 5) {
                if (!edit.isFracture) {
                    Element first = null;
                    if (this.insertPath != null) {
                        int p = this.insertPath.length - 1;
                        while (p >= 0) {
                            if (this.insertPath[p] == edit) {
                                if (p == this.insertPath.length - 1) break;
                                first = edit.e.getElement(edit.index);
                                break;
                            }
                            --p;
                        }
                    }
                    if (first == null) {
                        first = edit.e.getElement(edit.index + 1);
                    }
                    Element leaf = DefaultStyledDocument.this.createLeafElement(edit.e, first.getAttributes(), this.pos, first.getEndOffset());
                    edit.added.add(leaf);
                    edit.removed.add(first);
                } else {
                    Element first = edit.e.getElement(0);
                    Element leaf = DefaultStyledDocument.this.createLeafElement(edit.e, first.getAttributes(), this.pos, first.getEndOffset());
                    edit.added.add(leaf);
                    edit.removed.add(first);
                }
            } else {
                Element leaf = DefaultStyledDocument.this.createLeafElement(edit.e, tag.getAttributes(), this.pos, this.pos + len);
                edit.added.add(leaf);
            }
            this.pos += len;
        }

        private void createFracture(ElementSpec[] data) {
            Edit edit = (Edit)this.elementStack.peek();
            Element child = edit.e.getElement(edit.index);
            if (this.offset != 0) {
                Element newChild = DefaultStyledDocument.this.createLeafElement(edit.e, child.getAttributes(), child.getStartOffset(), this.offset);
                edit.added.add(newChild);
            }
            edit.removed.add(child);
            if (child.getEndOffset() != this.endOffset) {
                this.recreateLeafs = true;
            } else {
                this.offsetLastIndex = true;
            }
        }

        private void fracture(int depth) {
            int len = this.insertPath.length;
            int lastIndex = -1;
            boolean recreate = this.recreateLeafs;
            Edit lastEdit = this.insertPath[len - 1];
            boolean childChanged = lastEdit.index + 1 < lastEdit.e.getElementCount();
            int deepestChangedIndex = recreate ? len : -1;
            int lastChangedIndex = len - 1;
            this.createdFracture = true;
            int i = len - 2;
            while (i >= 0) {
                Edit edit = this.insertPath[i];
                if (edit.added.size() > 0 || i == depth) {
                    lastIndex = i;
                    if (!recreate && childChanged) {
                        recreate = true;
                        if (deepestChangedIndex == -1) {
                            deepestChangedIndex = lastChangedIndex + 1;
                        }
                    }
                }
                if (!childChanged && edit.index < edit.e.getElementCount()) {
                    childChanged = true;
                    lastChangedIndex = i;
                }
                --i;
            }
            if (recreate) {
                if (lastIndex == -1) {
                    lastIndex = len - 1;
                }
                this.recreate(lastIndex, deepestChangedIndex);
            }
        }

        private void recreate(int startIndex, int endIndex) {
            Edit edit = this.insertPath[startIndex];
            int changeLength = this.insertPath.length;
            Object child = startIndex + 1 == changeLength ? edit.e.getElement(edit.index) : edit.e.getElement(edit.index - 1);
            Element newChild = child.isLeaf() ? DefaultStyledDocument.this.createLeafElement(edit.e, child.getAttributes(), Math.max(this.endOffset, child.getStartOffset()), child.getEndOffset()) : DefaultStyledDocument.this.createBranchElement(edit.e, child.getAttributes());
            this.fracturedParent = edit.e;
            this.fracturedChild = newChild;
            Element parent = newChild;
            while (++startIndex < endIndex) {
                Element[] children;
                int moveStartIndex;
                boolean isEnd = startIndex + 1 == endIndex;
                boolean isEndLeaf = startIndex + 1 == changeLength;
                edit = this.insertPath[startIndex];
                child = isEnd ? (this.offsetLastIndex || !isEndLeaf ? null : edit.e.getElement(edit.index)) : edit.e.getElement(edit.index - 1);
                newChild = child != null ? (child.isLeaf() ? DefaultStyledDocument.this.createLeafElement(parent, child.getAttributes(), Math.max(this.endOffset, child.getStartOffset()), child.getEndOffset()) : DefaultStyledDocument.this.createBranchElement(parent, child.getAttributes())) : null;
                int childrenToMove = edit.e.getElementCount() - edit.index;
                int childStartIndex = 1;
                if (newChild == null) {
                    if (isEndLeaf) {
                        --childrenToMove;
                        moveStartIndex = edit.index + 1;
                    } else {
                        moveStartIndex = edit.index;
                    }
                    childStartIndex = 0;
                    children = new Element[childrenToMove];
                } else {
                    if (!isEnd) {
                        ++childrenToMove;
                        moveStartIndex = edit.index;
                    } else {
                        moveStartIndex = edit.index + 1;
                    }
                    children = new Element[childrenToMove];
                    children[0] = newChild;
                }
                int c = childStartIndex;
                while (c < childrenToMove) {
                    Element toMove = edit.e.getElement(moveStartIndex++);
                    children[c] = this.recreateFracturedElement(parent, toMove);
                    edit.removed.add(toMove);
                    ++c;
                }
                ((AbstractDocument.BranchElement)parent).replace(0, 0, children);
                parent = newChild;
            }
        }

        private Element recreateFracturedElement(Element parent, Element toCopy) {
            Element recreated;
            if (toCopy.isLeaf()) {
                recreated = DefaultStyledDocument.this.createLeafElement(parent, toCopy.getAttributes(), Math.max(toCopy.getStartOffset(), this.endOffset), toCopy.getEndOffset());
            } else {
                Element newParent = DefaultStyledDocument.this.createBranchElement(parent, toCopy.getAttributes());
                int childCount = toCopy.getElementCount();
                Element[] newChildren = new Element[childCount];
                int i = 0;
                while (i < childCount) {
                    newChildren[i] = this.recreateFracturedElement(newParent, toCopy.getElement(i));
                    ++i;
                }
                ((AbstractDocument.BranchElement)newParent).replace(0, 0, newChildren);
                recreated = newParent;
            }
            return recreated;
        }

        private boolean split(int offs, int len) {
            boolean splitEnd = false;
            Element e = this.root;
            int index = e.getElementIndex(offs);
            while (!e.isLeaf()) {
                this.elementStack.push(new Edit(e, index));
                e = e.getElement(index);
                index = e.getElementIndex(offs);
            }
            Edit ec = (Edit)this.elementStack.peek();
            Element child = ec.e.getElement(ec.index);
            if (child.getStartOffset() < offs && offs < child.getEndOffset()) {
                int index0;
                int index1 = index0 = ec.index;
                if (offs + len < ec.e.getEndOffset() && len != 0) {
                    index1 = ec.e.getElementIndex(offs + len);
                    if (index1 == index0) {
                        ec.removed.add(child);
                        e = DefaultStyledDocument.this.createLeafElement(ec.e, child.getAttributes(), child.getStartOffset(), offs);
                        ec.added.add(e);
                        e = DefaultStyledDocument.this.createLeafElement(ec.e, child.getAttributes(), offs, offs + len);
                        ec.added.add(e);
                        e = DefaultStyledDocument.this.createLeafElement(ec.e, child.getAttributes(), offs + len, child.getEndOffset());
                        ec.added.add(e);
                        return true;
                    }
                    child = ec.e.getElement(index1);
                    if (offs + len == child.getStartOffset()) {
                        index1 = index0;
                    }
                    splitEnd = true;
                }
                this.pos = offs;
                child = ec.e.getElement(index0);
                ec.removed.add(child);
                e = DefaultStyledDocument.this.createLeafElement(ec.e, child.getAttributes(), child.getStartOffset(), this.pos);
                ec.added.add(e);
                e = DefaultStyledDocument.this.createLeafElement(ec.e, child.getAttributes(), this.pos, child.getEndOffset());
                ec.added.add(e);
                int i = index0 + 1;
                while (i < index1) {
                    child = ec.e.getElement(i);
                    ec.removed.add(child);
                    ec.added.add(child);
                    ++i;
                }
                if (index1 != index0) {
                    child = ec.e.getElement(index1);
                    this.pos = offs + len;
                    ec.removed.add(child);
                    e = DefaultStyledDocument.this.createLeafElement(ec.e, child.getAttributes(), child.getStartOffset(), this.pos);
                    ec.added.add(e);
                    e = DefaultStyledDocument.this.createLeafElement(ec.e, child.getAttributes(), this.pos, child.getEndOffset());
                    ec.added.add(e);
                }
            }
            return splitEnd;
        }

        class Edit {
            Element e;
            int index;
            ArrayList removed = new ArrayList();
            ArrayList added = new ArrayList();
            boolean isFracture;

            Edit(Element el, int i) {
                this(el, i, false);
            }

            Edit(Element el, int i, boolean frac) {
                this.e = el;
                this.index = i;
                this.isFracture = frac;
            }
        }
    }

    public static class ElementSpec {
        public static final short StartTagType = 1;
        public static final short EndTagType = 2;
        public static final short ContentType = 3;
        public static final short JoinPreviousDirection = 4;
        public static final short JoinNextDirection = 5;
        public static final short OriginateDirection = 6;
        public static final short JoinFractureDirection = 7;
        short type;
        short direction;
        int offset;
        int length;
        char[] content;
        AttributeSet attributes;

        public ElementSpec(AttributeSet a, short type) {
            this(a, type, 0);
        }

        public ElementSpec(AttributeSet a, short type, int len) {
            this(a, type, null, 0, len);
        }

        public ElementSpec(AttributeSet a, short type, char[] txt, int offs, int len) {
            this.attributes = a;
            this.type = type;
            this.offset = offs;
            this.length = len;
            this.content = txt;
            this.direction = (short)6;
        }

        public void setType(short type) {
            this.type = type;
        }

        public short getType() {
            return this.type;
        }

        public void setDirection(short dir) {
            this.direction = dir;
        }

        public short getDirection() {
            return this.direction;
        }

        public AttributeSet getAttributes() {
            return this.attributes;
        }

        public char[] getArray() {
            return this.content;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public String toString() {
            CPStringBuilder b = new CPStringBuilder();
            switch (this.type) {
                case 1: {
                    b.append("StartTag");
                    break;
                }
                case 2: {
                    b.append("EndTag");
                    break;
                }
                case 3: {
                    b.append("Content");
                    break;
                }
                default: {
                    b.append("??");
                }
            }
            b.append(':');
            switch (this.direction) {
                case 4: {
                    b.append("JoinPrevious");
                    break;
                }
                case 5: {
                    b.append("JoinNext");
                    break;
                }
                case 6: {
                    b.append("Originate");
                    break;
                }
                case 7: {
                    b.append("Fracture");
                    break;
                }
                default: {
                    b.append("??");
                }
            }
            b.append(':');
            b.append(this.length);
            return b.toString();
        }
    }

    protected class SectionElement
    extends AbstractDocument.BranchElement {
        public SectionElement() {
            super(null, null);
        }

        public String getName() {
            return "section";
        }
    }

    private class StyleChangeListener
    implements ChangeListener {
        private StyleChangeListener() {
        }

        public void stateChanged(ChangeEvent event) {
            Style style = (Style)event.getSource();
            DefaultStyledDocument.this.styleChanged(style);
        }
    }
}

