/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import gnu.java.lang.CPStringBuilder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeMap<K, V>
extends AbstractMap<K, V>
implements NavigableMap<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 919286545866124006L;
    static final int RED = -1;
    static final int BLACK = 1;
    static final Node nil = new Node<Object, Object>(null, null, 1);
    private transient Node root;
    transient int size;
    private transient Set<Map.Entry<K, V>> entries;
    private transient NavigableMap<K, V> descendingMap;
    private transient NavigableSet<K> nKeys;
    transient int modCount;
    final Comparator<? super K> comparator;

    static {
        TreeMap.nil.parent = nil;
        TreeMap.nil.left = nil;
        TreeMap.nil.right = nil;
    }

    public TreeMap() {
        this((Comparator<K>)null);
    }

    public TreeMap(Comparator<? super K> c) {
        this.comparator = c;
        this.fabricateTree(0);
    }

    public TreeMap(Map<? extends K, ? extends V> map) {
        this((Comparator<? extends K>)null);
        this.putAll(map);
    }

    public TreeMap(SortedMap<K, ? extends V> sm) {
        this(sm.comparator());
        int pos = sm.size();
        Iterator itr = sm.entrySet().iterator();
        super.fabricateTree(pos);
        Node<K, V> node2 = this.firstNode();
        while (--pos >= 0) {
            Map.Entry me = itr.next();
            node2.key = me.getKey();
            node2.value = me.getValue();
            node2 = this.successor(node2);
        }
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            ++this.modCount;
            this.root = nil;
            this.size = 0;
        }
    }

    @Override
    public Object clone() {
        TreeMap copy = null;
        try {
            copy = (TreeMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        copy.entries = null;
        copy.fabricateTree(this.size);
        Node<K, V> node2 = this.firstNode();
        Node<K, V> cnode = copy.firstNode();
        while (node2 != nil) {
            cnode.key = node2.key;
            cnode.value = node2.value;
            node2 = this.successor(node2);
            cnode = copy.successor(cnode);
        }
        return copy;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getNode(key) != nil;
    }

    @Override
    public boolean containsValue(Object value) {
        Node<K, V> node2 = this.firstNode();
        while (node2 != nil) {
            if (TreeMap.equals(value, node2.value)) {
                return true;
            }
            node2 = this.successor(node2);
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new NavigableEntrySet();
        }
        return this.entries;
    }

    @Override
    public K firstKey() {
        if (this.root == nil) {
            throw new NoSuchElementException();
        }
        return (K)this.firstNode().key;
    }

    @Override
    public V get(Object key) {
        return (V)this.getNode(key).value;
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        return this.headMap(toKey, false);
    }

    @Override
    public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        return new SubMap(nil, inclusive ? this.successor(this.getNode(toKey)).key : toKey);
    }

    @Override
    public Set<K> keySet() {
        if (this.keys == null) {
            this.keys = new KeySet(null, null);
        }
        return this.keys;
    }

    @Override
    public K lastKey() {
        if (this.root == nil) {
            throw new NoSuchElementException("empty");
        }
        return (K)this.lastNode().key;
    }

    @Override
    public V put(K key, V value) {
        Node current = this.root;
        Node parent = nil;
        int comparison = 0;
        while (current != nil) {
            parent = current;
            comparison = this.compare(key, current.key);
            if (comparison > 0) {
                current = current.right;
                continue;
            }
            if (comparison < 0) {
                current = current.left;
                continue;
            }
            return current.setValue(value);
        }
        Node<K, V> n = new Node<K, V>(key, value, -1);
        n.parent = parent;
        ++this.modCount;
        ++this.size;
        if (parent == nil) {
            this.root = n;
            return null;
        }
        if (comparison > 0) {
            parent.right = n;
        } else {
            parent.left = n;
        }
        this.insertFixup(n);
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        Iterator<Map.Entry<K, V>> itr = m.entrySet().iterator();
        int pos = m.size();
        while (--pos >= 0) {
            Map.Entry<K, V> e = itr.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        Node<Object, V> n = this.getNode(key);
        if (n == nil) {
            return null;
        }
        Object result = n.value;
        this.removeNode(n);
        return (V)result;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap(fromKey, true, toKey, false);
    }

    @Override
    public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return new SubMap(fromInclusive ? fromKey : this.successor(this.getNode(fromKey)).key, toInclusive ? this.successor(this.getNode(toKey)).key : toKey);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        return this.tailMap(fromKey, true);
    }

    @Override
    public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        return new SubMap(inclusive ? fromKey : this.successor(this.getNode(fromKey)).key, nil);
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public int size() {
                    return TreeMap.this.size;
                }

                @Override
                public Iterator<V> iterator() {
                    return new TreeIterator(1);
                }

                @Override
                public void clear() {
                    TreeMap.this.clear();
                }
            };
        }
        return this.values;
    }

    final int compare(K o1, K o2) {
        return this.comparator == null ? ((Comparable)o1).compareTo(o2) : this.comparator.compare(o1, o2);
    }

    private void deleteFixup(Node<K, V> node2, Node<K, V> parent) {
        while (node2 != this.root && node2.color == 1) {
            Node sibling;
            if (node2 == parent.left) {
                sibling = parent.right;
                if (sibling.color == -1) {
                    sibling.color = 1;
                    parent.color = -1;
                    this.rotateLeft(parent);
                    sibling = parent.right;
                }
                if (sibling.left.color == 1 && sibling.right.color == 1) {
                    sibling.color = -1;
                    node2 = parent;
                    parent = parent.parent;
                    continue;
                }
                if (sibling.right.color == 1) {
                    sibling.left.color = 1;
                    sibling.color = -1;
                    this.rotateRight(sibling);
                    sibling = parent.right;
                }
                sibling.color = parent.color;
                parent.color = 1;
                sibling.right.color = 1;
                this.rotateLeft(parent);
                node2 = this.root;
                continue;
            }
            sibling = parent.left;
            if (sibling.color == -1) {
                sibling.color = 1;
                parent.color = -1;
                this.rotateRight(parent);
                sibling = parent.left;
            }
            if (sibling.right.color == 1 && sibling.left.color == 1) {
                sibling.color = -1;
                node2 = parent;
                parent = parent.parent;
                continue;
            }
            if (sibling.left.color == 1) {
                sibling.right.color = 1;
                sibling.color = -1;
                this.rotateLeft(sibling);
                sibling = parent.left;
            }
            sibling.color = parent.color;
            parent.color = 1;
            sibling.left.color = 1;
            this.rotateRight(parent);
            node2 = this.root;
        }
        node2.color = 1;
    }

    private void fabricateTree(int count) {
        Node next;
        Node<Object, Object> right;
        Node<Object, Object> left;
        int i;
        if (count == 0) {
            this.root = nil;
            this.size = 0;
            return;
        }
        this.root = new Node<Object, Object>(null, null, 1);
        this.size = count;
        Node row = this.root;
        int rowsize = 2;
        while (rowsize + rowsize <= count) {
            Node parent = row;
            Node<Object, Object> last = null;
            i = 0;
            while (i < rowsize) {
                left = new Node<Object, Object>(null, null, 1);
                right = new Node<Object, Object>(null, null, 1);
                left.parent = parent;
                left.right = right;
                right.parent = parent;
                parent.left = left;
                next = parent.right;
                parent.right = right;
                parent = next;
                if (last != null) {
                    last.right = left;
                }
                last = right;
                i += 2;
            }
            row = row.left;
            rowsize <<= 1;
        }
        int overflow = count - rowsize;
        Node parent = row;
        i = 0;
        while (i < overflow) {
            left = new Node<Object, Object>(null, null, -1);
            right = new Node<Object, Object>(null, null, -1);
            left.parent = parent;
            right.parent = parent;
            parent.left = left;
            next = parent.right;
            parent.right = right;
            parent = next;
            i += 2;
        }
        if (i - overflow == 0) {
            left = new Node<Object, Object>(null, null, -1);
            left.parent = parent;
            parent.left = left;
            parent = parent.right;
            left.parent.right = nil;
        }
        while (parent != nil) {
            Node next2 = parent.right;
            parent.right = nil;
            parent = next2;
        }
    }

    final Node<K, V> firstNode() {
        Node node2 = this.root;
        while (node2.left != nil) {
            node2 = node2.left;
        }
        return node2;
    }

    final Node<K, V> getNode(K key) {
        Node current = this.root;
        while (current != nil) {
            int comparison = this.compare(key, current.key);
            if (comparison > 0) {
                current = current.right;
                continue;
            }
            if (comparison < 0) {
                current = current.left;
                continue;
            }
            return current;
        }
        return current;
    }

    final Node<K, V> highestLessThan(K key) {
        return this.highestLessThan(key, false);
    }

    final Node<K, V> highestLessThan(K key, boolean equal) {
        if (key == nil) {
            return this.lastNode();
        }
        Node<K, V> last = nil;
        Node current = this.root;
        int comparison = 0;
        while (current != nil) {
            last = current;
            comparison = this.compare(key, current.key);
            if (comparison > 0) {
                current = current.right;
                continue;
            }
            if (comparison < 0) {
                current = current.left;
                continue;
            }
            return equal ? last : this.predecessor(last);
        }
        return comparison < 0 ? this.predecessor(last) : last;
    }

    private void insertFixup(Node<K, V> n) {
        while (n.parent.color == -1 && n.parent.parent != nil) {
            Node uncle;
            if (n.parent == n.parent.parent.left) {
                uncle = n.parent.parent.right;
                if (uncle.color == -1) {
                    n.parent.color = 1;
                    uncle.color = 1;
                    uncle.parent.color = -1;
                    n = uncle.parent;
                    continue;
                }
                if (n == n.parent.right) {
                    n = n.parent;
                    this.rotateLeft(n);
                }
                n.parent.color = 1;
                n.parent.parent.color = -1;
                this.rotateRight(n.parent.parent);
                continue;
            }
            uncle = n.parent.parent.left;
            if (uncle.color == -1) {
                n.parent.color = 1;
                uncle.color = 1;
                uncle.parent.color = -1;
                n = uncle.parent;
                continue;
            }
            if (n == n.parent.left) {
                n = n.parent;
                this.rotateRight(n);
            }
            n.parent.color = 1;
            n.parent.parent.color = -1;
            this.rotateLeft(n.parent.parent);
        }
        this.root.color = 1;
    }

    private Node<K, V> lastNode() {
        Node node2 = this.root;
        while (node2.right != nil) {
            node2 = node2.right;
        }
        return node2;
    }

    final Node<K, V> lowestGreaterThan(K key, boolean first) {
        return this.lowestGreaterThan(key, first, true);
    }

    final Node<K, V> lowestGreaterThan(K key, boolean first, boolean equal) {
        if (key == nil) {
            return first ? this.firstNode() : nil;
        }
        Node<K, V> last = nil;
        Node current = this.root;
        int comparison = 0;
        while (current != nil) {
            last = current;
            comparison = this.compare(key, current.key);
            if (comparison > 0) {
                current = current.right;
                continue;
            }
            if (comparison < 0) {
                current = current.left;
                continue;
            }
            return equal ? current : this.successor(current);
        }
        return comparison > 0 ? this.successor(last) : last;
    }

    private Node<K, V> predecessor(Node<K, V> node2) {
        if (node2.left != nil) {
            node2 = node2.left;
            while (node2.right != nil) {
                node2 = node2.right;
            }
            return node2;
        }
        Node parent = node2.parent;
        while (node2 == parent.left) {
            node2 = parent;
            parent = node2.parent;
        }
        return parent;
    }

    final void putFromObjStream(ObjectInputStream s, int count, boolean readValues) throws IOException, ClassNotFoundException {
        this.fabricateTree(count);
        Node<K, V> node2 = this.firstNode();
        while (--count >= 0) {
            node2.key = s.readObject();
            node2.value = readValues ? s.readObject() : "";
            node2 = this.successor(node2);
        }
    }

    final void putKeysLinear(Iterator<K> keys, int count) {
        this.fabricateTree(count);
        Node<K, V> node2 = this.firstNode();
        while (--count >= 0) {
            node2.key = keys.next();
            node2.value = "";
            node2 = this.successor(node2);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.putFromObjStream(s, size, true);
    }

    final void removeNode(Node<K, V> node2) {
        Node child;
        Node<K, V> splice;
        ++this.modCount;
        --this.size;
        if (node2.left == nil) {
            splice = node2;
            child = node2.right;
        } else if (node2.right == nil) {
            splice = node2;
            child = node2.left;
        } else {
            splice = node2.left;
            while (splice.right != nil) {
                splice = splice.right;
            }
            child = splice.left;
            node2.key = splice.key;
            node2.value = splice.value;
        }
        Node parent = splice.parent;
        if (child != nil) {
            child.parent = parent;
        }
        if (parent == nil) {
            this.root = child;
            return;
        }
        if (splice == parent.left) {
            parent.left = child;
        } else {
            parent.right = child;
        }
        if (splice.color == 1) {
            this.deleteFixup(child, parent);
        }
    }

    private void rotateLeft(Node<K, V> node2) {
        Node child = node2.right;
        node2.right = child.left;
        if (child.left != nil) {
            child.left.parent = node2;
        }
        child.parent = node2.parent;
        if (node2.parent != nil) {
            if (node2 == node2.parent.left) {
                node2.parent.left = child;
            } else {
                node2.parent.right = child;
            }
        } else {
            this.root = child;
        }
        child.left = node2;
        node2.parent = child;
    }

    private void rotateRight(Node<K, V> node2) {
        Node child = node2.left;
        node2.left = child.right;
        if (child.right != nil) {
            child.right.parent = node2;
        }
        child.parent = node2.parent;
        if (node2.parent != nil) {
            if (node2 == node2.parent.right) {
                node2.parent.right = child;
            } else {
                node2.parent.left = child;
            }
        } else {
            this.root = child;
        }
        child.right = node2;
        node2.parent = child;
    }

    final Node<K, V> successor(Node<K, V> node2) {
        if (node2.right != nil) {
            node2 = node2.right;
            while (node2.left != nil) {
                node2 = node2.left;
            }
            return node2;
        }
        Node parent = node2.parent;
        while (node2 == parent.right) {
            node2 = parent;
            parent = parent.parent;
        }
        return parent;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Node<K, V> node2 = this.firstNode();
        s.writeInt(this.size);
        while (node2 != nil) {
            s.writeObject(node2.key);
            s.writeObject(node2.value);
            node2 = this.successor(node2);
        }
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        Node<K, V> n = this.lowestGreaterThan(key, false);
        return n == nil ? null : n;
    }

    @Override
    public K ceilingKey(K key) {
        Map.Entry<K, V> e = this.ceilingEntry(key);
        return e == null ? null : (K)e.getKey();
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        if (this.descendingMap == null) {
            this.descendingMap = new DescendingMap<K, V>(this);
        }
        return this.descendingMap;
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        Node<K, V> n = this.firstNode();
        return n == nil ? null : n;
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        Node<K, V> n = this.highestLessThan(key, true);
        return n == nil ? null : n;
    }

    @Override
    public K floorKey(K key) {
        Map.Entry<K, V> e = this.floorEntry(key);
        return e == null ? null : (K)e.getKey();
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        Node<K, V> n = this.lowestGreaterThan(key, false, false);
        return n == nil ? null : n;
    }

    @Override
    public K higherKey(K key) {
        Map.Entry<K, V> e = this.higherEntry(key);
        return e == null ? null : (K)e.getKey();
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        Node<K, V> n = this.lastNode();
        return n == nil ? null : n;
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        Node<K, V> n = this.highestLessThan(key);
        return n == nil ? null : n;
    }

    @Override
    public K lowerKey(K key) {
        Map.Entry<K, V> e = this.lowerEntry(key);
        return e == null ? null : (K)e.getKey();
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        if (this.nKeys == null) {
            this.nKeys = new NavigableKeySet();
        }
        return this.nKeys;
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        Map.Entry<K, V> e = this.firstEntry();
        if (e != null) {
            this.removeNode((Node)e);
        }
        return e;
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        Map.Entry<K, V> e = this.lastEntry();
        if (e != null) {
            this.removeNode((Node)e);
        }
        return e;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DescendingMap<DK, DV>
    implements NavigableMap<DK, DV> {
        private Set<Map.Entry<DK, DV>> entries;
        private Set<DK> keys;
        private NavigableSet<DK> nKeys;
        private Collection<DV> values;
        private NavigableMap<DK, DV> map;

        public DescendingMap(NavigableMap<DK, DV> map) {
            this.map = map;
        }

        @Override
        public Map.Entry<DK, DV> ceilingEntry(DK key) {
            return this.map.floorEntry(key);
        }

        @Override
        public DK ceilingKey(DK key) {
            return this.map.floorKey(key);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Comparator<? super DK> comparator() {
            return Collections.reverseOrder(this.map.comparator());
        }

        @Override
        public boolean containsKey(Object o) {
            return this.map.containsKey(o);
        }

        @Override
        public boolean containsValue(Object o) {
            return this.map.containsValue(o);
        }

        @Override
        public NavigableSet<DK> descendingKeySet() {
            return this.descendingMap().navigableKeySet();
        }

        @Override
        public NavigableMap<DK, DV> descendingMap() {
            return this.map;
        }

        @Override
        public Set<Map.Entry<DK, DV>> entrySet() {
            if (this.entries == null) {
                this.entries = new DescendingSet<Map.Entry<DK, DV>>((NavigableSet)this.map.entrySet());
            }
            return this.entries;
        }

        @Override
        public boolean equals(Object o) {
            return this.map.equals(o);
        }

        @Override
        public Map.Entry<DK, DV> firstEntry() {
            return this.map.lastEntry();
        }

        @Override
        public DK firstKey() {
            return (DK)this.map.lastKey();
        }

        @Override
        public Map.Entry<DK, DV> floorEntry(DK key) {
            return this.map.ceilingEntry(key);
        }

        @Override
        public DK floorKey(DK key) {
            return this.map.ceilingKey(key);
        }

        @Override
        public DV get(Object key) {
            return (DV)this.map.get(key);
        }

        @Override
        public int hashCode() {
            return this.map.hashCode();
        }

        @Override
        public SortedMap<DK, DV> headMap(DK toKey) {
            return this.headMap(toKey, false);
        }

        @Override
        public NavigableMap<DK, DV> headMap(DK toKey, boolean inclusive) {
            return new DescendingMap<DK, DV>(this.map.tailMap(toKey, inclusive));
        }

        @Override
        public Map.Entry<DK, DV> higherEntry(DK key) {
            return this.map.lowerEntry(key);
        }

        @Override
        public DK higherKey(DK key) {
            return this.map.lowerKey(key);
        }

        @Override
        public Set<DK> keySet() {
            if (this.keys == null) {
                this.keys = new DescendingSet<DK>(this.map.navigableKeySet());
            }
            return this.keys;
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Map.Entry<DK, DV> lastEntry() {
            return this.map.firstEntry();
        }

        @Override
        public DK lastKey() {
            return (DK)this.map.firstKey();
        }

        @Override
        public Map.Entry<DK, DV> lowerEntry(DK key) {
            return this.map.higherEntry(key);
        }

        @Override
        public DK lowerKey(DK key) {
            return this.map.higherKey(key);
        }

        @Override
        public NavigableSet<DK> navigableKeySet() {
            if (this.nKeys == null) {
                this.nKeys = new DescendingSet<DK>(this.map.navigableKeySet());
            }
            return this.nKeys;
        }

        @Override
        public Map.Entry<DK, DV> pollFirstEntry() {
            return this.pollLastEntry();
        }

        @Override
        public Map.Entry<DK, DV> pollLastEntry() {
            return this.pollFirstEntry();
        }

        @Override
        public DV put(DK key, DV value) {
            return this.map.put(key, value);
        }

        @Override
        public void putAll(Map<? extends DK, ? extends DV> m) {
            this.map.putAll(m);
        }

        @Override
        public DV remove(Object key) {
            return (DV)this.map.remove(key);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public SortedMap<DK, DV> subMap(DK fromKey, DK toKey) {
            return this.subMap(fromKey, true, toKey, false);
        }

        @Override
        public NavigableMap<DK, DV> subMap(DK fromKey, boolean fromInclusive, DK toKey, boolean toInclusive) {
            return new DescendingMap<DK, DV>(this.map.subMap(fromKey, fromInclusive, toKey, toInclusive));
        }

        @Override
        public SortedMap<DK, DV> tailMap(DK fromKey) {
            return this.tailMap(fromKey, true);
        }

        @Override
        public NavigableMap<DK, DV> tailMap(DK fromKey, boolean inclusive) {
            return new DescendingMap<DK, DV>(this.map.headMap(fromKey, inclusive));
        }

        public String toString() {
            CPStringBuilder r = new CPStringBuilder("{");
            for (Map.Entry<DK, DV> e : this.entrySet()) {
                r.append(e.getKey());
                r.append('=');
                r.append(e.getValue());
                r.append(", ");
            }
            r.replace(r.length() - 2, r.length(), "}");
            return r.toString();
        }

        @Override
        public Collection<DV> values() {
            if (this.values == null) {
                this.values = new AbstractCollection(){

                    @Override
                    public int size() {
                        return this.size();
                    }

                    @Override
                    public Iterator<DV> iterator() {
                        return new Iterator<DV>(){
                            private Map.Entry<DK, DV> last;
                            private Map.Entry<DK, DV> next;
                            {
                                this.next = DescendingMap.this.firstEntry();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.next != null;
                            }

                            @Override
                            public DV next() {
                                if (this.next == null) {
                                    throw new NoSuchElementException();
                                }
                                this.last = this.next;
                                this.next = DescendingMap.this.higherEntry(this.last.getKey());
                                return this.last.getValue();
                            }

                            @Override
                            public void remove() {
                                if (this.last == null) {
                                    throw new IllegalStateException();
                                }
                                DescendingMap.this.remove(this.last.getKey());
                                this.last = null;
                            }
                        };
                    }

                    @Override
                    public void clear() {
                        this.clear();
                    }
                };
            }
            return this.values;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DescendingSet<D>
    implements NavigableSet<D> {
        private NavigableSet<D> set;

        public DescendingSet(NavigableSet<D> set) {
            this.set = set;
        }

        @Override
        public boolean add(D e) {
            return this.set.add(e);
        }

        @Override
        public boolean addAll(Collection<? extends D> c) {
            return this.set.addAll(c);
        }

        @Override
        public D ceiling(D e) {
            return this.set.floor(e);
        }

        @Override
        public void clear() {
            this.set.clear();
        }

        @Override
        public Comparator<? super D> comparator() {
            return Collections.reverseOrder(this.set.comparator());
        }

        @Override
        public boolean contains(Object o) {
            return this.set.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.set.containsAll(c);
        }

        @Override
        public Iterator<D> descendingIterator() {
            return this.descendingSet().iterator();
        }

        @Override
        public NavigableSet<D> descendingSet() {
            return this.set;
        }

        @Override
        public boolean equals(Object o) {
            return this.set.equals(o);
        }

        @Override
        public D first() {
            return (D)this.set.last();
        }

        @Override
        public D floor(D e) {
            return this.set.ceiling(e);
        }

        @Override
        public int hashCode() {
            return this.set.hashCode();
        }

        @Override
        public SortedSet<D> headSet(D to) {
            return this.headSet(to, false);
        }

        @Override
        public NavigableSet<D> headSet(D to, boolean inclusive) {
            return new DescendingSet<D>(this.set.tailSet(to, inclusive));
        }

        @Override
        public D higher(D e) {
            return this.set.lower(e);
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        public Iterator<D> iterator() {
            return new Iterator<D>(){
                private D last;
                private D next;
                {
                    this.next = DescendingSet.this.first();
                }

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }

                @Override
                public D next() {
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                    this.last = this.next;
                    this.next = DescendingSet.this.higher(this.last);
                    return this.last;
                }

                @Override
                public void remove() {
                    if (this.last == null) {
                        throw new IllegalStateException();
                    }
                    DescendingSet.this.remove(this.last);
                    this.last = null;
                }
            };
        }

        @Override
        public D last() {
            return (D)this.set.first();
        }

        @Override
        public D lower(D e) {
            return this.set.higher(e);
        }

        @Override
        public D pollFirst() {
            return this.set.pollLast();
        }

        @Override
        public D pollLast() {
            return this.set.pollFirst();
        }

        @Override
        public boolean remove(Object o) {
            return this.set.remove(o);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.set.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.set.retainAll(c);
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public SortedSet<D> subSet(D from, D to) {
            return this.subSet(from, true, to, false);
        }

        @Override
        public NavigableSet<D> subSet(D from, boolean fromInclusive, D to, boolean toInclusive) {
            return new DescendingSet<D>(this.set.subSet(from, fromInclusive, to, toInclusive));
        }

        @Override
        public SortedSet<D> tailSet(D from) {
            return this.tailSet(from, true);
        }

        @Override
        public NavigableSet<D> tailSet(D from, boolean inclusive) {
            return new DescendingSet<D>(this.set.headSet(from, inclusive));
        }

        @Override
        public Object[] toArray() {
            Object[] array = this.set.toArray();
            Arrays.sort(array, this.comparator());
            return array;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] array = this.set.toArray(a);
            Arrays.sort(array, this.comparator());
            return array;
        }

        public String toString() {
            CPStringBuilder r = new CPStringBuilder("[");
            for (D o : this) {
                if (o == this) {
                    r.append("<this>");
                } else {
                    r.append(o);
                }
                r.append(", ");
            }
            r.replace(r.length() - 2, r.length(), "]");
            return r.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return TreeMap.this.size;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new TreeIterator(2);
        }

        @Override
        public void clear() {
            TreeMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry me = (Map.Entry)o;
            Node n = TreeMap.this.getNode(me.getKey());
            return n != nil && AbstractSet.equals(me.getValue(), n.value);
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry me = (Map.Entry)o;
            Node n = TreeMap.this.getNode(me.getKey());
            if (n != nil && AbstractSet.equals(me.getValue(), n.value)) {
                TreeMap.this.removeNode(n);
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public int size() {
            return TreeMap.this.size;
        }

        @Override
        public Iterator<K> iterator() {
            return new TreeIterator(0);
        }

        @Override
        public void clear() {
            TreeMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return TreeMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object key) {
            Node n = TreeMap.this.getNode(key);
            if (n == nil) {
                return false;
            }
            TreeMap.this.removeNode(n);
            return true;
        }

        /* synthetic */ KeySet(KeySet keySet, KeySet keySet2) {
            this();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class NavigableEntrySet
    extends EntrySet
    implements NavigableSet<Map.Entry<K, V>> {
        private NavigableEntrySet() {
        }

        @Override
        public Map.Entry<K, V> ceiling(Map.Entry<K, V> e) {
            return TreeMap.this.ceilingEntry(e.getKey());
        }

        @Override
        public Comparator<? super Map.Entry<K, V>> comparator() {
            return new Comparator<Map.Entry<K, V>>(){

                @Override
                public int compare(Map.Entry<K, V> t1, Map.Entry<K, V> t2) {
                    return ((NavigableEntrySet)NavigableEntrySet.this).TreeMap.this.comparator.compare(t1.getKey(), t2.getKey());
                }
            };
        }

        @Override
        public Iterator<Map.Entry<K, V>> descendingIterator() {
            return this.descendingSet().iterator();
        }

        @Override
        public NavigableSet<Map.Entry<K, V>> descendingSet() {
            return new DescendingSet(this);
        }

        @Override
        public Map.Entry<K, V> first() {
            return TreeMap.this.firstEntry();
        }

        @Override
        public Map.Entry<K, V> floor(Map.Entry<K, V> e) {
            return TreeMap.this.floorEntry(e.getKey());
        }

        @Override
        public SortedSet<Map.Entry<K, V>> headSet(Map.Entry<K, V> to) {
            return this.headSet(to, false);
        }

        @Override
        public NavigableSet<Map.Entry<K, V>> headSet(Map.Entry<K, V> to, boolean inclusive) {
            return (NavigableSet)TreeMap.this.headMap(to.getKey(), inclusive).entrySet();
        }

        @Override
        public Map.Entry<K, V> higher(Map.Entry<K, V> e) {
            return TreeMap.this.higherEntry(e.getKey());
        }

        @Override
        public Map.Entry<K, V> last() {
            return TreeMap.this.lastEntry();
        }

        @Override
        public Map.Entry<K, V> lower(Map.Entry<K, V> e) {
            return TreeMap.this.lowerEntry(e.getKey());
        }

        @Override
        public Map.Entry<K, V> pollFirst() {
            return TreeMap.this.pollFirstEntry();
        }

        @Override
        public Map.Entry<K, V> pollLast() {
            return TreeMap.this.pollLastEntry();
        }

        @Override
        public SortedSet<Map.Entry<K, V>> subSet(Map.Entry<K, V> from, Map.Entry<K, V> to) {
            return this.subSet(from, true, to, false);
        }

        @Override
        public NavigableSet<Map.Entry<K, V>> subSet(Map.Entry<K, V> from, boolean fromInclusive, Map.Entry<K, V> to, boolean toInclusive) {
            return (NavigableSet)TreeMap.this.subMap(from.getKey(), fromInclusive, to.getKey(), toInclusive).entrySet();
        }

        @Override
        public SortedSet<Map.Entry<K, V>> tailSet(Map.Entry<K, V> from) {
            return this.tailSet(from, true);
        }

        @Override
        public NavigableSet<Map.Entry<K, V>> tailSet(Map.Entry<K, V> from, boolean inclusive) {
            return TreeMap.this.tailMap(from.getKey(), inclusive).navigableKeySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class NavigableKeySet
    extends KeySet
    implements NavigableSet<K> {
        private NavigableKeySet() {
        }

        @Override
        public K ceiling(K k) {
            return TreeMap.this.ceilingKey(k);
        }

        @Override
        public Comparator<? super K> comparator() {
            return TreeMap.this.comparator;
        }

        @Override
        public Iterator<K> descendingIterator() {
            return this.descendingSet().iterator();
        }

        @Override
        public NavigableSet<K> descendingSet() {
            return new DescendingSet(this);
        }

        @Override
        public K first() {
            return TreeMap.this.firstKey();
        }

        @Override
        public K floor(K k) {
            return TreeMap.this.floorKey(k);
        }

        @Override
        public SortedSet<K> headSet(K to) {
            return this.headSet((K)to, false);
        }

        @Override
        public NavigableSet<K> headSet(K to, boolean inclusive) {
            return TreeMap.this.headMap(to, inclusive).navigableKeySet();
        }

        @Override
        public K higher(K k) {
            return TreeMap.this.higherKey(k);
        }

        @Override
        public K last() {
            return TreeMap.this.lastKey();
        }

        @Override
        public K lower(K k) {
            return TreeMap.this.lowerKey(k);
        }

        @Override
        public K pollFirst() {
            return TreeMap.this.pollFirstEntry().getKey();
        }

        @Override
        public K pollLast() {
            return TreeMap.this.pollLastEntry().getKey();
        }

        @Override
        public SortedSet<K> subSet(K from, K to) {
            return this.subSet((K)from, true, (K)to, false);
        }

        @Override
        public NavigableSet<K> subSet(K from, boolean fromInclusive, K to, boolean toInclusive) {
            return TreeMap.this.subMap(from, fromInclusive, to, toInclusive).navigableKeySet();
        }

        @Override
        public SortedSet<K> tailSet(K from) {
            return this.tailSet((K)from, true);
        }

        @Override
        public NavigableSet<K> tailSet(K from, boolean inclusive) {
            return TreeMap.this.tailMap(from, inclusive).navigableKeySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Node<K, V>
    extends AbstractMap.SimpleEntry<K, V> {
        int color;
        Node<K, V> left = nil;
        Node<K, V> right = nil;
        Node<K, V> parent = nil;

        Node(K key, V value, int color) {
            super(key, value);
            this.color = color;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SubMap
    extends AbstractMap<K, V>
    implements NavigableMap<K, V> {
        final K minKey;
        final K maxKey;
        private Set<Map.Entry<K, V>> entries;
        private NavigableMap<K, V> descendingMap;
        private NavigableSet<K> nKeys;

        SubMap(K minKey, K maxKey) {
            if (minKey != nil && maxKey != nil && TreeMap.this.compare(minKey, maxKey) > 0) {
                throw new IllegalArgumentException("fromKey > toKey");
            }
            this.minKey = minKey;
            this.maxKey = maxKey;
        }

        boolean keyInRange(K key) {
            return !(this.minKey != nil && TreeMap.this.compare(key, this.minKey) < 0 || this.maxKey != nil && TreeMap.this.compare(key, this.maxKey) >= 0);
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K key) {
            Map.Entry n = TreeMap.this.ceilingEntry(key);
            if (n != null && this.keyInRange(n.getKey())) {
                return n;
            }
            return null;
        }

        @Override
        public K ceilingKey(K key) {
            Object found = TreeMap.this.ceilingKey(key);
            if (this.keyInRange(found)) {
                return found;
            }
            return null;
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return this.descendingMap().navigableKeySet();
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            if (this.descendingMap == null) {
                this.descendingMap = new DescendingMap(this);
            }
            return this.descendingMap;
        }

        @Override
        public void clear() {
            Node next = TreeMap.this.lowestGreaterThan(this.minKey, true);
            Node max = TreeMap.this.lowestGreaterThan(this.maxKey, false);
            while (next != max) {
                Node current = next;
                next = TreeMap.this.successor(current);
                TreeMap.this.removeNode(current);
            }
        }

        @Override
        public Comparator<? super K> comparator() {
            return TreeMap.this.comparator;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.keyInRange(key) && TreeMap.this.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            Node node2 = TreeMap.this.lowestGreaterThan(this.minKey, true);
            Node max = TreeMap.this.lowestGreaterThan(this.maxKey, false);
            while (node2 != max) {
                if (SubMap.equals(value, node2.getValue())) {
                    return true;
                }
                node2 = TreeMap.this.successor(node2);
            }
            return false;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entries == null) {
                this.entries = new NavigableEntrySet();
            }
            return this.entries;
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            Node node2 = TreeMap.this.lowestGreaterThan(this.minKey, true);
            if (node2 == nil || !this.keyInRange(node2.key)) {
                return null;
            }
            return node2;
        }

        @Override
        public K firstKey() {
            Map.Entry e = this.firstEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.getKey();
        }

        @Override
        public Map.Entry<K, V> floorEntry(K key) {
            Map.Entry n = TreeMap.this.floorEntry(key);
            if (n != null && this.keyInRange(n.getKey())) {
                return n;
            }
            return null;
        }

        @Override
        public K floorKey(K key) {
            Object found = TreeMap.this.floorKey(key);
            if (this.keyInRange(found)) {
                return found;
            }
            return null;
        }

        @Override
        public V get(Object key) {
            if (this.keyInRange(key)) {
                return TreeMap.this.get(key);
            }
            return null;
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            return this.headMap(toKey, false);
        }

        @Override
        public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
            if (!this.keyInRange(toKey)) {
                throw new IllegalArgumentException("Key outside submap range");
            }
            return new SubMap(this.minKey, inclusive ? TreeMap.this.successor(TreeMap.this.getNode(toKey)).key : toKey);
        }

        @Override
        public Set<K> keySet() {
            if (this.keys == null) {
                this.keys = new KeySet(null, null);
            }
            return this.keys;
        }

        @Override
        public Map.Entry<K, V> higherEntry(K key) {
            Map.Entry n = TreeMap.this.higherEntry(key);
            if (n != null && this.keyInRange(n.getKey())) {
                return n;
            }
            return null;
        }

        @Override
        public K higherKey(K key) {
            Object found = TreeMap.this.higherKey(key);
            if (this.keyInRange(found)) {
                return found;
            }
            return null;
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            return this.lowerEntry(this.maxKey);
        }

        @Override
        public K lastKey() {
            Map.Entry e = this.lastEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.getKey();
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K key) {
            Map.Entry n = TreeMap.this.lowerEntry(key);
            if (n != null && this.keyInRange(n.getKey())) {
                return n;
            }
            return null;
        }

        @Override
        public K lowerKey(K key) {
            Object found = TreeMap.this.lowerKey(key);
            if (this.keyInRange(found)) {
                return found;
            }
            return null;
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            if (this.nKeys == null) {
                this.nKeys = new NavigableKeySet();
            }
            return this.nKeys;
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            Map.Entry e = this.firstEntry();
            if (e != null) {
                TreeMap.this.removeNode((Node)e);
            }
            return e;
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            Map.Entry e = this.lastEntry();
            if (e != null) {
                TreeMap.this.removeNode((Node)e);
            }
            return e;
        }

        @Override
        public V put(K key, V value) {
            if (!this.keyInRange(key)) {
                throw new IllegalArgumentException("Key outside range");
            }
            return TreeMap.this.put(key, value);
        }

        @Override
        public V remove(Object key) {
            if (this.keyInRange(key)) {
                return TreeMap.this.remove(key);
            }
            return null;
        }

        @Override
        public int size() {
            Node node2 = TreeMap.this.lowestGreaterThan(this.minKey, true);
            Node max = TreeMap.this.lowestGreaterThan(this.maxKey, false);
            int count = 0;
            while (node2 != max) {
                ++count;
                node2 = TreeMap.this.successor(node2);
            }
            return count;
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            return this.subMap(fromKey, true, toKey, false);
        }

        @Override
        public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            if (!this.keyInRange(fromKey) || !this.keyInRange(toKey)) {
                throw new IllegalArgumentException("key outside range");
            }
            return new SubMap(fromInclusive ? fromKey : TreeMap.this.successor(TreeMap.this.getNode(fromKey)).key, toInclusive ? TreeMap.this.successor(TreeMap.this.getNode(toKey)).key : toKey);
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            return this.tailMap(fromKey, true);
        }

        @Override
        public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
            if (!this.keyInRange(fromKey)) {
                throw new IllegalArgumentException("key outside range");
            }
            return new SubMap(inclusive ? fromKey : TreeMap.this.successor(TreeMap.this.getNode(fromKey)).key, this.maxKey);
        }

        @Override
        public Collection<V> values() {
            if (this.values == null) {
                this.values = new AbstractCollection(){

                    @Override
                    public int size() {
                        return SubMap.this.size();
                    }

                    @Override
                    public Iterator<V> iterator() {
                        Node first = TreeMap.this.lowestGreaterThan(SubMap.this.minKey, true);
                        Node max = TreeMap.this.lowestGreaterThan(SubMap.this.maxKey, false);
                        return new TreeIterator(1, first, max);
                    }

                    @Override
                    public void clear() {
                        SubMap.this.clear();
                    }
                };
            }
            return this.values;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class EntrySet
        extends AbstractSet<Map.Entry<K, V>> {
            private EntrySet() {
            }

            @Override
            public int size() {
                return SubMap.this.size();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                Node first = TreeMap.this.lowestGreaterThan(SubMap.this.minKey, true);
                Node max = TreeMap.this.lowestGreaterThan(SubMap.this.maxKey, false);
                return new TreeIterator(2, first, max);
            }

            @Override
            public void clear() {
                SubMap.this.clear();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry me = (Map.Entry)o;
                Object key = me.getKey();
                if (!SubMap.this.keyInRange(key)) {
                    return false;
                }
                Node n = TreeMap.this.getNode(key);
                return n != nil && AbstractSet.equals(me.getValue(), n.value);
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry me = (Map.Entry)o;
                Object key = me.getKey();
                if (!SubMap.this.keyInRange(key)) {
                    return false;
                }
                Node n = TreeMap.this.getNode(key);
                if (n != nil && AbstractSet.equals(me.getValue(), n.value)) {
                    TreeMap.this.removeNode(n);
                    return true;
                }
                return false;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class KeySet
        extends AbstractSet<K> {
            private KeySet() {
            }

            @Override
            public int size() {
                return SubMap.this.size();
            }

            @Override
            public Iterator<K> iterator() {
                Node first = TreeMap.this.lowestGreaterThan(SubMap.this.minKey, true);
                Node max = TreeMap.this.lowestGreaterThan(SubMap.this.maxKey, false);
                return new TreeIterator(0, first, max);
            }

            @Override
            public void clear() {
                SubMap.this.clear();
            }

            @Override
            public boolean contains(Object o) {
                if (!SubMap.this.keyInRange(o)) {
                    return false;
                }
                return TreeMap.this.getNode(o) != nil;
            }

            @Override
            public boolean remove(Object o) {
                if (!SubMap.this.keyInRange(o)) {
                    return false;
                }
                Node n = TreeMap.this.getNode(o);
                if (n != nil) {
                    TreeMap.this.removeNode(n);
                    return true;
                }
                return false;
            }

            /* synthetic */ KeySet(KeySet keySet, KeySet keySet2) {
                this();
            }
        }

        /*
         * Signature claims super is java.util.TreeMap$SubMap.EntrySet, not java.util.TreeMap$SubMap$EntrySet - discarding signature.
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class NavigableEntrySet
        extends EntrySet
        implements NavigableSet {
            private NavigableEntrySet() {
            }

            public Map.Entry<K, V> ceiling(Map.Entry<K, V> e) {
                return SubMap.this.ceilingEntry(e.getKey());
            }

            @Override
            public Comparator<? super Map.Entry<K, V>> comparator() {
                return new Comparator<Map.Entry<K, V>>(){

                    @Override
                    public int compare(Map.Entry<K, V> t1, Map.Entry<K, V> t2) {
                        return ((SubMap)((NavigableEntrySet)NavigableEntrySet.this).SubMap.this).TreeMap.this.comparator.compare(t1.getKey(), t2.getKey());
                    }
                };
            }

            public Iterator<Map.Entry<K, V>> descendingIterator() {
                return this.descendingSet().iterator();
            }

            public NavigableSet<Map.Entry<K, V>> descendingSet() {
                return new DescendingSet(this);
            }

            @Override
            public Map.Entry<K, V> first() {
                return SubMap.this.firstEntry();
            }

            public Map.Entry<K, V> floor(Map.Entry<K, V> e) {
                return SubMap.this.floorEntry(e.getKey());
            }

            @Override
            public SortedSet<Map.Entry<K, V>> headSet(Map.Entry<K, V> to) {
                return this.headSet(to, false);
            }

            public NavigableSet<Map.Entry<K, V>> headSet(Map.Entry<K, V> to, boolean inclusive) {
                return (NavigableSet)SubMap.this.headMap(to.getKey(), inclusive).entrySet();
            }

            public Map.Entry<K, V> higher(Map.Entry<K, V> e) {
                return SubMap.this.higherEntry(e.getKey());
            }

            @Override
            public Map.Entry<K, V> last() {
                return SubMap.this.lastEntry();
            }

            public Map.Entry<K, V> lower(Map.Entry<K, V> e) {
                return SubMap.this.lowerEntry(e.getKey());
            }

            public Map.Entry<K, V> pollFirst() {
                return SubMap.this.pollFirstEntry();
            }

            public Map.Entry<K, V> pollLast() {
                return SubMap.this.pollLastEntry();
            }

            @Override
            public SortedSet<Map.Entry<K, V>> subSet(Map.Entry<K, V> from, Map.Entry<K, V> to) {
                return this.subSet(from, true, to, false);
            }

            public NavigableSet<Map.Entry<K, V>> subSet(Map.Entry<K, V> from, boolean fromInclusive, Map.Entry<K, V> to, boolean toInclusive) {
                return (NavigableSet)SubMap.this.subMap(from.getKey(), fromInclusive, to.getKey(), toInclusive).entrySet();
            }

            @Override
            public SortedSet<Map.Entry<K, V>> tailSet(Map.Entry<K, V> from) {
                return this.tailSet(from, true);
            }

            public NavigableSet<Map.Entry<K, V>> tailSet(Map.Entry<K, V> from, boolean inclusive) {
                return SubMap.this.tailMap(from.getKey(), inclusive).navigableKeySet();
            }
        }

        /*
         * Signature claims super is java.util.TreeMap$SubMap.KeySet, not java.util.TreeMap$SubMap$KeySet - discarding signature.
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class NavigableKeySet
        extends KeySet
        implements NavigableSet {
            private NavigableKeySet() {
            }

            public K ceiling(K k) {
                return SubMap.this.ceilingKey(k);
            }

            @Override
            public Comparator<? super K> comparator() {
                return ((SubMap)SubMap.this).TreeMap.this.comparator;
            }

            public Iterator<K> descendingIterator() {
                return this.descendingSet().iterator();
            }

            public NavigableSet<K> descendingSet() {
                return new DescendingSet(this);
            }

            @Override
            public K first() {
                return SubMap.this.firstKey();
            }

            public K floor(K k) {
                return SubMap.this.floorKey(k);
            }

            @Override
            public SortedSet<K> headSet(K to) {
                return this.headSet((K)to, false);
            }

            public NavigableSet<K> headSet(K to, boolean inclusive) {
                return SubMap.this.headMap(to, inclusive).navigableKeySet();
            }

            public K higher(K k) {
                return SubMap.this.higherKey(k);
            }

            @Override
            public K last() {
                return SubMap.this.lastKey();
            }

            public K lower(K k) {
                return SubMap.this.lowerKey(k);
            }

            public K pollFirst() {
                return SubMap.this.pollFirstEntry().getKey();
            }

            public K pollLast() {
                return SubMap.this.pollLastEntry().getKey();
            }

            @Override
            public SortedSet<K> subSet(K from, K to) {
                return this.subSet((K)from, true, (K)to, false);
            }

            public NavigableSet<K> subSet(K from, boolean fromInclusive, K to, boolean toInclusive) {
                return SubMap.this.subMap(from, fromInclusive, to, toInclusive).navigableKeySet();
            }

            @Override
            public SortedSet<K> tailSet(K from) {
                return this.tailSet((K)from, true);
            }

            public NavigableSet<K> tailSet(K from, boolean inclusive) {
                return SubMap.this.tailMap(from, inclusive).navigableKeySet();
            }
        }
    }

    private final class TreeIterator
    implements Iterator {
        private final int type;
        private int knownMod;
        private Node last;
        private Node next;
        private final Node max;

        TreeIterator(int type) {
            this(type, treeMap.firstNode(), nil);
        }

        TreeIterator(int type, Node first, Node max) {
            this.knownMod = TreeMap.this.modCount;
            this.type = type;
            this.next = first;
            this.max = max;
        }

        public boolean hasNext() {
            return this.next != this.max;
        }

        public Object next() {
            if (this.knownMod != TreeMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.next == this.max) {
                throw new NoSuchElementException();
            }
            this.last = this.next;
            this.next = TreeMap.this.successor(this.last);
            if (this.type == 1) {
                return this.last.value;
            }
            if (this.type == 0) {
                return this.last.key;
            }
            return this.last;
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            if (this.knownMod != TreeMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            TreeMap.this.removeNode(this.last);
            this.last = null;
            ++this.knownMod;
        }
    }
}

