/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.SSLContextImpl;
import gnu.javax.net.ssl.provider.SSLEngineImpl;
import gnu.javax.net.ssl.provider.SSLServerSocketImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLServerSocketFactory;

public class SSLServerSocketFactoryImpl
extends SSLServerSocketFactory {
    private final SSLContextImpl contextImpl;

    public SSLServerSocketFactoryImpl(SSLContextImpl contextImpl) {
        this.contextImpl = contextImpl;
    }

    public String[] getDefaultCipherSuites() {
        return SSLEngineImpl.defaultSuites();
    }

    public String[] getSupportedCipherSuites() {
        return CipherSuite.availableSuiteNames().toArray(new String[0]);
    }

    public SSLServerSocketImpl createServerSocket(int port) throws IOException {
        SSLServerSocketImpl socket = new SSLServerSocketImpl(this.contextImpl);
        socket.bind(new InetSocketAddress(port));
        return socket;
    }

    public SSLServerSocketImpl createServerSocket(int port, int backlog) throws IOException {
        SSLServerSocketImpl socket = new SSLServerSocketImpl(this.contextImpl);
        socket.bind(new InetSocketAddress(port), backlog);
        return socket;
    }

    public SSLServerSocketImpl createServerSocket(int port, int backlog, InetAddress bindAddress) throws IOException {
        SSLServerSocketImpl socket = new SSLServerSocketImpl(this.contextImpl);
        socket.bind(new InetSocketAddress(bindAddress, port), backlog);
        return socket;
    }
}

