/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.keyring;

import gnu.java.security.Registry;
import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.java.security.util.PRNG;
import gnu.java.security.util.Util;
import gnu.javax.crypto.keyring.Entry;
import gnu.javax.crypto.keyring.MalformedKeyringException;
import gnu.javax.crypto.keyring.MaskableEnvelopeEntry;
import gnu.javax.crypto.keyring.MeteredInputStream;
import gnu.javax.crypto.keyring.PasswordProtectedEntry;
import gnu.javax.crypto.keyring.Properties;
import gnu.javax.crypto.mac.IMac;
import gnu.javax.crypto.mac.MacFactory;
import gnu.javax.crypto.mac.MacInputStream;
import gnu.javax.crypto.mac.MacOutputStream;
import gnu.javax.crypto.prng.PRNGFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Logger;

public final class PasswordAuthenticatedEntry
extends MaskableEnvelopeEntry
implements PasswordProtectedEntry,
Registry {
    private static final Logger log = Logger.getLogger(PasswordAuthenticatedEntry.class.getName());
    public static final int TYPE = 3;

    public PasswordAuthenticatedEntry(String mac, int maclen, Properties properties) {
        super(3, properties);
        if (mac == null || mac.length() == 0) {
            throw new IllegalArgumentException("no MAC specified");
        }
        this.properties.put("mac", mac);
        this.properties.put("maclen", String.valueOf(maclen));
        this.setMasked(false);
    }

    private PasswordAuthenticatedEntry() {
        super(3);
        this.setMasked(true);
    }

    public static PasswordAuthenticatedEntry decode(DataInputStream in, char[] password) throws IOException {
        PasswordAuthenticatedEntry entry = new PasswordAuthenticatedEntry();
        entry.properties.decode(in);
        IMac mac = entry.getMac(password);
        int len = in.readInt() - mac.macSize();
        MeteredInputStream min = new MeteredInputStream(in, len);
        MacInputStream macin = new MacInputStream(min, mac);
        DataInputStream in2 = new DataInputStream(macin);
        entry.setMasked(false);
        entry.decodeEnvelope(in2);
        byte[] macValue = new byte[mac.macSize()];
        in.readFully(macValue);
        if (!Arrays.equals(macValue, mac.digest())) {
            throw new MalformedKeyringException("MAC verification failed");
        }
        return entry;
    }

    public static PasswordAuthenticatedEntry decode(DataInputStream in) throws IOException {
        PasswordAuthenticatedEntry entry = new PasswordAuthenticatedEntry();
        entry.defaultDecode(in);
        if (!entry.properties.containsKey("mac")) {
            throw new MalformedKeyringException("no MAC");
        }
        if (!entry.properties.containsKey("maclen")) {
            throw new MalformedKeyringException("no MAC length");
        }
        if (!entry.properties.containsKey("salt")) {
            throw new MalformedKeyringException("no salt");
        }
        return entry;
    }

    public void verify(char[] password) {
        if (this.isMasked() && this.payload != null) {
            System.currentTimeMillis();
            IMac m = null;
            try {
                m = this.getMac(password);
            }
            catch (Exception x) {
                throw new IllegalArgumentException(x.toString(), x);
            }
            int limit = this.payload.length - m.macSize();
            m.update(this.payload, 0, limit);
            byte[] macValue = new byte[m.macSize()];
            System.arraycopy(this.payload, this.payload.length - macValue.length, macValue, 0, macValue.length);
            if (!Arrays.equals(macValue, m.digest())) {
                throw new IllegalArgumentException("MAC verification failed");
            }
            this.setMasked(false);
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(this.payload, 0, limit);
                DataInputStream in = new DataInputStream(bais);
                this.decodeEnvelope(in);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("malformed keyring fragment");
            }
            System.currentTimeMillis();
        }
    }

    public void authenticate(char[] password) throws IOException {
        System.currentTimeMillis();
        System.currentTimeMillis();
        if (this.isMasked()) {
            throw new IllegalStateException("entry is masked");
        }
        byte[] salt = new byte[8];
        PRNG.getInstance().nextBytes(salt);
        System.currentTimeMillis();
        this.properties.put("salt", Util.toString(salt));
        IMac m = this.getMac(password);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
        MacOutputStream macout = new MacOutputStream(bout, m);
        DataOutputStream out2 = new DataOutputStream(macout);
        for (Entry entry : this.entries) {
            long cfr_ignored_0 = -System.currentTimeMillis();
            entry.encode(out2);
            System.currentTimeMillis();
        }
        bout.write(m.digest());
        this.payload = bout.toByteArray();
        this.setMasked(true);
        System.currentTimeMillis();
    }

    public void encode(DataOutputStream out, char[] password) throws IOException {
        this.authenticate(password);
        this.encode(out);
    }

    protected void encodePayload(DataOutputStream out) throws IOException {
        if (this.payload == null) {
            log.fine("Null payload: " + this);
            throw new IllegalStateException("mac not computed");
        }
    }

    private IMac getMac(char[] password) throws MalformedKeyringException {
        int maclen;
        String saltString = this.properties.get("salt");
        if (saltString == null) {
            throw new MalformedKeyringException("no salt");
        }
        byte[] salt = Util.toBytesFromString(saltString);
        String macAlgorithm = this.properties.get("mac");
        IMac mac = MacFactory.getInstance(macAlgorithm);
        if (mac == null) {
            throw new MalformedKeyringException("no such mac: " + macAlgorithm);
        }
        String macLenString = this.properties.get("maclen");
        if (macLenString == null) {
            throw new MalformedKeyringException("no MAC length");
        }
        try {
            maclen = Integer.parseInt(macLenString);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedKeyringException("bad MAC length");
        }
        HashMap<String, Object> pbAttr = new HashMap<String, Object>();
        pbAttr.put("gnu.crypto.pbe.password", password);
        pbAttr.put("gnu.crypto.pbe.salt", salt);
        pbAttr.put("gnu.crypto.pbe.iteration.count", ITERATION_COUNT);
        IRandom kdf = PRNGFactory.getInstance("PBKDF2-HMAC-SHA");
        kdf.init(pbAttr);
        int keylen = mac.macSize();
        byte[] dk = new byte[keylen];
        try {
            kdf.nextBytes(dk, 0, keylen);
        }
        catch (LimitReachedException shouldNotHappen) {
            throw new Error(shouldNotHappen.toString());
        }
        HashMap<String, Object> macAttr = new HashMap<String, Object>();
        macAttr.put("gnu.crypto.mac.key.material", dk);
        macAttr.put("gnu.crypto.mac.truncated.size", maclen);
        try {
            mac.init(macAttr);
        }
        catch (InvalidKeyException shouldNotHappen) {
            throw new Error(shouldNotHappen.toString());
        }
        return mac;
    }
}

