/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.CompositeView;
import javax.swing.text.Element;
import javax.swing.text.LabelView;
import javax.swing.text.Position;
import javax.swing.text.TabExpander;
import javax.swing.text.TabableView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class FlowView
extends BoxView {
    static final FlowStrategy sharedStrategy = new FlowStrategy();
    protected int layoutSpan;
    protected View layoutPool;
    protected FlowStrategy strategy = sharedStrategy;

    public FlowView(Element element, int axis) {
        super(element, axis);
        this.layoutSpan = Short.MAX_VALUE;
    }

    public int getFlowAxis() {
        int axis = this.getAxis();
        int flowAxis = axis == 0 ? 1 : 0;
        return flowAxis;
    }

    public int getFlowSpan(int index) {
        return this.layoutSpan;
    }

    public int getFlowStart(int index) {
        return 0;
    }

    protected abstract View createRow();

    protected void loadChildren(ViewFactory vf) {
        if (this.layoutPool == null) {
            this.layoutPool = new LogicalView(this.getElement());
        }
        this.layoutPool.setParent(this);
        this.strategy.insertUpdate(this, null, null);
    }

    protected void layout(int width, int height) {
        int flowAxis = this.getFlowAxis();
        int span = flowAxis == 0 ? width : height;
        if (this.layoutSpan != span) {
            this.layoutChanged(flowAxis);
            this.layoutChanged(this.getAxis());
            this.layoutSpan = span;
        }
        if (!this.isLayoutValid(flowAxis)) {
            View parent;
            int axis = this.getAxis();
            int oldSpan = axis == 0 ? this.getWidth() : this.getHeight();
            this.strategy.layout(this);
            int newSpan = (int)this.getPreferredSpan(axis);
            if (oldSpan != newSpan && (parent = this.getParent()) != null) {
                parent.preferenceChanged(this, axis == 0, axis == 1);
            }
        }
        super.layout(width, height);
    }

    public void insertUpdate(DocumentEvent changes, Shape a, ViewFactory vf) {
        this.layoutPool.insertUpdate(changes, a, vf);
        this.strategy.insertUpdate(this, changes, this.getInsideAllocation(a));
    }

    public void removeUpdate(DocumentEvent changes, Shape a, ViewFactory vf) {
        this.layoutPool.removeUpdate(changes, a, vf);
        this.strategy.removeUpdate(this, changes, this.getInsideAllocation(a));
    }

    public void changedUpdate(DocumentEvent changes, Shape a, ViewFactory vf) {
        this.layoutPool.changedUpdate(changes, a, vf);
        this.strategy.changedUpdate(this, changes, this.getInsideAllocation(a));
    }

    protected int getViewIndexAtPosition(int pos) {
        if (!this.isAllocationValid()) {
            this.layout(this.getWidth(), this.getHeight());
        }
        int count = this.getViewCount();
        int result = -1;
        int i = 0;
        while (i < count) {
            View child = this.getView(i);
            int start = child.getStartOffset();
            int end = child.getEndOffset();
            if (start <= pos && end > pos) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
        SizeRequirements res = r;
        if (res == null) {
            res = new SizeRequirements();
        }
        res.minimum = (int)this.layoutPool.getMinimumSpan(axis);
        res.preferred = Math.max(res.minimum, (int)this.layoutPool.getPreferredSpan(axis));
        res.maximum = Integer.MAX_VALUE;
        res.alignment = 0.5f;
        return res;
    }

    public static class FlowStrategy {
        public void insertUpdate(FlowView fv, DocumentEvent e, Rectangle alloc) {
            if (alloc == null) {
                fv.layoutChanged(0);
                fv.layoutChanged(1);
            } else {
                Container host = fv.getContainer();
                if (host != null) {
                    host.repaint(alloc.x, alloc.y, alloc.width, alloc.height);
                }
            }
        }

        public void removeUpdate(FlowView fv, DocumentEvent e, Rectangle alloc) {
            if (alloc == null) {
                fv.layoutChanged(0);
                fv.layoutChanged(1);
            } else {
                Container host = fv.getContainer();
                if (host != null) {
                    host.repaint(alloc.x, alloc.y, alloc.width, alloc.height);
                }
            }
        }

        public void changedUpdate(FlowView fv, DocumentEvent e, Rectangle alloc) {
            if (alloc == null) {
                fv.layoutChanged(0);
                fv.layoutChanged(1);
            } else {
                Container host = fv.getContainer();
                if (host != null) {
                    host.repaint(alloc.x, alloc.y, alloc.width, alloc.height);
                }
            }
        }

        protected View getLogicalView(FlowView fv) {
            return fv.layoutPool;
        }

        public void layout(FlowView fv) {
            int start = fv.getStartOffset();
            int end = fv.getEndOffset();
            View lv = this.getLogicalView(fv);
            int viewCount = lv.getViewCount();
            int i = 0;
            while (i < viewCount) {
                View v = lv.getView(i);
                v.setParent(lv);
                ++i;
            }
            fv.removeAll();
            int rowIndex = 0;
            while (start < end) {
                View row = fv.createRow();
                fv.append(row);
                int next = this.layoutRow(fv, rowIndex, start);
                if (row.getViewCount() == 0) {
                    row.append(this.createView(fv, start, Integer.MAX_VALUE, rowIndex));
                    next = row.getEndOffset();
                }
                if (start < next) {
                    start = next;
                } else assert (false) : "May not happen";
                ++rowIndex;
            }
        }

        protected int layoutRow(FlowView fv, int rowIndex, int pos) {
            View view;
            View row = fv.getView(rowIndex);
            int axis = fv.getFlowAxis();
            int span = fv.getFlowSpan(rowIndex);
            int x = fv.getFlowStart(rowIndex);
            int end = fv.getEndOffset();
            int preX = x;
            int availableSpan = span;
            TabExpander tabExp = fv instanceof TabExpander ? (TabExpander)((Object)fv) : null;
            boolean forcedBreak = false;
            while (pos < end && span >= 0) {
                view = this.createView(fv, pos, span, rowIndex);
                if (view == null || span == 0 && view.getPreferredSpan(axis) > 0.0f) break;
                int viewSpan = axis == 0 && view instanceof TabableView ? (int)((TabableView)((Object)view)).getTabbedSpan(x, tabExp) : (int)view.getPreferredSpan(axis);
                int breakWeight = view.getBreakWeight(axis, pos, span);
                if (breakWeight >= 3000) {
                    int rowViewCount = row.getViewCount();
                    if (rowViewCount > 0) {
                        viewSpan = (view = view.breakView(axis, pos, x, span)) != null ? (axis == 0 && view instanceof TabableView ? (int)((TabableView)((Object)view)).getTabbedSpan(x, tabExp) : (int)view.getPreferredSpan(axis)) : 0;
                    }
                    forcedBreak = true;
                }
                span -= viewSpan;
                x += viewSpan;
                if (view != null) {
                    row.append(view);
                    pos = view.getEndOffset();
                }
                if (forcedBreak) break;
            }
            if (span < 0) {
                this.adjustRow(fv, rowIndex, availableSpan, preX);
            } else if (row.getViewCount() == 0) {
                view = this.createView(fv, pos, Integer.MAX_VALUE, rowIndex);
                row.append(view);
            }
            return row.getEndOffset();
        }

        protected View createView(FlowView fv, int startOffset, int spanLeft, int rowIndex) {
            int index;
            View logicalView = this.getLogicalView(fv);
            View retVal = logicalView.getView(index = logicalView.getViewIndex(startOffset, Position.Bias.Forward));
            if (retVal.getStartOffset() != startOffset) {
                retVal = retVal.createFragment(startOffset, retVal.getEndOffset());
            }
            return retVal;
        }

        protected void adjustRow(FlowView fv, int rowIndex, int desiredSpan, int x) {
            int axis = fv.getFlowAxis();
            View row = fv.getView(rowIndex);
            int count = row.getViewCount();
            int breakIndex = -1;
            int breakWeight = 0;
            int breakSpan = 0;
            int currentSpan = 0;
            int i = 0;
            while (i < count) {
                int spanLeft;
                View view = row.getView(i);
                int weight = view.getBreakWeight(axis, x + currentSpan, spanLeft = desiredSpan - currentSpan);
                if (weight >= breakWeight && weight > 0) {
                    breakIndex = i;
                    breakSpan = currentSpan;
                    breakWeight = weight;
                    if (weight >= 3000) break;
                }
                currentSpan = (int)((float)currentSpan + view.getPreferredSpan(axis));
                ++i;
            }
            if (breakIndex >= 0) {
                int spanLeft = desiredSpan - breakSpan;
                View toBeBroken = row.getView(breakIndex);
                View brokenView = toBeBroken.breakView(axis, toBeBroken.getStartOffset(), x + breakSpan, spanLeft);
                View lv = this.getLogicalView(fv);
                int i2 = breakIndex;
                while (i2 < count) {
                    View tmp = row.getView(i2);
                    if (this.contains(lv, tmp)) {
                        tmp.setParent(lv);
                    } else if (tmp.getViewCount() > 0) {
                        this.reparent(tmp, lv);
                    }
                    ++i2;
                }
                row.replace(breakIndex, count - breakIndex, new View[]{brokenView});
            }
        }

        private boolean contains(View view, View child) {
            boolean ret = false;
            int n = view.getViewCount();
            int i = 0;
            while (i < n && !ret) {
                if (view.getView(i) == child) {
                    ret = true;
                }
                ++i;
            }
            return ret;
        }

        private void reparent(View view, View parent) {
            int n = view.getViewCount();
            int i = 0;
            while (i < n) {
                View tmp = view.getView(i);
                if (this.contains(parent, tmp)) {
                    tmp.setParent(parent);
                } else {
                    this.reparent(tmp, parent);
                }
                ++i;
            }
        }
    }

    class LogicalView
    extends CompositeView {
        LogicalView(Element el) {
            super(el);
        }

        public AttributeSet getAttributes() {
            View p = this.getParent();
            return p != null ? p.getAttributes() : null;
        }

        protected void childAllocation(int index, Rectangle a) {
        }

        protected View getViewAtPoint(int x, int y, Rectangle r) {
            return null;
        }

        protected boolean isAfter(int x, int y, Rectangle r) {
            return false;
        }

        protected boolean isBefore(int x, int y, Rectangle r) {
            return false;
        }

        public float getPreferredSpan(int axis) {
            float max = 0.0f;
            float pref = 0.0f;
            int n = this.getViewCount();
            int i = 0;
            while (i < n) {
                View v = this.getView(i);
                pref += v.getPreferredSpan(axis);
                if (v.getBreakWeight(axis, 0.0f, 2.1474836E9f) >= 3000) {
                    max = Math.max(max, pref);
                    pref = 0.0f;
                }
                ++i;
            }
            max = Math.max(max, pref);
            return max;
        }

        public float getMinimumSpan(int axis) {
            float max = 0.0f;
            float min = 0.0f;
            boolean wrap = true;
            int n = this.getViewCount();
            int i = 0;
            while (i < n) {
                View v = this.getView(i);
                if (v.getBreakWeight(axis, 0.0f, 2.1474836E9f) == 0) {
                    min += v.getPreferredSpan(axis);
                    wrap = false;
                } else if (!wrap) {
                    max = Math.max(min, max);
                    wrap = true;
                    min = 0.0f;
                }
                ++i;
            }
            max = Math.max(max, min);
            return max;
        }

        public void paint(Graphics g, Shape s) {
        }

        protected void loadChildren(ViewFactory f) {
            Element el = this.getElement();
            if (el.isLeaf()) {
                LabelView v = new LabelView(el);
                this.append(v);
            } else {
                super.loadChildren(f);
            }
        }

        protected void forwardUpdateToView(View v, DocumentEvent e, Shape a, ViewFactory f) {
            v.setParent(this);
            super.forwardUpdateToView(v, e, a, f);
        }

        protected int getViewIndexAtPosition(int pos) {
            int index = 0;
            if (!this.getElement().isLeaf()) {
                index = super.getViewIndexAtPosition(pos);
            }
            return index;
        }
    }
}

