/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.classpath.SystemProperties;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.channels.Channel;
import java.nio.channels.spi.SelectorProvider;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyPermission;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class System {
    public static final InputStream in = new BufferedInputStream(new FileInputStream(FileDescriptor.in));
    public static final PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.out)), true);
    public static final PrintStream err = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.err)), true);
    private static Map<String, String> environmentMap;

    private System() {
    }

    public static void setIn(InputStream in) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setIO"));
        }
        System.setIn0(in);
    }

    public static void setOut(PrintStream out) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setIO"));
        }
        System.setOut0(out);
    }

    public static void setErr(PrintStream err) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setIO"));
        }
        System.setErr0(err);
    }

    public static synchronized void setSecurityManager(SecurityManager sm) {
        if (SecurityManager.current != null) {
            SecurityManager.current.checkPermission(new RuntimePermission("setSecurityManager"));
        }
        SecurityManager.current = sm;
    }

    public static SecurityManager getSecurityManager() {
        return SecurityManager.current;
    }

    public static native long currentTimeMillis();

    public static native long nanoTime();

    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    public static native int identityHashCode(Object var0);

    public static Properties getProperties() {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPropertiesAccess();
        }
        return SystemProperties.getProperties();
    }

    public static void setProperties(Properties properties) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPropertiesAccess();
        }
        SystemProperties.setProperties(properties);
    }

    public static String getProperty(String key) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPropertyAccess(key);
        } else if (key.length() == 0) {
            throw new IllegalArgumentException("key can't be empty");
        }
        return SystemProperties.getProperty(key);
    }

    public static String getProperty(String key, String def) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPropertyAccess(key);
        }
        return SystemProperties.getProperty(key, def);
    }

    public static String setProperty(String key, String value) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPermission(new PropertyPermission(key, "write"));
        }
        return SystemProperties.setProperty(key, value);
    }

    public static String clearProperty(String key) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPermission(new PropertyPermission(key, "write"));
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("key can't be empty");
        }
        return SystemProperties.remove(key);
    }

    public static String getenv(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getenv." + name));
        }
        return System.getenv0(name);
    }

    public static Map<String, String> getenv() {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getenv.*"));
        }
        if (environmentMap == null) {
            ArrayList environ = new ArrayList();
            EnvironmentMap variables = new EnvironmentMap();
            for (String pair : environ) {
                String[] parts = pair.split("=");
                variables.put(parts[0], parts[1]);
            }
            environmentMap = Collections.unmodifiableMap(variables);
        }
        return environmentMap;
    }

    public static void exit(int status) {
        Runtime.getRuntime().exit(status);
    }

    public static void gc() {
        Runtime.getRuntime().gc();
    }

    public static void runFinalization() {
        Runtime.getRuntime().runFinalization();
    }

    public static void runFinalizersOnExit(boolean finalizeOnExit) {
        Runtime.getRuntime();
        Runtime.runFinalizersOnExit(finalizeOnExit);
    }

    public static void load(String filename) {
        Runtime.getRuntime().load(filename);
    }

    public static void loadLibrary(String libname) {
        Runtime.getRuntime().loadLibrary(libname);
    }

    public static String mapLibraryName(String libname) {
        return Runtime.nativeGetLibname("", libname);
    }

    private static native void setIn0(InputStream var0);

    private static native void setOut0(PrintStream var0);

    private static native void setErr0(PrintStream var0);

    static native String getenv0(String var0);

    public static Channel inheritedChannel() throws IOException {
        return SelectorProvider.provider().inheritedChannel();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnvironmentCollection
    extends AbstractCollection<String> {
        protected Collection<String> c;

        public EnvironmentCollection(Collection<String> coll) {
            this.c = coll;
        }

        @Override
        public boolean contains(Object obj) {
            if (obj == null) {
                throw new NullPointerException("This collection does not support null values.");
            }
            if (!(obj instanceof String)) {
                throw new ClassCastException("This collection only supports Strings.");
            }
            return this.c.contains(obj);
        }

        @Override
        public boolean containsAll(Collection<?> coll) {
            for (Object o : coll) {
                if (o == null) {
                    throw new NullPointerException("This collection does not support null values.");
                }
                if (o instanceof String) continue;
                throw new ClassCastException("This collection only supports Strings.");
            }
            return this.c.containsAll(coll);
        }

        @Override
        public Iterator<String> iterator() {
            return this.c.iterator();
        }

        @Override
        public boolean remove(Object key) {
            if (key == null) {
                throw new NullPointerException("This collection does not support null values.");
            }
            if (!(key instanceof String)) {
                throw new ClassCastException("This collection only supports Strings.");
            }
            return this.c.contains(key);
        }

        @Override
        public boolean removeAll(Collection<?> coll) {
            for (Object o : coll) {
                if (o == null) {
                    throw new NullPointerException("This collection does not support null values.");
                }
                if (o instanceof String) continue;
                throw new ClassCastException("This collection only supports Strings.");
            }
            return this.c.removeAll(coll);
        }

        @Override
        public boolean retainAll(Collection<?> coll) {
            for (Object o : coll) {
                if (o == null) {
                    throw new NullPointerException("This collection does not support null values.");
                }
                if (o instanceof String) continue;
                throw new ClassCastException("This collection only supports Strings.");
            }
            return this.c.containsAll(coll);
        }

        @Override
        public int size() {
            return this.c.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EnvironmentMap
    extends HashMap<String, String> {
        private transient Set<Map.Entry<String, String>> entries;
        private transient Set<String> keys;
        private transient Collection<String> values;

        EnvironmentMap() {
        }

        EnvironmentMap(Map<String, String> m) {
            super(m);
        }

        @Override
        public boolean containsKey(Object key) {
            if (key == null) {
                throw new NullPointerException("This map does not support null keys.");
            }
            if (!(key instanceof String)) {
                throw new ClassCastException("This map only allows queries using Strings.");
            }
            return super.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            if (value == null) {
                throw new NullPointerException("This map does not support null values.");
            }
            if (!(value instanceof String)) {
                throw new ClassCastException("This map only allows queries using Strings.");
            }
            return super.containsValue(value);
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            if (this.entries == null) {
                this.entries = super.entrySet();
            }
            return this.entries;
        }

        @Override
        public String get(Object key) {
            if (key == null) {
                throw new NullPointerException("This map does not support null keys.");
            }
            if (!(key instanceof String)) {
                throw new ClassCastException("This map only allows queries using Strings.");
            }
            return (String)super.get(key);
        }

        @Override
        public Set<String> keySet() {
            if (this.keys == null) {
                this.keys = new EnvironmentSet(super.keySet());
            }
            return this.keys;
        }

        @Override
        public String put(String key, String value) {
            if (key == null) {
                throw new NullPointerException("A new key is null.");
            }
            if (value == null) {
                throw new NullPointerException("A new value is null.");
            }
            if (!(key instanceof String)) {
                throw new ClassCastException("A new key is not a String.");
            }
            if (!(value instanceof String)) {
                throw new ClassCastException("A new value is not a String.");
            }
            return super.put(key, value);
        }

        @Override
        public String remove(Object key) {
            if (key == null) {
                throw new NullPointerException("This map does not support null keys.");
            }
            if (!(key instanceof String)) {
                throw new ClassCastException("This map only allows queries using Strings.");
            }
            return (String)super.remove(key);
        }

        @Override
        public Collection<String> values() {
            if (this.values == null) {
                this.values = new EnvironmentCollection(super.values());
            }
            return this.values;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnvironmentSet
    extends EnvironmentCollection
    implements Set<String> {
        public EnvironmentSet(Set<String> set) {
            super(set);
        }

        @Override
        public boolean equals(Object obj) {
            return this.c.equals(obj);
        }

        @Override
        public int hashCode() {
            return this.c.hashCode();
        }
    }
}

