/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.swing;

import gnu.java.awt.peer.swing.SwingComponent;
import gnu.java.awt.peer.swing.SwingComponentPeer;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.im.InputMethodRequests;
import java.awt.peer.TextFieldPeer;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class SwingTextFieldPeer
extends SwingComponentPeer
implements TextFieldPeer {
    public SwingTextFieldPeer(TextField textField) {
        SwingTextField swingTextField = new SwingTextField(textField);
        swingTextField.setText(textField.getText());
        this.init(textField, swingTextField);
    }

    public Dimension minimumSize(int len) {
        return this.swingComponent.getJComponent().getMinimumSize();
    }

    public Dimension preferredSize(int len) {
        return this.swingComponent.getJComponent().getPreferredSize();
    }

    public Dimension getMinimumSize(int len) {
        return this.swingComponent.getJComponent().getMinimumSize();
    }

    public Dimension getPreferredSize(int len) {
        return this.swingComponent.getJComponent().getPreferredSize();
    }

    public void setEchoChar(char echoChar) {
    }

    public void setEchoCharacter(char echoChar) {
    }

    public int getSelectionEnd() {
        return 0;
    }

    public int getSelectionStart() {
        return 0;
    }

    public String getText() {
        return ((JTextField)this.swingComponent.getJComponent()).getText();
    }

    public void setText(String text) {
        ((JTextField)this.swingComponent.getJComponent()).setText(text);
    }

    public void select(int startPos, int endPos) {
    }

    public void setEditable(boolean editable) {
        ((JTextField)this.swingComponent.getJComponent()).setEditable(editable);
    }

    public int getCaretPosition() {
        return ((JTextField)this.swingComponent.getJComponent()).getCaret().getDot();
    }

    public void setCaretPosition(int pos) {
        ((JTextField)this.swingComponent.getJComponent()).getCaret().setDot(pos);
    }

    public int getIndexAtPoint(int x, int y) {
        return 0;
    }

    public Rectangle getCharacterBounds(int pos) {
        return null;
    }

    public long filterEvents(long filter) {
        return 0L;
    }

    public InputMethodRequests getInputMethodRequests() {
        return null;
    }

    private class SwingTextField
    extends JTextField
    implements SwingComponent {
        TextField textField;

        SwingTextField(TextField textField) {
            this.textField = textField;
        }

        public Point getLocationOnScreen() {
            return SwingTextFieldPeer.this.getLocationOnScreen();
        }

        public boolean isShowing() {
            boolean retVal = false;
            if (this.textField != null) {
                retVal = this.textField.isShowing();
            }
            return retVal;
        }

        public Image createImage(int w, int h) {
            return SwingTextFieldPeer.this.createImage(w, h);
        }

        public JComponent getJComponent() {
            return this;
        }

        public void handleMouseEvent(MouseEvent ev) {
            ev.setSource(this);
            this.processMouseEvent(ev);
        }

        public void handleMouseMotionEvent(MouseEvent ev) {
            ev.setSource(this);
            this.processMouseMotionEvent(ev);
        }

        public void handleKeyEvent(KeyEvent ev) {
            ev.setSource(this);
            this.processKeyEvent(ev);
        }

        public void handleFocusEvent(FocusEvent ev) {
            this.processFocusEvent(ev);
        }

        public Container getParent() {
            Container par = null;
            if (this.textField != null) {
                par = this.textField.getParent();
            }
            return par;
        }

        public Graphics getGraphics() {
            return SwingTextFieldPeer.this.getGraphics();
        }

        public void requestFocus() {
            SwingTextFieldPeer.this.requestFocus(SwingTextFieldPeer.this.awtComponent, false, true, 0L);
        }

        public boolean requestFocus(boolean temporary) {
            return SwingTextFieldPeer.this.requestFocus(SwingTextFieldPeer.this.awtComponent, temporary, true, 0L);
        }
    }
}

