/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import gnu.classpath.SystemProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.UIManager;

class MetalUtils {
    static BufferedImage pattern2D;
    static Color lightColor;
    static Color darkColor;

    MetalUtils() {
    }

    static void fillMetalPattern(Component c, Graphics g, int x, int y, int w, int h, Color light, Color dark) {
        if (g instanceof Graphics2D && SystemProperties.getProperty("gnu.javax.swing.noGraphics2D") == null) {
            MetalUtils.fillMetalPattern2D((Graphics2D)g, x, y, w, h, light, dark);
        } else {
            int xOff = 0;
            int mY = y;
            while (mY < y + h) {
                if ((mY - y) % 2 == 0) {
                    g.setColor(light);
                } else {
                    g.setColor(dark);
                }
                int mX = x + xOff;
                while (mX < x + w) {
                    g.fillRect(mX, mY, 1, 1);
                    mX += 4;
                }
                if (++xOff > 3) {
                    xOff = 0;
                }
                ++mY;
            }
        }
    }

    static void fillMetalPattern2D(Graphics2D g2d, int x, int y, int w, int h, Color light, Color dark) {
        if (pattern2D == null || !darkColor.equals(dark) || !lightColor.equals(light)) {
            MetalUtils.initializePattern(light, dark);
        }
        TexturePaint texture = new TexturePaint(pattern2D, new Rectangle2D.Double(0.0, 0.0, 4.0, 4.0));
        g2d.setPaint(texture);
        g2d.fillRect(x, y, w, h);
    }

    static void initializePattern(Color light, Color dark) {
        pattern2D = new BufferedImage(4, 4, 2);
        lightColor = light;
        darkColor = dark;
        Graphics g = pattern2D.getGraphics();
        g.setColor(light);
        g.fillRect(0, 0, 1, 1);
        g.fillRect(2, 2, 1, 1);
        g.setColor(dark);
        g.fillRect(1, 1, 1, 1);
        g.fillRect(3, 3, 1, 1);
        g.dispose();
    }

    static void paintGradient(Graphics g, int x, int y, int w, int h, int dir, String uiProp) {
        MetalUtils.paintGradient(g, x, y, w, h, dir, uiProp, null);
    }

    static void paintGradient(Graphics g, int x, int y, int w, int h, int dir, String uiProp, int[][] mask) {
        List params = (List)UIManager.get(uiProp);
        float g1 = ((Float)params.get(0)).floatValue();
        float g2 = ((Float)params.get(1)).floatValue();
        Color c1 = (Color)params.get(2);
        Color c2 = (Color)params.get(3);
        Color c3 = (Color)params.get(4);
        MetalUtils.paintGradient(g, x, y, w, h, g1, g2, c1, c2, c3, dir, mask);
    }

    static void paintGradient(Graphics g, int x, int y, int w, int h, float g1, float g2, Color c1, Color c2, Color c3, int dir, int[][] mask) {
        if (dir == 0) {
            MetalUtils.paintHorizontalGradient(g, x, y, w, h, g1, g2, c1, c2, c3, mask);
        } else {
            MetalUtils.paintVerticalGradient(g, x, y, w, h, g1, g2, c1, c2, c3, mask);
        }
    }

    static void paintHorizontalGradient(Graphics g, int x, int y, int w, int h, float g1, float g2, Color c1, Color c2, Color c3, int[][] mask) {
        Color interpolated;
        int bInt;
        int gInt;
        int rInt;
        double factor;
        if (g instanceof Graphics2D && SystemProperties.getProperty("gnu.javax.swing.noGraphics2D") == null) {
            MetalUtils.paintHorizontalGradient2D((Graphics2D)g, x, y, w, h, g1, g2, c1, c2, c3, mask);
            return;
        }
        int y0 = y;
        int y1 = y + h;
        int w1 = (int)((float)w * g1);
        int w2 = (int)((float)w * g2);
        int x0 = x;
        int x1 = x0 + w1;
        int x2 = x1 + w2;
        int x3 = x2 + w1;
        int x4 = x + w;
        int xc = x0;
        while (xc < x1) {
            if (xc > x + w) break;
            factor = (double)(xc - x0) / (double)w1;
            rInt = (int)((double)(c2.getRed() - c1.getRed()) * factor + (double)c1.getRed());
            gInt = (int)((double)(c2.getGreen() - c1.getGreen()) * factor + (double)c1.getGreen());
            bInt = (int)((double)(c2.getBlue() - c1.getBlue()) * factor + (double)c1.getBlue());
            interpolated = new Color(rInt, gInt, bInt);
            g.setColor(interpolated);
            if (mask != null) {
                y0 = mask[xc - x0][0] + y;
                y1 = mask[xc - x0][1] + y;
            }
            g.fillRect(xc, y0, 1, y1 - y0);
            ++xc;
        }
        g.setColor(c2);
        if (mask == null) {
            g.fillRect(x1, y, x2 - x1, h);
        } else {
            xc = x1;
            while (xc < x2) {
                y0 = mask[xc - x0][0] + y;
                y1 = mask[xc - x0][1] + y;
                g.fillRect(xc, y0, 1, y1 - y0);
                ++xc;
            }
        }
        xc = x2;
        while (xc < x3) {
            if (xc > x + w) break;
            factor = (double)(xc - x2) / (double)w1;
            rInt = (int)((double)(c1.getRed() - c2.getRed()) * factor + (double)c2.getRed());
            gInt = (int)((double)(c1.getGreen() - c2.getGreen()) * factor + (double)c2.getGreen());
            bInt = (int)((double)(c1.getBlue() - c2.getBlue()) * factor + (double)c2.getBlue());
            interpolated = new Color(rInt, gInt, bInt);
            g.setColor(interpolated);
            if (mask != null) {
                y0 = mask[xc - x0][0] + y;
                y1 = mask[xc - x0][1] + y;
            }
            g.fillRect(xc, y0, 1, y1 - y0);
            ++xc;
        }
        xc = x3;
        while (xc < x4) {
            if (xc > x + w) break;
            factor = (double)(xc - x3) / (double)(x4 - x3);
            rInt = (int)((double)(c3.getRed() - c1.getRed()) * factor + (double)c1.getRed());
            gInt = (int)((double)(c3.getGreen() - c1.getGreen()) * factor + (double)c1.getGreen());
            bInt = (int)((double)(c3.getBlue() - c1.getBlue()) * factor + (double)c1.getBlue());
            interpolated = new Color(rInt, gInt, bInt);
            g.setColor(interpolated);
            if (mask != null) {
                y0 = mask[xc - x0][0] + y;
                y1 = mask[xc - x0][1] + y;
            }
            g.drawLine(xc, y0, xc, y1);
            ++xc;
        }
    }

    static void paintVerticalGradient(Graphics g, int x, int y, int w, int h, float g1, float g2, Color c1, Color c2, Color c3, int[][] mask) {
        Color interpolated;
        int bInt;
        int gInt;
        int rInt;
        double factor;
        if (g instanceof Graphics2D && SystemProperties.getProperty("gnu.javax.swing.noGraphics2D") == null) {
            MetalUtils.paintVerticalGradient2D((Graphics2D)g, x, y, w, h, g1, g2, c1, c2, c3, mask);
            return;
        }
        int x0 = x;
        int x1 = x + w;
        int w1 = (int)((float)h * g1);
        int w2 = (int)((float)h * g2);
        int y0 = y;
        int y1 = y0 + w1;
        int y2 = y1 + w2;
        int y3 = y2 + w1;
        int y4 = y + h;
        int yc = y0;
        while (yc < y1) {
            if (yc > y + h) break;
            factor = (double)(yc - y0) / (double)w1;
            rInt = (int)((double)(c2.getRed() - c1.getRed()) * factor + (double)c1.getRed());
            gInt = (int)((double)(c2.getGreen() - c1.getGreen()) * factor + (double)c1.getGreen());
            bInt = (int)((double)(c2.getBlue() - c1.getBlue()) * factor + (double)c1.getBlue());
            interpolated = new Color(rInt, gInt, bInt);
            g.setColor(interpolated);
            if (mask != null) {
                x0 = mask[yc - y0][0] + x;
                x1 = mask[yc - y0][1] + x;
            }
            g.fillRect(x0, yc, x1 - x0, 1);
            ++yc;
        }
        g.setColor(c2);
        if (mask == null) {
            g.fillRect(x, y1, w, y2 - y1);
        } else {
            yc = y1;
            while (yc < y2) {
                x0 = mask[yc - y0][0] + x;
                x1 = mask[yc - y0][1] + x;
                g.fillRect(x0, yc, x1 - x0, 1);
                ++yc;
            }
        }
        yc = y2;
        while (yc < y3) {
            if (yc > y + h) break;
            factor = (double)(yc - y2) / (double)w1;
            rInt = (int)((double)(c1.getRed() - c2.getRed()) * factor + (double)c2.getRed());
            gInt = (int)((double)(c1.getGreen() - c2.getGreen()) * factor + (double)c2.getGreen());
            bInt = (int)((double)(c1.getBlue() - c2.getBlue()) * factor + (double)c2.getBlue());
            interpolated = new Color(rInt, gInt, bInt);
            g.setColor(interpolated);
            if (mask != null) {
                x0 = mask[yc - y0][0] + x;
                x1 = mask[yc - y0][1] + x;
            }
            g.fillRect(x0, yc, x1 - x0, 1);
            ++yc;
        }
        yc = y3;
        while (yc < y4) {
            if (yc > y + h) break;
            factor = (double)(yc - y3) / (double)(y4 - y3);
            rInt = (int)((double)(c3.getRed() - c1.getRed()) * factor + (double)c1.getRed());
            gInt = (int)((double)(c3.getGreen() - c1.getGreen()) * factor + (double)c1.getGreen());
            bInt = (int)((double)(c3.getBlue() - c1.getBlue()) * factor + (double)c1.getBlue());
            interpolated = new Color(rInt, gInt, bInt);
            g.setColor(interpolated);
            if (mask != null) {
                x0 = mask[yc - y0][0] + x;
                x1 = mask[yc - y0][1] + x;
            }
            g.fillRect(x0, yc, x1 - x0, 1);
            ++yc;
        }
    }

    private static void paintHorizontalGradient2D(Graphics2D g, int x, int y, int w, int h, float g1, float g2, Color c1, Color c2, Color c3, int[][] mask) {
        GradientPaint p1 = new GradientPaint(x, y, c1, (float)x + (float)w * g1, y, c2);
        g.setPaint(p1);
        g.fillRect(x, y, (int)((float)w * (g1 + g2)), h);
        GradientPaint p2 = new GradientPaint((float)x + (float)w * (g1 + g2), y, c2, x + w, y, c3);
        g.setPaint(p2);
        g.fillRect((int)((float)x + (float)w * (g1 + g2)), y, (int)((double)w * (1.0 - (double)(g1 + g2))), h);
    }

    private static void paintVerticalGradient2D(Graphics2D g, int x, int y, int w, int h, float g1, float g2, Color c1, Color c2, Color c3, int[][] mask) {
        GradientPaint p1 = new GradientPaint(x, y, c1, x, (float)y + (float)h * g1, c2);
        g.setPaint(p1);
        g.fillRect(x, y, w, (int)((float)h * (g1 + g2)));
        GradientPaint p2 = new GradientPaint(x, (float)y + (float)h * (g1 + g2), c2, x, y + h, c3);
        g.setPaint(p2);
        g.fillRect(x, (int)((float)y + (float)h * (g1 + g2)), w, (int)((double)h * (1.0 - (double)(g1 + g2))));
    }
}

