/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;

public abstract class Writer
implements Appendable,
Closeable,
Flushable {
    protected Object lock;

    protected Writer() {
        this.lock = this;
    }

    protected Writer(Object lock) {
        if (lock == null) {
            throw new NullPointerException();
        }
        this.lock = lock;
    }

    public abstract void flush() throws IOException;

    public abstract void close() throws IOException;

    public void write(int b) throws IOException {
        char[] buf = new char[]{(char)b};
        this.write(buf, 0, buf.length);
    }

    public void write(char[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public abstract void write(char[] var1, int var2, int var3) throws IOException;

    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    public void write(String str, int offset, int len) throws IOException {
        char[] buf = new char[len];
        str.getChars(offset, offset + len, buf, 0);
        this.write(buf, 0, len);
    }

    public Writer append(char c) throws IOException {
        this.write(c);
        return this;
    }

    public Writer append(CharSequence cs) throws IOException {
        this.write(cs == null ? "null" : cs.toString());
        return this;
    }

    public Writer append(CharSequence cs, int start, int end) throws IOException {
        this.write(cs == null ? "null" : cs.subSequence(start, end).toString());
        return this;
    }
}

