/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.http;

import gnu.java.net.protocol.http.Headers;
import java.io.InputStream;
import java.util.Date;

public class Response {
    protected final int majorVersion;
    protected final int minorVersion;
    protected final int code;
    protected final String message;
    protected final Headers headers;
    protected final InputStream body;

    protected Response(int majorVersion, int minorVersion, int code, String message, Headers headers, InputStream body) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.code = code;
        this.message = message;
        this.headers = headers;
        this.body = body;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getCode() {
        return this.code;
    }

    public int getCodeClass() {
        return this.code / 100;
    }

    public String getMessage() {
        return this.message;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public String getHeader(String name) {
        return this.headers.getValue(name);
    }

    public int getIntHeader(String name) {
        return this.headers.getIntValue(name);
    }

    public long getLongHeader(String name) {
        return this.headers.getLongValue(name);
    }

    public Date getDateHeader(String name) {
        return this.headers.getDateValue(name);
    }

    public boolean isRedirect() {
        return this.code != 304 && this.getCodeClass() == 3;
    }

    public boolean isError() {
        return this.getCodeClass() == 4 || this.getCodeClass() == 5;
    }

    public InputStream getBody() {
        return this.body;
    }
}

