/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.convert;

import gnu.gcj.convert.BytesToUnicode;
import gnu.java.nio.charset.EncodingHelper;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;

public class BytesToCharsetAdaptor
extends BytesToUnicode {
    private final CharsetDecoder decoder;
    private ByteBuffer inBuf;

    public BytesToCharsetAdaptor(Charset cs) {
        this(cs.newDecoder());
    }

    public BytesToCharsetAdaptor(CharsetDecoder dec) {
        this.decoder = dec;
        this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public String getName() {
        return EncodingHelper.getOldCanonical(this.decoder.charset().name());
    }

    public int read(char[] outbuffer, int outpos, int count) {
        if (this.inBuf == null || !this.inBuf.hasArray() || this.inBuf.array() != this.inbuffer) {
            this.inBuf = ByteBuffer.wrap(this.inbuffer);
        }
        this.inBuf.limit(this.inlength);
        this.inBuf.position(this.inpos);
        CharBuffer outBuf = CharBuffer.wrap(outbuffer, outpos, count);
        this.decoder.decode(this.inBuf, outBuf, false);
        this.inpos = this.inBuf.position();
        return outBuf.position() - outpos;
    }

    public void done() {
    }
}

