/*
 * Decompiled with CFR 0.152.
 */
package javax.print;

import gnu.javax.print.PrinterDialog;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.util.Arrays;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.PrintRequestAttributeSet;

public class ServiceUI {
    public static PrintService printDialog(GraphicsConfiguration gc, int x, int y, PrintService[] services, PrintService defaultService, DocFlavor flavor, PrintRequestAttributeSet attributes) throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException("GraphicsEnvironment is headless.");
        }
        if (services == null || services.length == 0 || attributes == null) {
            throw new IllegalArgumentException("Given print service array / attributes may not be null");
        }
        if (defaultService != null && !Arrays.asList(services).contains(defaultService)) {
            throw new IllegalArgumentException("defaultService is not contained  in the print service array");
        }
        PrinterDialog dialog = new PrinterDialog(gc, services, defaultService, flavor, attributes);
        dialog.setLocation(x, y);
        dialog.show();
        return dialog.getSelectedPrintService();
    }
}

