/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.net.PlainSocketImpl;
import gnu.java.nio.NIOSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NoConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;

public final class SocketChannelImpl
extends SocketChannel {
    private PlainSocketImpl impl;
    private NIOSocket socket;
    private boolean connectionPending;

    SocketChannelImpl(SelectorProvider provider) throws IOException {
        super(provider);
        this.impl = new PlainSocketImpl();
        this.impl.create(true);
        this.socket = new NIOSocket(this.impl, this);
        this.configureBlocking(true);
    }

    SocketChannelImpl(SelectorProvider provider, NIOSocket socket) throws IOException {
        super(provider);
        this.impl = socket.getPlainSocketImpl();
        this.socket = socket;
    }

    public void finalizer() {
        if (this.isConnected()) {
            try {
                this.close();
            }
            catch (Exception exception) {}
        }
    }

    PlainSocketImpl getPlainSocketImpl() {
        return this.impl;
    }

    int getNativeFD() {
        return this.socket.getPlainSocketImpl().getNativeFD();
    }

    protected void implCloseSelectableChannel() throws IOException {
        this.socket.close();
    }

    protected void implConfigureBlocking(boolean blocking) throws IOException {
        this.socket.setSoTimeout(blocking ? 0 : 50);
    }

    public boolean connect(SocketAddress remote) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.isConnected()) {
            throw new AlreadyConnectedException();
        }
        if (this.connectionPending) {
            throw new ConnectionPendingException();
        }
        if (!(remote instanceof InetSocketAddress)) {
            throw new UnsupportedAddressTypeException();
        }
        if (((InetSocketAddress)remote).isUnresolved()) {
            throw new UnresolvedAddressException();
        }
        try {
            this.socket.getPlainSocketImpl().setInChannelOperation(true);
            if (this.isBlocking()) {
                this.socket.connect(remote);
                return true;
            }
            this.socket.connect(remote, 50);
            return true;
        }
        finally {
            this.socket.getPlainSocketImpl().setInChannelOperation(false);
        }
    }

    public boolean finishConnect() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.isConnected() && !this.connectionPending) {
            throw new NoConnectionPendingException();
        }
        if (this.isConnected()) {
            return true;
        }
        AbstractSelector selector = this.provider().openSelector();
        this.register(selector, 8);
        if (this.isBlocking()) {
            selector.select();
            this.connectionPending = false;
            return true;
        }
        int ready = selector.selectNow();
        if (ready == 1) {
            this.connectionPending = false;
            return true;
        }
        return false;
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public boolean isConnectionPending() {
        return this.connectionPending;
    }

    public Socket socket() {
        return this.socket;
    }

    public int read(ByteBuffer dst) throws IOException {
        byte[] data;
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        int offset = 0;
        InputStream input = this.socket.getInputStream();
        int available = input.available();
        int len = dst.remaining();
        if (!this.isBlocking() && available == 0) {
            return 0;
        }
        if (dst.hasArray()) {
            offset = dst.arrayOffset() + dst.position();
            data = dst.array();
        } else {
            data = new byte[len];
        }
        int readBytes = 0;
        boolean completed = false;
        try {
            this.begin();
            this.socket.getPlainSocketImpl().setInChannelOperation(true);
            readBytes = input.read(data, offset, len);
            completed = true;
        }
        finally {
            this.end(completed);
            this.socket.getPlainSocketImpl().setInChannelOperation(false);
        }
        if (readBytes > 0) {
            if (dst.hasArray()) {
                dst.position(dst.position() + readBytes);
            } else {
                dst.put(data, offset, readBytes);
            }
        }
        return readBytes;
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        if (offset < 0 || offset > dsts.length || length < 0 || length > dsts.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        long readBytes = 0L;
        int index = offset;
        while (index < length) {
            readBytes += (long)this.read(dsts[index]);
            ++index;
        }
        return readBytes;
    }

    public int write(ByteBuffer src) throws IOException {
        byte[] data;
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        int offset = 0;
        int len = src.remaining();
        if (!src.hasArray()) {
            data = new byte[len];
            src.get(data, 0, len);
        } else {
            offset = src.arrayOffset() + src.position();
            data = src.array();
        }
        OutputStream output = this.socket.getOutputStream();
        boolean completed = false;
        try {
            this.begin();
            this.socket.getPlainSocketImpl().setInChannelOperation(true);
            output.write(data, offset, len);
            completed = true;
        }
        finally {
            this.end(completed);
            this.socket.getPlainSocketImpl().setInChannelOperation(false);
        }
        if (src.hasArray()) {
            src.position(src.position() + len);
        }
        return len;
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        if (offset < 0 || offset > srcs.length || length < 0 || length > srcs.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        long writtenBytes = 0L;
        int index = offset;
        while (index < length) {
            writtenBytes += (long)this.write(srcs[index]);
            ++index;
        }
        return writtenBytes;
    }
}

