/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.relaxng;

import gnu.xml.validation.relaxng.FullSyntaxBuilder;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RELAXNGSchemaFactory
extends SchemaFactory {
    LSResourceResolver resourceResolver;
    ErrorHandler errorHandler;

    public LSResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public void setResourceResolver(LSResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public boolean isSchemaLanguageSupported(String schemaLanguage) {
        return "http://relaxng.org/ns/structure/1.0".equals(schemaLanguage);
    }

    public Schema newSchema() throws SAXException {
        throw new UnsupportedOperationException();
    }

    public Schema newSchema(Source[] schemata) throws SAXException {
        if (schemata == null || schemata.length != 1) {
            throw new IllegalArgumentException("must specify one source");
        }
        try {
            Document doc = RELAXNGSchemaFactory.getDocument(schemata[0]);
            FullSyntaxBuilder builder = new FullSyntaxBuilder();
            return builder.parse(doc);
        }
        catch (IOException e) {
            SAXException e2 = new SAXException(e.getMessage());
            e2.initCause(e);
            throw e2;
        }
    }

    private static Document getDocument(Source source) throws SAXException, IOException {
        Node node2;
        if (source instanceof DOMSource && (node2 = ((DOMSource)source).getNode()) != null && node2 instanceof Document) {
            return (Document)node2;
        }
        String url = source.getSystemId();
        try {
            InputSource input = new InputSource(url);
            if (source instanceof StreamSource) {
                StreamSource streamSource = (StreamSource)source;
                input.setByteStream(streamSource.getInputStream());
                input.setCharacterStream(streamSource.getReader());
            }
            if (input.getByteStream() == null && input.getCharacterStream() == null && url != null) {
                input.setByteStream(new URL(url).openStream());
            }
            DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
            f.setNamespaceAware(true);
            f.setCoalescing(true);
            f.setExpandEntityReferences(true);
            f.setIgnoringComments(true);
            f.setIgnoringElementContentWhitespace(true);
            DocumentBuilder b = f.newDocumentBuilder();
            return b.parse(input);
        }
        catch (ParserConfigurationException e) {
            SAXException e2 = new SAXException(e.getMessage());
            e2.initCause(e);
            throw e2;
        }
    }
}

