/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPEncoder;
import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;

public class EncodeRGB16
extends BMPEncoder {
    protected BMPInfoHeader infoHeader;
    protected BMPFileHeader fileHeader;
    protected long offset;

    public EncodeRGB16(BMPFileHeader fh, BMPInfoHeader ih) {
        this.fileHeader = fh;
        this.infoHeader = ih;
        this.offset = 54L;
    }

    public void encode(ImageOutputStream o, IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        int rowIndex;
        byte[] rgb = new byte[2];
        int size = this.infoHeader.biWidth * this.infoHeader.biHeight - 1;
        int rowCount = 1;
        int lastRowIndex = rowIndex = size - this.infoHeader.biWidth;
        try {
            int[] bitmap = new int[this.infoHeader.biWidth * this.infoHeader.biHeight];
            PixelGrabber pg = new PixelGrabber((BufferedImage)image.getRenderedImage(), 0, 0, this.infoHeader.biWidth, this.infoHeader.biHeight, bitmap, 0, this.infoHeader.biWidth);
            pg.grabPixels();
            int j = 0;
            while (j < size) {
                int value = bitmap[rowIndex];
                rgb[0] = (byte)(value & 0xFF);
                rgb[1] = (byte)(value >> 8 & 0xFF);
                o.write(rgb);
                if (rowCount == this.infoHeader.biWidth) {
                    rowCount = 1;
                    lastRowIndex = rowIndex = lastRowIndex - this.infoHeader.biWidth;
                } else {
                    ++rowCount;
                }
                ++rowIndex;
                ++j;
            }
        }
        catch (Exception wb) {
            wb.printStackTrace();
        }
    }
}

