/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GdkScreenGraphicsDevice;
import gnu.java.awt.peer.gtk.GtkVolatileImage;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.VolatileImage;

public class GdkGraphicsConfiguration
extends GraphicsConfiguration {
    GdkScreenGraphicsDevice gdkScreenGraphicsDevice;
    ColorModel opaqueColorModel;
    ColorModel bitmaskColorModel;
    ColorModel translucentColorModel;

    public GdkGraphicsConfiguration(GdkScreenGraphicsDevice dev) {
        this.gdkScreenGraphicsDevice = dev;
        this.opaqueColorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, 0);
        this.bitmaskColorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, 0x1000000);
        this.translucentColorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
    }

    public GraphicsDevice getDevice() {
        return this.gdkScreenGraphicsDevice;
    }

    public BufferedImage createCompatibleImage(int w, int h) {
        return new BufferedImage(w, h, 2);
    }

    public BufferedImage createCompatibleImage(int w, int h, int transparency) {
        return this.createCompatibleImage(w, h);
    }

    public VolatileImage createCompatibleVolatileImage(int w, int h) {
        return new GtkVolatileImage(w, h);
    }

    public VolatileImage createCompatibleVolatileImage(int w, int h, ImageCapabilities caps) throws AWTException {
        return new GtkVolatileImage(w, h, caps);
    }

    public ColorModel getColorModel() {
        return this.opaqueColorModel;
    }

    public ColorModel getColorModel(int transparency) {
        switch (transparency) {
            case 1: {
                return this.opaqueColorModel;
            }
            case 2: {
                return this.bitmaskColorModel;
            }
        }
        return this.translucentColorModel;
    }

    public AffineTransform getDefaultTransform() {
        return new AffineTransform();
    }

    public AffineTransform getNormalizingTransform() {
        return new AffineTransform();
    }

    public Rectangle getBounds() {
        return this.gdkScreenGraphicsDevice.getBounds();
    }

    public BufferCapabilities getBufferCapabilities() {
        return new BufferCapabilities(this.getImageCapabilities(), this.getImageCapabilities(), BufferCapabilities.FlipContents.UNDEFINED);
    }

    public ImageCapabilities getImageCapabilities() {
        return new ImageCapabilities(false);
    }

    public VolatileImage createCompatibleVolatileImage(int width, int height, int transparency) {
        return new GtkVolatileImage(width, height);
    }
}

