/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.naming.jndi.url.rmi;

import gnu.javax.naming.jndi.url.rmi.ListBindingsEnumeration;
import gnu.javax.naming.jndi.url.rmi.ListEnumeration;
import gnu.javax.naming.jndi.url.rmi.rmiURLContext;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;

public class ContextContinuation
implements Context {
    public static final String DEFAULT_REGISTRY_LOCATION = "rmi://localhost:1099";
    Registry registry;
    Properties properties = new Properties();
    boolean lookupCalled;

    public Object addToEnvironment(String key, Object value) {
        this.removeRegistry();
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return this.properties.put(key, value);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.properties;
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        this.removeRegistry();
        return this.properties.remove(propName);
    }

    public void removeRegistry() {
        this.registry = null;
    }

    public Registry getRegistry() throws NamingException {
        if (this.registry == null) {
            int port;
            String address = this.properties.getProperty("java.naming.provider.url", DEFAULT_REGISTRY_LOCATION);
            if (!address.startsWith("rmi://")) {
                throw new InvalidNameException(address);
            }
            String a = address.substring("rmi://".length());
            int colon = a.lastIndexOf(58);
            try {
                if (colon >= 0) {
                    port = Integer.parseInt(a.substring(colon + 1));
                    a = a.substring(0, colon);
                } else {
                    port = 1099;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidNameException(address);
            }
            try {
                this.registry = LocateRegistry.getRegistry(a, port);
            }
            catch (RemoteException e) {
                throw new CommunicationException(e.toString());
            }
        }
        return this.registry;
    }

    public ContextContinuation(Map props, Registry initialRegistry) {
        if (props != null) {
            this.properties.putAll(props);
        }
        this.registry = initialRegistry;
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void bind(String name, Object obj) throws NamingException {
        try {
            this.getRegistry().bind(name, (Remote)obj);
        }
        catch (AccessException e) {
            throw new NamingException("access:" + e.toString());
        }
        catch (RemoteException e) {
            throw new CommunicationException(e.toString());
        }
        catch (AlreadyBoundException alreadyBoundException) {
            throw new NameAlreadyBoundException(name);
        }
        catch (ClassCastException classCastException) {
            throw new NamingException("Only Remote can be bound:" + obj.getClass().getName());
        }
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public String composeName(String name, String prefix) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (name.size() == 0) {
            return new rmiURLContext(this.properties);
        }
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(String name) throws NamingException {
        if (name.length() == 0) {
            return new rmiURLContext(this.properties);
        }
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public String getNameInNamespace() throws NamingException {
        return this.properties.getProperty("java.naming.provider.url", DEFAULT_REGISTRY_LOCATION);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NameParser getNameParser(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (name.size() > 0) {
            throw new OperationNotSupportedException("Only empty name is accepted");
        }
        return this.list("");
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (name.length() > 0) {
            throw new OperationNotSupportedException("Only empty name is accepted");
        }
        try {
            return new ListEnumeration(this.getRegistry().list());
        }
        catch (Exception e) {
            throw new NamingException(e.toString());
        }
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (name.size() > 0) {
            throw new OperationNotSupportedException("Only empty name is accepted");
        }
        return this.listBindings("");
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (name.length() > 0) {
            throw new OperationNotSupportedException("Only empty name is accepted");
        }
        try {
            Registry r = this.getRegistry();
            return new ListBindingsEnumeration(r.list(), r);
        }
        catch (Exception e) {
            throw new NamingException(e.toString());
        }
    }

    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object lookupLink(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        try {
            this.getRegistry().rebind(name, (Remote)obj);
        }
        catch (AccessException e) {
            throw new NamingException("access:" + e.toString());
        }
        catch (RemoteException e) {
            throw new CommunicationException(e.toString());
        }
        catch (ClassCastException classCastException) {
            throw new NamingException("Only Remote can be bound:" + obj.getClass().getName());
        }
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        this.rename(oldName.toString(), newName.toString());
    }

    public synchronized void rename(String oldName, String newName) throws NamingException {
        try {
            Registry r = this.getRegistry();
            Remote object = r.lookup(oldName);
            r.unbind(oldName);
            try {
                r.bind(newName, object);
            }
            catch (AlreadyBoundException alreadyBoundException) {
                try {
                    r.bind(oldName, object);
                }
                catch (AlreadyBoundException alreadyBoundException2) {
                    throw new InternalError();
                }
                throw new NameAlreadyBoundException(newName);
            }
        }
        catch (AccessException e) {
            throw new NamingException(e.toString());
        }
        catch (RemoteException e) {
            throw new CommunicationException(e.toString());
        }
        catch (NotBoundException e) {
            throw new CommunicationException(e.toString());
        }
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void unbind(String name) throws NamingException {
        try {
            this.getRegistry().unbind(name);
        }
        catch (AccessException e) {
            throw new NamingException(e.toString());
        }
        catch (RemoteException e) {
            throw new CommunicationException(e.toString());
        }
        catch (NotBoundException e) {
            throw new CommunicationException(e.toString());
        }
    }

    public void close() throws NamingException {
        this.removeRegistry();
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public Object lookup(String name) throws NamingException {
        try {
            return this.getRegistry().lookup(name);
        }
        catch (AccessException e) {
            throw new NamingException(e.toString());
        }
        catch (RemoteException e) {
            throw new CommunicationException(e.toString());
        }
        catch (NotBoundException notBoundException) {
            throw new NameNotFoundException(name);
        }
    }
}

