/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.management;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidApplicationException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanPermission;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.MBeanTrustPermission;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.StandardMBean;
import javax.management.loading.ClassLoaderRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
implements MBeanServer {
    private static final ObjectName DELEGATE_NAME;
    private final ConcurrentHashMap<ObjectName, ServerInfo> beans = new ConcurrentHashMap();
    private final String defaultDomain;
    private final MBeanServer outer;
    private ClassLoaderRepository repository;
    private final MBeanServerDelegate delegate;
    private static final AtomicLong sequenceNumber;

    static {
        sequenceNumber = new AtomicLong(1L);
        try {
            DELEGATE_NAME = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (MalformedObjectNameException e) {
            throw (Error)new InternalError("Failed to construct the delegate's object name.").initCause(e);
        }
    }

    public Server(String defaultDomain, MBeanServer outer, MBeanServerDelegate delegate) {
        this.defaultDomain = defaultDomain;
        this.outer = outer;
        this.delegate = delegate;
        try {
            this.registerMBean(delegate, DELEGATE_NAME);
        }
        catch (InstanceAlreadyExistsException e) {
            throw (Error)new InternalError("The delegate bean is already registered.").initCause(e);
        }
        catch (MBeanRegistrationException e) {
            throw (Error)new InternalError("The delegate bean's preRegister methods threw an exception.").initCause(e);
        }
        catch (NotCompliantMBeanException e) {
            throw (Error)new InternalError("The delegate bean is not compliant.").initCause(e);
        }
    }

    private void checkSecurity(ObjectName name, String member, String action) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                MBeanInfo info = null;
                if (name != null) {
                    Object bean = this.getBean(name);
                    Method method = bean.getClass().getMethod("getMBeanInfo", new Class[0]);
                    info = (MBeanInfo)method.invoke(bean, new Object[0]);
                }
                sm.checkPermission(new MBeanPermission(info == null ? null : info.getClassName(), member, name, action));
            }
            catch (InstanceNotFoundException e) {
                throw (Error)new InternalError("Failed to get bean.").initCause(e);
            }
            catch (NoSuchMethodException e) {
                throw (Error)new InternalError("Failed to get bean info.").initCause(e);
            }
            catch (IllegalAccessException e) {
                throw (Error)new InternalError("Failed to get bean info.").initCause(e);
            }
            catch (IllegalArgumentException e) {
                throw (Error)new InternalError("Failed to get bean info.").initCause(e);
            }
            catch (InvocationTargetException e) {
                throw (Error)new InternalError("Failed to get bean info.").initCause(e);
            }
        }
    }

    private Object getBean(ObjectName name) throws InstanceNotFoundException {
        ServerInfo bean = this.beans.get(name);
        if (bean == null) {
            throw new InstanceNotFoundException("The bean, " + name + ", was not found.");
        }
        return bean.getObject();
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object passback) throws InstanceNotFoundException {
        Object bean = this.getBean(name);
        this.checkSecurity(name, null, "addNotificationListener");
        if (bean instanceof NotificationBroadcaster) {
            NotificationBroadcaster bbean = (NotificationBroadcaster)bean;
            ServerNotificationListener indirection = new ServerNotificationListener(bean, name, listener);
            bbean.addNotificationListener(indirection, filter, passback);
            LazyListenersHolder.listeners.put(listener, indirection);
        }
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object passback) throws InstanceNotFoundException {
        Object lbean = this.getBean(listener);
        if (!(lbean instanceof NotificationListener)) {
            IllegalArgumentException e = new IllegalArgumentException("The supplied listener name does not correspond to a notification listener.");
            throw new RuntimeOperationsException(e);
        }
        this.addNotificationListener(name, (NotificationListener)lbean, filter, passback);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.createMBean(className, name, null, null);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] sig) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.registerMBean(this.instantiate(className, params, sig), name);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.createMBean(className, name, loaderName, null, null);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] sig) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.registerMBean(this.instantiate(className, loaderName, params, sig), name);
    }

    @Override
    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        try {
            return new ServerInputStream(new ByteArrayInputStream(data), this.getClassLoaderFor(name));
        }
        catch (IOException e) {
            throw new OperationsException("An I/O error occurred: " + e);
        }
    }

    @Override
    public ObjectInputStream deserialize(String name, byte[] data) throws OperationsException, ReflectionException {
        try {
            Class<?> c = this.getClassLoaderRepository().loadClass(name);
            return new ServerInputStream(new ByteArrayInputStream(data), c.getClassLoader());
        }
        catch (IOException e) {
            throw new OperationsException("An I/O error occurred: " + e);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e, "The class could not be found.");
        }
    }

    @Override
    public ObjectInputStream deserialize(String name, ObjectName loader, byte[] data) throws InstanceNotFoundException, ReflectionException, OperationsException {
        try {
            Class<?> c = this.getClassLoader(loader).loadClass(name);
            return new ServerInputStream(new ByteArrayInputStream(data), c.getClassLoader());
        }
        catch (IOException e) {
            throw new OperationsException("An I/O error occurred: " + e);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e, "The class could not be found.");
        }
    }

    @Override
    public Object getAttribute(ObjectName bean, String name) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        if (bean == null || name == null) {
            IllegalArgumentException e = new IllegalArgumentException("One of the supplied arguments was null.");
            throw new RuntimeOperationsException(e);
        }
        Object abean = this.getBean(bean);
        this.checkSecurity(bean, name, "getAttribute");
        if (abean instanceof DynamicMBean) {
            return ((DynamicMBean)abean).getAttribute(name);
        }
        try {
            return new StandardMBean(abean, null).getAttribute(name);
        }
        catch (NotCompliantMBeanException e) {
            throw (Error)new InternalError("Failed to create dynamic bean.").initCause(e);
        }
    }

    @Override
    public AttributeList getAttributes(ObjectName bean, String[] names) throws InstanceNotFoundException, ReflectionException {
        if (bean == null || names == null) {
            IllegalArgumentException e = new IllegalArgumentException("One of the supplied arguments was null.");
            throw new RuntimeOperationsException(e);
        }
        Object abean = this.getBean(bean);
        this.checkSecurity(bean, null, "getAttribute");
        AttributeList list2 = new AttributeList(names.length);
        int a = 0;
        while (a < names.length) {
            if (names[a] == null) {
                IllegalArgumentException e = new IllegalArgumentException("Argument " + a + " was null.");
                throw new RuntimeOperationsException(e);
            }
            this.checkSecurity(bean, names[a], "getAttribute");
            try {
                Object value;
                if (abean instanceof DynamicMBean) {
                    value = ((DynamicMBean)abean).getAttribute(names[a]);
                } else {
                    try {
                        value = new StandardMBean(abean, null).getAttribute(names[a]);
                    }
                    catch (NotCompliantMBeanException e) {
                        throw (Error)new InternalError("Failed to create dynamic bean.").initCause(e);
                    }
                }
                list2.add(new Attribute(names[a], value));
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
            }
            catch (MBeanException mBeanException) {}
            ++a;
        }
        return list2;
    }

    @Override
    public ClassLoader getClassLoader(ObjectName name) throws InstanceNotFoundException {
        if (name == null) {
            this.checkSecurity(null, null, "getClassLoader");
            return this.getClass().getClassLoader();
        }
        Object bean = this.getBean(name);
        this.checkSecurity(name, null, "getClassLoader");
        return (ClassLoader)bean;
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName name) throws InstanceNotFoundException {
        Object bean = this.getBean(name);
        this.checkSecurity(name, null, "getClassLoaderFor");
        return bean.getClass().getClassLoader();
    }

    @Override
    public ClassLoaderRepository getClassLoaderRepository() {
        return this.repository;
    }

    @Override
    public String getDefaultDomain() {
        return this.defaultDomain;
    }

    @Override
    public String[] getDomains() {
        this.checkSecurity(null, null, "getDomains");
        HashSet<String> domains = new HashSet<String>();
        Iterator<ObjectName> iterator = this.beans.keySet().iterator();
        while (iterator.hasNext()) {
            String d = iterator.next().getDomain();
            try {
                this.checkSecurity(new ObjectName(String.valueOf(d) + ":x=x"), null, "getDomains");
                domains.add(d);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {}
        }
        return domains.toArray(new String[domains.size()]);
    }

    @Override
    public Integer getMBeanCount() {
        return this.beans.size();
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        Object bean = this.getBean(name);
        this.checkSecurity(name, null, "getMBeanInfo");
        try {
            Method method = bean.getClass().getMethod("getMBeanInfo", new Class[0]);
            return (MBeanInfo)method.invoke(bean, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                return new StandardMBean(bean, null).getMBeanInfo();
            }
            catch (NotCompliantMBeanException ex) {
                throw new IntrospectionException("An error occurred in executing getMBeanInfo on the bean: " + ex + ".");
            }
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e, "Failed to call getMBeanInfo");
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e, "Failed to call getMBeanInfo");
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e, "The method threw an exception");
        }
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        ServerInfo bean = this.beans.get(name);
        if (bean == null) {
            throw new InstanceNotFoundException("The bean, " + name + ", was not found.");
        }
        return bean.getInstance();
    }

    @Override
    public Object instantiate(String name) throws ReflectionException, MBeanException {
        return this.instantiate(name, null, null);
    }

    @Override
    public Object instantiate(String name, Object[] params, String[] sig) throws ReflectionException, MBeanException {
        this.checkSecurity(null, null, "instantiate");
        if (name == null) {
            IllegalArgumentException e = new IllegalArgumentException("The name was null.");
            throw new RuntimeOperationsException(e);
        }
        Class[] sigTypes = new Class[sig.length];
        int a = 0;
        while (a < sigTypes.length) {
            try {
                sigTypes[a] = this.repository.loadClass(sig[a]);
            }
            catch (ClassNotFoundException e) {
                throw new ReflectionException(e, "The class, " + sigTypes[a] + ", in the method signature " + "could not be loaded.");
            }
            ++a;
        }
        try {
            Constructor<?> cons = this.repository.loadClass(name).getConstructor(sigTypes);
            return cons.newInstance(params);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e, "The class, " + name + ", of the constructor " + "could not be loaded.");
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e, "The method, " + name + ", could not be found.");
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e, "Failed to instantiate the object");
        }
        catch (InstantiationException e) {
            throw new ReflectionException(e, "Failed to instantiate the object");
        }
        catch (InvocationTargetException e) {
            throw new MBeanException((Exception)e.getCause(), "The constructor " + name + " threw an exception");
        }
    }

    @Override
    public Object instantiate(String name, ObjectName loaderName) throws InstanceNotFoundException, ReflectionException, MBeanException {
        return this.instantiate(name, loaderName);
    }

    @Override
    public Object instantiate(String name, ObjectName loaderName, Object[] params, String[] sig) throws InstanceNotFoundException, ReflectionException, MBeanException {
        this.checkSecurity(null, null, "instantiate");
        if (name == null) {
            IllegalArgumentException e = new IllegalArgumentException("The name was null.");
            throw new RuntimeOperationsException(e);
        }
        ClassLoader loader = this.getClassLoader(loaderName);
        Class[] sigTypes = new Class[sig.length];
        int a = 0;
        while (a < sig.length) {
            try {
                sigTypes[a] = Class.forName(sig[a], true, loader);
            }
            catch (ClassNotFoundException e) {
                throw new ReflectionException(e, "The class, " + sig[a] + ", in the method signature " + "could not be loaded.");
            }
            ++a;
        }
        try {
            Constructor<?> cons = Class.forName(name, true, loader).getConstructor(sigTypes);
            return cons.newInstance(params);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e, "The class, " + name + ", of the constructor " + "could not be loaded.");
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e, "The method, " + name + ", could not be found.");
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e, "Failed to instantiate the object");
        }
        catch (InstantiationException e) {
            throw new ReflectionException(e, "Failed to instantiate the object");
        }
        catch (InvocationTargetException e) {
            throw new MBeanException((Exception)e.getCause(), "The constructor " + name + " threw an exception");
        }
    }

    @Override
    public Object invoke(ObjectName bean, String name, Object[] params, String[] sig) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (bean == null) {
            IllegalArgumentException e = new IllegalArgumentException("The bean was null.");
            throw new RuntimeOperationsException(e);
        }
        Object abean = this.getBean(bean);
        this.checkSecurity(bean, name, "invoke");
        if (abean instanceof DynamicMBean) {
            return ((DynamicMBean)abean).invoke(name, params, sig);
        }
        try {
            return new StandardMBean(abean, null).invoke(name, params, sig);
        }
        catch (NotCompliantMBeanException e) {
            throw (Error)new InternalError("Failed to create dynamic bean.").initCause(e);
        }
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        MBeanInfo info;
        Object bean = this.getBean(name);
        this.checkSecurity(name, null, "isInstanceOf");
        if (bean instanceof DynamicMBean) {
            info = ((DynamicMBean)bean).getMBeanInfo();
        } else {
            try {
                info = new StandardMBean(bean, null).getMBeanInfo();
            }
            catch (NotCompliantMBeanException e) {
                throw (Error)new InternalError("Failed to create dynamic bean.").initCause(e);
            }
        }
        if (info.getClassName().equals(className)) {
            return true;
        }
        Class<? extends Object> bclass = bean.getClass();
        try {
            Class<? extends Object> oclass = Class.forName(className);
            return bclass.getClassLoader().equals(oclass.getClassLoader()) && oclass.isAssignableFrom(bclass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @Override
    public boolean isRegistered(ObjectName name) {
        if (name == null) {
            IllegalArgumentException e = new IllegalArgumentException("The name was null.");
            throw new RuntimeOperationsException(e);
        }
        return this.beans.containsKey(name);
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        this.checkSecurity(name, null, "queryMBeans");
        HashSet<ObjectInstance> results = new HashSet<ObjectInstance>();
        for (Map.Entry<ObjectName, ServerInfo> entry : this.beans.entrySet()) {
            ObjectName nextName = entry.getKey();
            this.checkSecurity(name, nextName.toString(), "queryMBeans");
            try {
                if (name != null && !name.apply(nextName) || query != null && !query.apply(nextName)) continue;
                results.add(entry.getValue().getInstance());
            }
            catch (BadStringOperationException badStringOperationException) {
            }
            catch (BadBinaryOpValueExpException badBinaryOpValueExpException) {
            }
            catch (BadAttributeValueExpException badAttributeValueExpException) {
            }
            catch (InvalidApplicationException invalidApplicationException) {}
        }
        return results;
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        this.checkSecurity(name, null, "queryNames");
        HashSet<ObjectName> results = new HashSet<ObjectName>();
        for (ObjectName nextName : this.beans.keySet()) {
            this.checkSecurity(name, nextName.toString(), "queryNames");
            try {
                if (name != null && !name.apply(nextName) || query != null && !query.apply(nextName)) continue;
                results.add(nextName);
            }
            catch (BadStringOperationException badStringOperationException) {
            }
            catch (BadBinaryOpValueExpException badBinaryOpValueExpException) {
            }
            catch (BadAttributeValueExpException badAttributeValueExpException) {
            }
            catch (InvalidApplicationException invalidApplicationException) {}
        }
        return results;
    }

    @Override
    public ObjectInstance registerMBean(Object obj, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectInstance obji;
        SecurityManager sm = System.getSecurityManager();
        Class<? extends Object> cl = obj.getClass();
        String className = cl.getName();
        if (sm != null) {
            sm.checkPermission(new MBeanPermission(className, null, name, "registerMBean"));
            if (!cl.getProtectionDomain().implies(new MBeanTrustPermission("register"))) {
                throw new SecurityException("The protection domain of the object's classdoes not imply the trust permission,register");
            }
        }
        if (obj == null) {
            IllegalArgumentException e = new IllegalArgumentException("The object was null.");
            throw new RuntimeOperationsException(e);
        }
        MBeanRegistration register = null;
        if (obj instanceof MBeanRegistration) {
            register = (MBeanRegistration)obj;
        }
        if (name == null && register == null) {
            IllegalArgumentException e = new IllegalArgumentException("The name was null and the bean does not implement MBeanRegistration.");
            throw new RuntimeOperationsException(e);
        }
        if (register != null) {
            try {
                name = register.preRegister(this, name);
                if (name == null) {
                    NullPointerException e = new NullPointerException("The name returned by MBeanRegistration.preRegister() was null");
                    throw e;
                }
                if (sm != null) {
                    sm.checkPermission(new MBeanPermission(className, null, name, "registerMBean"));
                }
            }
            catch (SecurityException e) {
                register.postRegister(Boolean.FALSE);
                throw e;
            }
            catch (Exception e) {
                register.postRegister(Boolean.FALSE);
                throw new MBeanRegistrationException(e, "Pre-registration failed.");
            }
        }
        if (this.beans.putIfAbsent(name, new ServerInfo(obji = new ObjectInstance(name, className), obj)) != null) {
            if (register != null) {
                register.postRegister(Boolean.FALSE);
            }
            throw new InstanceAlreadyExistsException(name + "is already registered.");
        }
        if (register != null) {
            register.postRegister(Boolean.TRUE);
        }
        this.notify(name, "JMX.mbean.registered");
        return obji;
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        Object bean = this.getBean(name);
        this.checkSecurity(name, null, "removeNotificationListener");
        if (bean instanceof NotificationBroadcaster) {
            NotificationBroadcaster bbean = (NotificationBroadcaster)bean;
            bbean.removeNotificationListener(listener);
            LazyListenersHolder.listeners.remove(listener);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object passback) throws InstanceNotFoundException, ListenerNotFoundException {
        Object bean = this.getBean(name);
        this.checkSecurity(name, null, "removeNotificationListener");
        if (bean instanceof NotificationEmitter) {
            NotificationEmitter bbean = (NotificationEmitter)bean;
            bbean.removeNotificationListener(listener, filter, passback);
            LazyListenersHolder.listeners.remove(listener);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        Object lbean = this.getBean(listener);
        if (!(lbean instanceof NotificationListener)) {
            IllegalArgumentException e = new IllegalArgumentException("The supplied listener name does not correspond to a notification listener.");
            throw new RuntimeOperationsException(e);
        }
        this.removeNotificationListener(name, (NotificationListener)lbean);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object passback) throws InstanceNotFoundException, ListenerNotFoundException {
        Object lbean = this.getBean(listener);
        if (!(lbean instanceof NotificationListener)) {
            IllegalArgumentException e = new IllegalArgumentException("The supplied listener name does not correspond to a notification listener.");
            throw new RuntimeOperationsException(e);
        }
        this.removeNotificationListener(name, (NotificationListener)lbean, filter, passback);
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null || name == null) {
            IllegalArgumentException e = new IllegalArgumentException("One of the supplied arguments was null.");
            throw new RuntimeOperationsException(e);
        }
        Object bean = this.getBean(name);
        this.checkSecurity(name, attribute.getName(), "setAttribute");
        if (bean instanceof DynamicMBean) {
            ((DynamicMBean)bean).setAttribute(attribute);
        } else {
            try {
                new StandardMBean(bean, null).setAttribute(attribute);
            }
            catch (NotCompliantMBeanException e) {
                throw (Error)new InternalError("Failed to create dynamic bean.").initCause(e);
            }
        }
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        if (name == null || attributes == null) {
            IllegalArgumentException e = new IllegalArgumentException("One of the supplied arguments was null.");
            throw new RuntimeOperationsException(e);
        }
        Object abean = this.getBean(name);
        this.checkSecurity(name, null, "setAttribute");
        AttributeList list2 = new AttributeList(attributes.size());
        Iterator it = attributes.iterator();
        while (it.hasNext()) {
            try {
                Attribute attrib = (Attribute)it.next();
                if (attrib == null) {
                    IllegalArgumentException e = new IllegalArgumentException("An attribute was null.");
                    throw new RuntimeOperationsException(e);
                }
                this.checkSecurity(name, attrib.getName(), "setAttribute");
                if (abean instanceof DynamicMBean) {
                    ((DynamicMBean)abean).setAttribute(attrib);
                } else {
                    try {
                        new StandardMBean(abean, null).setAttribute(attrib);
                    }
                    catch (NotCompliantMBeanException e) {
                        throw (Error)new InternalError("Failed to create dynamic bean.").initCause(e);
                    }
                }
                list2.add(attrib);
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
            }
            catch (MBeanException mBeanException) {}
        }
        return list2;
    }

    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        if (name == null) {
            IllegalArgumentException e = new IllegalArgumentException("The name was null.");
            throw new RuntimeOperationsException(e);
        }
        if (name.equals(DELEGATE_NAME)) {
            IllegalArgumentException e = new IllegalArgumentException("The delegate can not be unregistered.");
            throw new RuntimeOperationsException(e);
        }
        Object bean = this.getBean(name);
        this.checkSecurity(name, null, "unregisterMBean");
        MBeanRegistration register = null;
        if (bean instanceof MBeanRegistration) {
            register = (MBeanRegistration)bean;
            try {
                register.preDeregister();
            }
            catch (Exception e) {
                throw new MBeanRegistrationException(e, "Pre-deregistration failed.");
            }
        }
        this.beans.remove(name);
        this.notify(name, "JMX.mbean.unregistered");
        if (register != null) {
            register.postDeregister();
        }
    }

    private void notify(ObjectName name, String type) {
        this.delegate.sendNotification(new MBeanServerNotification(type, (Object)DELEGATE_NAME, sequenceNumber.getAndIncrement(), name));
    }

    private static class LazyListenersHolder {
        private static final Map<NotificationListener, NotificationListener> listeners = new ConcurrentHashMap<NotificationListener, NotificationListener>();

        private LazyListenersHolder() {
        }
    }

    private class ServerInfo {
        private ObjectInstance instance;
        private Object object;

        public ServerInfo(ObjectInstance instance, Object object) {
            this.instance = instance;
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }

        public ObjectInstance getInstance() {
            return this.instance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ServerInputStream
    extends ObjectInputStream {
        private ClassLoader cl;

        public ServerInputStream(InputStream is, ClassLoader cl) throws IOException, StreamCorruptedException {
            super(is);
            this.cl = cl;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass osc) throws ClassNotFoundException, IOException {
            try {
                return Class.forName(osc.getName(), true, this.cl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return super.resolveClass(osc);
            }
        }
    }

    private class ServerNotificationListener
    implements NotificationListener {
        Object bean;
        ObjectName name;
        NotificationListener listener;

        public ServerNotificationListener(Object bean, ObjectName name, NotificationListener listener) {
            this.bean = bean;
            this.name = name;
            this.listener = listener;
        }

        public void handleNotification(Notification notif, Object handback) {
            if (notif.getSource() == this.bean) {
                notif.setSource(this.name);
            }
            this.listener.handleNotification(notif, handback);
        }
    }
}

