/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.event.FocusEvent;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.NavigationFilter;
import javax.swing.text.NumberFormatter;

public class JFormattedTextField
extends JTextField {
    private static final long serialVersionUID = 5464657870110180632L;
    public static final int COMMIT = 0;
    public static final int COMMIT_OR_REVERT = 1;
    public static final int REVERT = 2;
    public static final int PERSIST = 3;
    private Object value;
    private int focusLostBehavior = 1;
    private AbstractFormatterFactory formatterFactory;
    private AbstractFormatter formatter;
    boolean editValid = true;

    public JFormattedTextField() {
        this(null, null);
    }

    public JFormattedTextField(Format format) {
        this();
        this.setFormatterFactory(this.getAppropriateFormatterFactory(format));
    }

    public JFormattedTextField(AbstractFormatter formatter) {
        this(new DefaultFormatterFactory(formatter));
    }

    public JFormattedTextField(AbstractFormatterFactory factory) {
        this.setFormatterFactory(factory);
    }

    public JFormattedTextField(AbstractFormatterFactory factory, Object value) {
        this.setFormatterFactory(factory);
        this.setValue(value);
    }

    public JFormattedTextField(Object value) {
        this.setValue(value);
    }

    private AbstractFormatterFactory getAppropriateFormatterFactory(Format format) {
        InternationalFormatter newFormatter = format instanceof DateFormat ? new DateFormatter((DateFormat)format) : (format instanceof NumberFormat ? new NumberFormatter((NumberFormat)format) : new InternationalFormatter(format));
        return new DefaultFormatterFactory(newFormatter);
    }

    public void commitEdit() throws ParseException {
        if (this.formatter == null) {
            return;
        }
        Object oldValue = this.value;
        this.value = this.formatter.stringToValue(this.getText());
        this.editValid = true;
        this.firePropertyChange("value", oldValue, this.value);
    }

    public Action[] getActions() {
        return super.getActions();
    }

    public int getFocusLostBehavior() {
        return this.focusLostBehavior;
    }

    public AbstractFormatter getFormatter() {
        return this.formatter;
    }

    public AbstractFormatterFactory getFormatterFactory() {
        return this.formatterFactory;
    }

    public String getUIClassID() {
        return "FormattedTextFieldUI";
    }

    public Object getValue() {
        return this.value;
    }

    protected void invalidEdit() {
        UIManager.getLookAndFeel().provideErrorFeedback(this);
    }

    public boolean isEditValid() {
        return this.editValid;
    }

    protected void processFocusEvent(FocusEvent evt) {
        super.processFocusEvent(evt);
        this.setFormatter(this.formatterFactory.getFormatter(this));
    }

    public void setDocument(Document newDocument) {
        Document oldDocument = this.getDocument();
        if (oldDocument == newDocument) {
            return;
        }
        super.setDocument(newDocument);
    }

    public void setFocusLostBehavior(int behavior) {
        if (behavior != 0 && behavior != 1 && behavior != 3 && behavior != 2) {
            throw new IllegalArgumentException("invalid behavior");
        }
        this.focusLostBehavior = behavior;
    }

    protected void setFormatter(AbstractFormatter formatter) {
        AbstractFormatter oldFormatter = null;
        oldFormatter = this.formatter;
        if (oldFormatter != null) {
            oldFormatter.uninstall();
        }
        this.formatter = formatter;
        if (formatter != null) {
            formatter.install(this);
        }
        this.firePropertyChange("formatter", oldFormatter, formatter);
    }

    public void setFormatterFactory(AbstractFormatterFactory factory) {
        if (this.formatterFactory == factory) {
            return;
        }
        AbstractFormatterFactory oldFactory = this.formatterFactory;
        this.formatterFactory = factory;
        this.firePropertyChange("formatterFactory", oldFactory, factory);
        if (this.formatterFactory != null) {
            this.setFormatter(this.formatterFactory.getFormatter(this));
        } else {
            this.setFormatter(null);
        }
    }

    public void setValue(Object newValue) {
        if (this.value == newValue) {
            return;
        }
        Object oldValue = this.value;
        this.value = newValue;
        if (this.formatterFactory == null) {
            this.setFormatterFactory(this.createFormatterFactory(newValue));
        }
        this.setFormatter(this.formatterFactory.getFormatter(this));
        this.firePropertyChange("value", oldValue, newValue);
    }

    AbstractFormatterFactory createFormatterFactory(Object value) {
        DefaultFormatter formatter = null;
        formatter = value instanceof Date ? new DateFormatter() : (value instanceof Number ? new NumberFormatter() : new DefaultFormatter());
        return new DefaultFormatterFactory(formatter);
    }

    public static abstract class AbstractFormatter
    implements Serializable {
        private static final long serialVersionUID = -5193212041738979680L;
        private JFormattedTextField textField;

        protected Object clone() throws CloneNotSupportedException {
            AbstractFormatter newFormatter = (AbstractFormatter)super.clone();
            newFormatter.textField = null;
            return newFormatter;
        }

        protected Action[] getActions() {
            return null;
        }

        protected DocumentFilter getDocumentFilter() {
            return null;
        }

        protected JFormattedTextField getFormattedTextField() {
            return this.textField;
        }

        protected NavigationFilter getNavigationFilter() {
            return null;
        }

        public void install(JFormattedTextField textField) {
            if (this.textField != null) {
                this.uninstall();
            }
            this.textField = textField;
            if (textField != null) {
                try {
                    textField.setText(this.valueToString(textField.getValue()));
                    Document doc = textField.getDocument();
                    if (doc instanceof AbstractDocument) {
                        ((AbstractDocument)doc).setDocumentFilter(this.getDocumentFilter());
                    }
                    textField.setNavigationFilter(this.getNavigationFilter());
                }
                catch (ParseException parseException) {
                    textField.setText("");
                    this.setEditValid(false);
                }
            }
        }

        public void uninstall() {
            Document doc = this.textField.getDocument();
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).setDocumentFilter(null);
            }
            this.textField.setNavigationFilter(null);
            this.textField = null;
        }

        protected void invalidEdit() {
            this.textField.invalidEdit();
        }

        protected void setEditValid(boolean valid) {
            this.textField.editValid = valid;
        }

        public abstract Object stringToValue(String var1) throws ParseException;

        public abstract String valueToString(Object var1) throws ParseException;
    }

    public static abstract class AbstractFormatterFactory {
        public abstract AbstractFormatter getFormatter(JFormattedTextField var1);
    }
}

