/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.x500;

import gnu.java.lang.CPStringBuilder;
import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class X500Principal
implements Principal,
Serializable {
    private static final long serialVersionUID = -500463348111345721L;
    public static final String CANONICAL = "CANONICAL";
    public static final String RFC1779 = "RFC1779";
    public static final String RFC2253 = "RFC2253";
    private static final OID CN = new OID("2.5.4.3");
    private static final OID C = new OID("2.5.4.6");
    private static final OID L = new OID("2.5.4.7");
    private static final OID ST = new OID("2.5.4.8");
    private static final OID STREET = new OID("2.5.4.9");
    private static final OID O = new OID("2.5.4.10");
    private static final OID OU = new OID("2.5.4.11");
    private static final OID DC = new OID("0.9.2342.19200300.100.1.25");
    private static final OID UID = new OID("0.9.2342.19200300.100.1.1");
    private transient List components = new LinkedList();
    private transient Map currentRdn = new LinkedHashMap();
    private transient boolean fixed;
    private transient byte[] encoded;
    private int sep;

    private X500Principal() {
        this.components.add(this.currentRdn);
    }

    public X500Principal(String name) {
        this();
        if (name == null) {
            throw new NullPointerException();
        }
        try {
            this.parseString(name);
        }
        catch (IOException ioe) {
            IllegalArgumentException iae = new IllegalArgumentException("malformed name");
            iae.initCause(ioe);
            throw iae;
        }
    }

    public X500Principal(byte[] encoded) {
        this(new ByteArrayInputStream(encoded));
    }

    public X500Principal(InputStream encoded) {
        this();
        try {
            this.parseDer(encoded);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe.toString());
        }
    }

    public int hashCode() {
        int result = this.size();
        int i = 0;
        while (i < this.size()) {
            Map m = (Map)this.components.get(i);
            for (Map.Entry e : m.entrySet()) {
                result = result * 31 + ((OID)e.getKey()).hashCode();
            }
            ++i;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof X500Principal)) {
            return false;
        }
        if (this.size() != ((X500Principal)o).size()) {
            return false;
        }
        int i = 0;
        while (i < this.size()) {
            Map m = (Map)this.components.get(i);
            for (Map.Entry e : m.entrySet()) {
                OID oid = (OID)e.getKey();
                String v1 = (String)e.getValue();
                String v2 = ((X500Principal)o).getComponent(oid, i);
                if (v2 == null) {
                    return false;
                }
                if (X500Principal.compressWS(v1).equalsIgnoreCase(X500Principal.compressWS(v2))) continue;
                return false;
            }
            ++i;
        }
        return true;
    }

    public byte[] getEncoded() {
        if (this.encoded == null) {
            this.encodeDer();
        }
        return (byte[])this.encoded.clone();
    }

    public String getName() {
        return this.getName(RFC2253);
    }

    public String getName(String format) {
        boolean rfc2253 = RFC2253.equalsIgnoreCase(format) || CANONICAL.equalsIgnoreCase(format);
        boolean rfc1779 = RFC1779.equalsIgnoreCase(format);
        boolean canon = CANONICAL.equalsIgnoreCase(format);
        if (!(rfc2253 || rfc1779 || canon)) {
            throw new IllegalArgumentException("unsupported format " + format);
        }
        CPStringBuilder str = new CPStringBuilder();
        Iterator it = this.components.iterator();
        while (it.hasNext()) {
            Map m = (Map)it.next();
            Iterator it2 = m.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry entry = it2.next();
                OID oid = (OID)entry.getKey();
                String value = (String)entry.getValue();
                if (oid.equals(CN)) {
                    str.append("CN");
                } else if (oid.equals(C)) {
                    str.append("C");
                } else if (oid.equals(L)) {
                    str.append("L");
                } else if (oid.equals(ST)) {
                    str.append("ST");
                } else if (oid.equals(STREET)) {
                    str.append("STREET");
                } else if (oid.equals(O)) {
                    str.append("O");
                } else if (oid.equals(OU)) {
                    str.append("OU");
                } else if (oid.equals(DC) && rfc2253) {
                    str.append("DC");
                } else if (oid.equals(UID) && rfc2253) {
                    str.append("UID");
                } else {
                    str.append(oid.toString());
                }
                str.append('=');
                str.append(value);
                if (!it2.hasNext()) continue;
                str.append('+');
            }
            if (!it.hasNext()) continue;
            str.append(',');
        }
        if (canon) {
            return str.toString().toUpperCase(Locale.US).toLowerCase(Locale.US);
        }
        return str.toString();
    }

    public String toString() {
        return this.getName(RFC2253);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.encoded != null) {
            this.encodeDer();
        }
        out.writeObject(this.encoded);
    }

    private void readObject(ObjectInputStream in) throws IOException, NotActiveException, ClassNotFoundException {
        byte[] buf = (byte[])in.readObject();
        this.parseDer(new ByteArrayInputStream(buf));
    }

    private int size() {
        return this.components.size();
    }

    private String getComponent(OID oid, int rdn) {
        if (rdn >= this.size()) {
            return null;
        }
        return (String)((Map)this.components.get(rdn)).get(oid);
    }

    private void encodeDer() {
        ArrayList<DERValue> name = new ArrayList<DERValue>(this.components.size());
        for (Map m : this.components) {
            if (m.isEmpty()) continue;
            HashSet rdn = new HashSet();
            for (Map.Entry e : m.entrySet()) {
                ArrayList<DERValue> atav = new ArrayList<DERValue>(2);
                atav.add(new DERValue(6, e.getKey()));
                atav.add(new DERValue(12, e.getValue()));
                rdn.add(new DERValue(48, atav));
            }
            name.add(new DERValue(49, rdn));
        }
        DERValue val = new DERValue(48, name);
        this.encoded = val.getEncoded();
    }

    private void parseString(String str) throws IOException {
        String key;
        StringReader in = new StringReader(str);
        while ((key = this.readAttributeType(in)) != null) {
            String value = this.readAttributeValue(in);
            this.putComponent(key, value);
            if (this.sep == 44) {
                this.newRelativeDistinguishedName();
            }
            if (this.sep != -1) continue;
        }
    }

    private String readAttributeType(Reader in) throws IOException {
        int ch;
        CPStringBuilder buf = new CPStringBuilder();
        while ((ch = in.read()) != 61) {
            if (ch == -1) {
                if (buf.length() > 0) {
                    throw new EOFException("partial name read: " + buf);
                }
                return null;
            }
            if (ch > 127) {
                throw new IOException("Invalid char: " + (char)ch);
            }
            if (Character.isLetterOrDigit((char)ch) || ch == 45 || ch == 46) {
                buf.append((char)ch);
                continue;
            }
            throw new IOException("Invalid char: " + (char)ch);
        }
        return buf.toString();
    }

    private String readAttributeValue(Reader in) throws IOException {
        CPStringBuilder buf = new CPStringBuilder();
        int ch = in.read();
        if (ch == 35) {
            while (97 <= (ch = in.read()) && ch <= 102 || 65 <= ch && ch <= 70 || Character.isDigit((char)ch)) {
                buf.append((char)ch);
            }
            if (ch == 43 || ch == 44) {
                this.sep = ch;
                String hex = buf.toString();
                return new String(X500Principal.toByteArray(hex));
            }
            throw new IOException("illegal character: " + (char)ch);
        }
        if (ch == 34) {
            while ((ch = in.read()) != 34) {
                if (ch == 92) {
                    ch = in.read();
                    if (ch == -1) {
                        throw new EOFException();
                    }
                    if (97 <= ch && ch <= 102 || 65 <= ch && ch <= 70 || Character.isDigit((char)ch)) {
                        int i = Character.digit((char)ch, 16) << 4;
                        ch = in.read();
                        if (!(97 <= ch && ch <= 102 || 65 <= ch && ch <= 70 || Character.isDigit((char)ch))) {
                            throw new IOException("illegal hex char");
                        }
                        buf.append((char)(i |= Character.digit((char)ch, 16)));
                        continue;
                    }
                    buf.append((char)ch);
                    continue;
                }
                buf.append((char)ch);
            }
            this.sep = in.read();
            if (this.sep != 43 && this.sep != 44) {
                throw new IOException("illegal character: " + (char)ch);
            }
            return buf.toString();
        }
        while (true) {
            switch (ch) {
                case 43: 
                case 44: {
                    this.sep = ch;
                    return buf.toString();
                }
                case 92: {
                    ch = in.read();
                    if (ch == -1) {
                        throw new EOFException();
                    }
                    if (97 <= ch && ch <= 102 || 65 <= ch && ch <= 70 || Character.isDigit((char)ch)) {
                        int i = Character.digit((char)ch, 16) << 4;
                        ch = in.read();
                        if (!(97 <= ch && ch <= 102 || 65 <= ch && ch <= 70 || Character.isDigit((char)ch))) {
                            throw new IOException("illegal hex char");
                        }
                        buf.append((char)(i |= Character.digit((char)ch, 16)));
                        break;
                    }
                    buf.append((char)ch);
                    break;
                }
                case 35: 
                case 59: 
                case 60: 
                case 61: 
                case 62: {
                    throw new IOException("illegal character: " + (char)ch);
                }
                case -1: {
                    this.sep = -1;
                    return buf.toString();
                }
                default: {
                    buf.append((char)ch);
                }
            }
            ch = in.read();
        }
    }

    private void parseDer(InputStream encoded) throws IOException {
        DERReader der = new DERReader(encoded);
        DERValue name = der.read();
        if (!name.isConstructed()) {
            throw new IOException("malformed Name");
        }
        this.encoded = name.getEncoded();
        int len = 0;
        while (len < name.getLength()) {
            DERValue rdn = der.read();
            if (!rdn.isConstructed()) {
                throw new IOException("badly formed RDNSequence");
            }
            int len2 = 0;
            while (len2 < rdn.getLength()) {
                DERValue atav = der.read();
                if (!atav.isConstructed()) {
                    throw new IOException("badly formed AttributeTypeAndValue");
                }
                DERValue val = der.read();
                if (val.getTag() != 6) {
                    throw new IOException("badly formed AttributeTypeAndValue");
                }
                OID oid = (OID)val.getValue();
                val = der.read();
                if (!(val.getValue() instanceof String)) {
                    throw new IOException("badly formed AttributeTypeAndValue");
                }
                String value = (String)val.getValue();
                this.putComponent(oid, value);
                len2 += atav.getEncodedLength();
            }
            if ((len += rdn.getEncodedLength()) >= name.getLength()) continue;
            this.newRelativeDistinguishedName();
        }
    }

    private void newRelativeDistinguishedName() {
        this.currentRdn = new LinkedHashMap();
        this.components.add(this.currentRdn);
    }

    private void putComponent(OID oid, String value) {
        this.currentRdn.put(oid, value);
    }

    private void putComponent(String name, String value) {
        if ((name = name.trim().toLowerCase()).equals("cn")) {
            this.putComponent(CN, value);
        } else if (name.equals("c")) {
            this.putComponent(C, value);
        } else if (name.equals("l")) {
            this.putComponent(L, value);
        } else if (name.equals("street")) {
            this.putComponent(STREET, value);
        } else if (name.equals("st")) {
            this.putComponent(ST, value);
        } else if (name.equals("o")) {
            this.putComponent(O, value);
        } else if (name.equals("ou")) {
            this.putComponent(OU, value);
        } else if (name.equals("dc")) {
            this.putComponent(DC, value);
        } else if (name.equals("uid")) {
            this.putComponent(UID, value);
        } else {
            this.putComponent(new OID(name), value);
        }
    }

    private static String compressWS(String str) {
        CPStringBuilder buf = new CPStringBuilder();
        char lastChar = '\u0000';
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) {
                if (!Character.isWhitespace(lastChar)) {
                    buf.append(' ');
                }
            } else {
                buf.append(c);
            }
            lastChar = c;
            ++i;
        }
        return buf.toString().trim();
    }

    private static byte[] toByteArray(String str) {
        int limit = str.length();
        byte[] result = new byte[(limit + 1) / 2];
        int i = 0;
        int j = 0;
        if (limit % 2 == 1) {
            result[j++] = (byte)Character.digit(str.charAt(i++), 16);
        }
        while (i < limit) {
            result[j] = (byte)(Character.digit(str.charAt(i++), 16) << 4);
            int n = j++;
            result[n] = (byte)(result[n] | (byte)Character.digit(str.charAt(i++), 16));
        }
        return result;
    }
}

