/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans.editors;

import java.awt.Color;
import java.beans.PropertyEditorSupport;

public class ColorEditor
extends PropertyEditorSupport {
    Color[] stdColors = new Color[]{Color.black, Color.blue, Color.cyan, Color.darkGray, Color.gray, Color.green, Color.lightGray, Color.magenta, Color.orange, Color.pink, Color.red, Color.white, Color.yellow};
    String[] stdColorNames = new String[]{"black", "blue", "cyan", "dark gray", "gray", "green", "light gray", "magenta", "orange", "pink", "red", "white", "yellow"};

    public void setAsText(String val) throws IllegalArgumentException {
        if (val.length() == 0) {
            throw new IllegalArgumentException("Tried to set empty value!");
        }
        int i = 0;
        while (i < this.stdColorNames.length) {
            if (this.stdColorNames[i].equalsIgnoreCase(val)) {
                this.setValue(this.stdColors[i]);
                return;
            }
            ++i;
        }
        if (val.charAt(0) == '#') {
            this.setValue(new Color(Integer.parseInt(val.substring(1), 16)));
        } else {
            this.setValue(new Color(Integer.parseInt(val, 16)));
        }
    }

    public String getAsText() {
        int i = 0;
        while (i < this.stdColors.length) {
            if (this.stdColors[i].equals(this.getValue())) {
                return this.stdColorNames[i];
            }
            ++i;
        }
        return "#" + Integer.toHexString(((Color)this.getValue()).getRGB() & 0xFFFFFF);
    }

    public String[] getTags() {
        return this.stdColorNames;
    }
}

