/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.FlowView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabExpander;
import javax.swing.text.TabSet;
import javax.swing.text.TabableView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class ParagraphView
extends FlowView
implements TabExpander {
    protected int firstLineIndent;
    private int justification;
    private float lineSpacing;
    private TabSet tabSet;

    public ParagraphView(Element element) {
        super(element, 1);
    }

    public float nextTabStop(float x, int tabOffset) {
        throw new InternalError("Not implemented yet");
    }

    protected View createRow() {
        return new Row(this.getElement());
    }

    public float getAlignment(int axis) {
        float align;
        if (axis == 0) {
            align = 0.5f;
        } else if (this.getViewCount() > 0) {
            float prefHeight = this.getPreferredSpan(1);
            float firstRowHeight = this.getView(0).getPreferredSpan(1);
            align = firstRowHeight / 2.0f / prefHeight;
        } else {
            align = 0.5f;
        }
        return align;
    }

    public void changedUpdate(DocumentEvent ev, Shape a, ViewFactory vf) {
        this.setPropertiesFromAttributes();
        this.layoutChanged(0);
        this.layoutChanged(1);
        super.changedUpdate(ev, a, vf);
    }

    protected void setPropertiesFromAttributes() {
        Element el = this.getElement();
        AttributeSet atts = el.getAttributes();
        this.setFirstLineIndent(StyleConstants.getFirstLineIndent(atts));
        this.setLineSpacing(StyleConstants.getLineSpacing(atts));
        this.setJustification(StyleConstants.getAlignment(atts));
        this.tabSet = StyleConstants.getTabSet(atts);
    }

    protected void setFirstLineIndent(float i) {
        this.firstLineIndent = (int)i;
    }

    protected void setJustification(int j) {
        this.justification = j;
    }

    protected void setLineSpacing(float s) {
        this.lineSpacing = s;
    }

    protected View getLayoutView(int i) {
        return this.layoutPool.getView(i);
    }

    protected int getLayoutViewCount() {
        return this.layoutPool.getViewCount();
    }

    protected TabSet getTabSet() {
        return this.tabSet;
    }

    protected int findOffsetToCharactersInString(char[] string, int start) {
        int offset;
        block5: {
            offset = -1;
            Document doc = this.getDocument();
            Segment text = new Segment();
            try {
                char ch;
                doc.getText(start, doc.getLength() - start, text);
                int index = start;
                while ((ch = text.next()) != '\uffff') {
                    int j = 0;
                    while (j < string.length) {
                        if (string[j] == ch) {
                            offset = index;
                            break block5;
                        }
                        ++j;
                    }
                    ++index;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return offset;
    }

    protected int getClosestPositionTo(int pos, Position.Bias bias, Shape a, int direction, Position.Bias[] biasRet, int rowIndex, int x) throws BadLocationException {
        return pos;
    }

    protected float getPartialSize(int startOffset, int endOffset) {
        float span;
        int endIndex;
        int startIndex = this.getViewIndex(startOffset, Position.Bias.Backward);
        if (startIndex == (endIndex = this.getViewIndex(endOffset, Position.Bias.Forward))) {
            View child = this.getView(startIndex);
            if (child instanceof TabableView) {
                TabableView tabable = (TabableView)((Object)child);
                span = tabable.getPartialSpan(startOffset, endOffset);
            } else {
                span = child.getPreferredSpan(0);
            }
        } else if (endIndex - startIndex == 1) {
            View child1 = this.getView(startIndex);
            if (child1 instanceof TabableView) {
                TabableView tabable = (TabableView)((Object)child1);
                span = tabable.getPartialSpan(startOffset, child1.getEndOffset());
            } else {
                span = child1.getPreferredSpan(0);
            }
            View child2 = this.getView(endIndex);
            if (child2 instanceof TabableView) {
                TabableView tabable = (TabableView)((Object)child2);
                span += tabable.getPartialSpan(child2.getStartOffset(), endOffset);
            } else {
                span += child2.getPreferredSpan(0);
            }
        } else {
            View child1 = this.getView(startIndex);
            if (child1 instanceof TabableView) {
                TabableView tabable = (TabableView)((Object)child1);
                span = tabable.getPartialSpan(startOffset, child1.getEndOffset());
            } else {
                span = child1.getPreferredSpan(0);
            }
            int i = startIndex + 1;
            while (i < endIndex) {
                View child = this.getView(i);
                span += child.getPreferredSpan(0);
                ++i;
            }
            View child2 = this.getView(endIndex);
            if (child2 instanceof TabableView) {
                TabableView tabable = (TabableView)((Object)child2);
                span += tabable.getPartialSpan(child2.getStartOffset(), endOffset);
            } else {
                span += child2.getPreferredSpan(0);
            }
        }
        return span;
    }

    protected float getTabBase() {
        return 0.0f;
    }

    protected void adjustRow(Row r, int desiredSpan, int x) {
    }

    public View breakView(int axis, float len, Shape a) {
        return null;
    }

    public int getBreakWeight(int axis, float len) {
        return 0;
    }

    class Row
    extends BoxView {
        Row(Element el) {
            super(el, 0);
        }

        public short getLeftInset() {
            short leftInset = super.getLeftInset();
            View parent = this.getParent();
            if (parent != null && parent.getView(0) == this) {
                leftInset = (short)(leftInset + ParagraphView.this.firstLineIndent);
            }
            return leftInset;
        }

        public float getAlignment(int axis) {
            float align;
            if (axis == 0) {
                switch (ParagraphView.this.justification) {
                    case 2: {
                        align = 1.0f;
                        break;
                    }
                    case 1: 
                    case 3: {
                        align = 0.5f;
                        break;
                    }
                    default: {
                        align = 0.0f;
                        break;
                    }
                }
            } else {
                align = super.getAlignment(axis);
            }
            return align;
        }

        protected int getViewIndexAtPosition(int pos) {
            int index = -1;
            if (pos >= this.getStartOffset() && pos < this.getEndOffset()) {
                int nviews = this.getViewCount();
                int i = 0;
                while (i < nviews && index == -1) {
                    View child = this.getView(i);
                    if (pos >= child.getStartOffset() && pos < child.getEndOffset()) {
                        index = i;
                    }
                    ++i;
                }
            }
            return index;
        }

        protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
            this.baselineLayout(targetSpan, axis, offsets, spans);
        }

        protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
            return this.baselineRequirements(axis, r);
        }

        protected void loadChildren(ViewFactory vf) {
        }

        public int getStartOffset() {
            int offset = Integer.MAX_VALUE;
            int n = this.getViewCount();
            int i = 0;
            while (i < n) {
                View v = this.getView(i);
                offset = Math.min(offset, v.getStartOffset());
                ++i;
            }
            return offset;
        }

        public int getEndOffset() {
            int offset = 0;
            int n = this.getViewCount();
            int i = 0;
            while (i < n) {
                View v = this.getView(i);
                offset = Math.max(offset, v.getEndOffset());
                ++i;
            }
            return offset;
        }
    }
}

