/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class DefaultTableCellRenderer
extends JLabel
implements TableCellRenderer,
Serializable {
    static final long serialVersionUID = 7878911414715528324L;
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    Color foreground;
    Color background;

    public void setForeground(Color c) {
        super.setForeground(c);
        this.foreground = c;
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this.background = c;
    }

    public void updateUI() {
        super.updateUI();
        this.background = null;
        this.foreground = null;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setValue(value);
        this.setOpaque(true);
        if (table == null) {
            return this;
        }
        if (isSelected) {
            super.setBackground(table.getSelectionBackground());
            super.setForeground(table.getSelectionForeground());
        } else {
            if (this.background != null) {
                super.setBackground(this.background);
            } else {
                super.setBackground(table.getBackground());
            }
            if (this.foreground != null) {
                super.setForeground(this.foreground);
            } else {
                super.setForeground(table.getForeground());
            }
        }
        Border b = null;
        if (hasFocus) {
            if (isSelected) {
                b = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
            }
            if (b == null) {
                b = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
        } else {
            b = noFocusBorder;
        }
        this.setBorder(b);
        this.setFont(table.getFont());
        Color back = this.getBackground();
        this.setOpaque(back != null && back.equals(table.getBackground()));
        return this;
    }

    public boolean isOpaque() {
        return true;
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    public void repaint(Rectangle r) {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    protected void setValue(Object value) {
        if (value != null) {
            this.setText(value.toString());
        } else {
            this.setText("");
        }
    }

    public static class UIResource
    extends DefaultTableCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

