/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.nio.channels.FileChannelImpl;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;

public class FileInputStream
extends InputStream {
    private FileDescriptor fd;
    private FileChannelImpl ch;

    public FileInputStream(String name) throws FileNotFoundException {
        this(new File(name));
    }

    public FileInputStream(File file) throws FileNotFoundException {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkRead(file.getPath());
        }
        this.ch = FileChannelImpl.create(file, 1);
    }

    public FileInputStream(FileDescriptor fdObj) {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkRead(fdObj);
        }
        this.fd = fdObj;
        this.ch = (FileChannelImpl)fdObj.channel;
    }

    FileInputStream(FileChannelImpl ch) {
        this.ch = ch;
    }

    public int available() throws IOException {
        return this.ch.available();
    }

    public void close() throws IOException {
        this.ch.close();
    }

    protected void finalize() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileDescriptor getFD() throws IOException {
        FileInputStream fileInputStream = this;
        synchronized (fileInputStream) {
            if (this.fd == null) {
                this.fd = new FileDescriptor(this.ch);
            }
            return this.fd;
        }
    }

    public int read() throws IOException {
        return this.ch.read();
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int offset, int len) throws IOException {
        if (offset < 0 || len < 0 || offset + len > buf.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.ch.read(buf, offset, len);
    }

    public synchronized long skip(long numBytes) throws IOException {
        if (numBytes < 0L) {
            throw new IllegalArgumentException("Can't skip negative bytes: " + numBytes);
        }
        if (numBytes == 0L) {
            return 0L;
        }
        long oldPos = this.ch.position();
        this.ch.position(oldPos + numBytes);
        return this.ch.position() - oldPos;
    }

    public synchronized FileChannel getChannel() {
        return this.ch;
    }
}

