/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.sound.sampled.gstreamer.lines;

import gnu.classpath.Pointer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.sound.sampled.LineUnavailableException;

public class GstPipeline {
    private static final int READ = 0;
    private static final int WRITE = 1;
    private static final int QUEUED = 1;
    private static final String CAPACITY_KEY = "Capacity";
    private static final Object[] lock = new Object[0];
    protected Preferences prefs = Preferences.userNodeForPackage(GstPipeline.class).node("GStreamer");
    private long capacity = -1L;
    private State state = State.STOP;
    private String name = null;
    private FileOutputStream output = null;
    private boolean source = true;
    private boolean ready = false;
    private Pointer pipeline = null;

    static {
        System.loadLibrary("gstreamerpeer");
        GstPipeline.init_id_cache();
    }

    public GstPipeline() {
        this(1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public GstPipeline(int bufferSize) {
        this.capacity = this.prefs.getLong(CAPACITY_KEY, -1L);
        if (this.capacity == -1L) {
            Object[] objectArray = lock;
            // MONITORENTER : lock
            this.capacity = this.detect_pipe_size();
            // MONITOREXIT : objectArray
            this.prefs.putLong(CAPACITY_KEY, this.capacity);
        }
        this.init_instance();
        Runtime.getRuntime().addShutdownHook(new CleanPipeline());
    }

    public void createForWrite() throws LineUnavailableException {
        if (!this.create_named_pipe(this.pipeline)) {
            throw new LineUnavailableException("Unable to create filesystem pipe");
        }
        GstPipeline.open_native_pipe(this.pipeline, 0);
        this.prepareWrite();
        this.source = true;
    }

    public State getState() {
        return this.state;
    }

    public void close() {
        this.setState(State.STOP);
    }

    public void setState(State state) {
        int _state = -1;
        switch (state) {
            case PLAY: {
                _state = 0;
                break;
            }
            case PAUSE: {
                _state = 1;
                break;
            }
            case STOP: 
            case CLOSE: {
                _state = 2;
                this.closePipe();
            }
        }
        if (GstPipeline.set_state(this.pipeline, _state)) {
            this.state = state;
        }
    }

    public Pointer getNativeClass() {
        return this.pipeline;
    }

    public int write(byte[] buffer, int offset, int length) {
        if (this.state == State.STOP) {
            return -1;
        }
        if (this.state == State.PAUSE) {
            return 0;
        }
        if (!this.ready) {
            return -1;
        }
        try {
            if (this.output != null) {
                this.output.write(buffer, offset, length);
                return length;
            }
            return 0;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int read(byte[] buffer, int offset, int length) {
        return 0;
    }

    public int available() {
        if (this.source) {
            return GstPipeline.available(this.pipeline, 0);
        }
        return GstPipeline.available(this.pipeline, 1);
    }

    /*
     * Exception decompiling
     */
    public void drain() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void flush() {
        try {
            if (this.source) {
                this.output.flush();
            }
        }
        catch (IOException iOException) {}
    }

    private void closePipe() {
        try {
            this.flush();
            if (this.source) {
                this.output.close();
            }
        }
        catch (IOException iOException) {}
    }

    private void prepareWrite() {
        try {
            this.ready = true;
            this.output = new FileOutputStream(this.name);
        }
        catch (Exception exception) {
            this.ready = false;
        }
    }

    private static final native void init_id_cache();

    private static final native boolean set_state(Pointer var0, int var1);

    private static final native int available(Pointer var0, int var1);

    private static final native void open_native_pipe(Pointer var0, int var1);

    private static final native void close_native_pipe(Pointer var0);

    private final native void init_instance();

    private final native boolean create_named_pipe(Pointer var1);

    private final native long detect_pipe_size();

    private class CleanPipeline
    extends Thread {
        private CleanPipeline() {
        }

        public void run() {
            GstPipeline.close_native_pipe(GstPipeline.this.pipeline);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        PLAY,
        PAUSE,
        STOP,
        CLOSE;

    }
}

