/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.jce.sig;

import gnu.java.security.key.dss.DSSKeyPairPKCS8Codec;
import gnu.java.security.key.dss.DSSKeyPairX509Codec;
import gnu.java.security.key.dss.DSSPrivateKey;
import gnu.java.security.key.dss.DSSPublicKey;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class DSSKeyFactory
extends KeyFactorySpi {
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DSAPublicKeySpec) {
            DSAPublicKeySpec spec = (DSAPublicKeySpec)keySpec;
            BigInteger p = spec.getP();
            BigInteger q = spec.getQ();
            BigInteger g = spec.getG();
            BigInteger y = spec.getY();
            return new DSSPublicKey(2, p, q, g, y);
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            X509EncodedKeySpec spec = (X509EncodedKeySpec)keySpec;
            byte[] encoded = spec.getEncoded();
            try {
                PublicKey result = new DSSKeyPairX509Codec().decodePublicKey(encoded);
                return result;
            }
            catch (RuntimeException x) {
                throw new InvalidKeySpecException(x.getMessage(), x);
            }
        }
        throw new InvalidKeySpecException("Unsupported (public) key specification");
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DSAPrivateKeySpec) {
            DSAPrivateKeySpec spec = (DSAPrivateKeySpec)keySpec;
            BigInteger p = spec.getP();
            BigInteger q = spec.getQ();
            BigInteger g = spec.getG();
            BigInteger x = spec.getX();
            return new DSSPrivateKey(3, p, q, g, x);
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            PKCS8EncodedKeySpec spec = (PKCS8EncodedKeySpec)keySpec;
            byte[] encoded = spec.getEncoded();
            try {
                PrivateKey result = new DSSKeyPairPKCS8Codec().decodePrivateKey(encoded);
                return result;
            }
            catch (RuntimeException x) {
                throw new InvalidKeySpecException(x.getMessage(), x);
            }
        }
        throw new InvalidKeySpecException("Unsupported (private) key specification");
    }

    protected KeySpec engineGetKeySpec(Key key, Class keySpec) throws InvalidKeySpecException {
        if (key instanceof DSAPublicKey) {
            if (keySpec.isAssignableFrom(DSAPublicKeySpec.class)) {
                DSAPublicKey dsaKey = (DSAPublicKey)key;
                BigInteger p = dsaKey.getParams().getP();
                BigInteger q = dsaKey.getParams().getQ();
                BigInteger g = dsaKey.getParams().getG();
                BigInteger y = dsaKey.getY();
                return new DSAPublicKeySpec(y, p, q, g);
            }
            if (keySpec.isAssignableFrom(X509EncodedKeySpec.class)) {
                if (key instanceof DSSPublicKey) {
                    DSSPublicKey dssKey = (DSSPublicKey)key;
                    byte[] encoded = dssKey.getEncoded(2);
                    return new X509EncodedKeySpec(encoded);
                }
                if ("X.509".equalsIgnoreCase(key.getFormat())) {
                    byte[] encoded = key.getEncoded();
                    return new X509EncodedKeySpec(encoded);
                }
                throw new InvalidKeySpecException("Wrong key type or unsupported (public) key specification");
            }
            throw new InvalidKeySpecException("Unsupported (public) key specification");
        }
        if (key instanceof DSAPrivateKey) {
            if (keySpec.isAssignableFrom(DSAPrivateKeySpec.class)) {
                DSAPrivateKey dsaKey = (DSAPrivateKey)key;
                BigInteger p = dsaKey.getParams().getP();
                BigInteger q = dsaKey.getParams().getQ();
                BigInteger g = dsaKey.getParams().getG();
                BigInteger x = dsaKey.getX();
                return new DSAPrivateKeySpec(x, p, q, g);
            }
            if (keySpec.isAssignableFrom(PKCS8EncodedKeySpec.class)) {
                if (key instanceof DSSPrivateKey) {
                    DSSPrivateKey dssKey = (DSSPrivateKey)key;
                    byte[] encoded = dssKey.getEncoded(3);
                    return new PKCS8EncodedKeySpec(encoded);
                }
                if ("PKCS#8".equalsIgnoreCase(key.getFormat())) {
                    byte[] encoded = key.getEncoded();
                    return new PKCS8EncodedKeySpec(encoded);
                }
                throw new InvalidKeySpecException("Wrong key type or unsupported (private) key specification");
            }
            throw new InvalidKeySpecException("Unsupported (private) key specification");
        }
        throw new InvalidKeySpecException("Wrong key type or unsupported key specification");
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof DSSPublicKey || key instanceof DSSPrivateKey) {
            return key;
        }
        if (key instanceof DSAPublicKey) {
            DSAPublicKey dsaKey = (DSAPublicKey)key;
            BigInteger p = dsaKey.getParams().getP();
            BigInteger q = dsaKey.getParams().getQ();
            BigInteger g = dsaKey.getParams().getG();
            BigInteger y = dsaKey.getY();
            return new DSSPublicKey(2, p, q, g, y);
        }
        if (key instanceof DSAPrivateKey) {
            DSAPrivateKey dsaKey = (DSAPrivateKey)key;
            BigInteger p = dsaKey.getParams().getP();
            BigInteger q = dsaKey.getParams().getQ();
            BigInteger g = dsaKey.getParams().getG();
            BigInteger x = dsaKey.getX();
            return new DSSPrivateKey(3, p, q, g, x);
        }
        throw new InvalidKeyException("Wrong key type");
    }
}

