/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.lang.CPStringBuilder;
import gnu.java.lang.reflect.TypeSignature;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Method;
import java.security.MessageDigest;

public class RMIHashes {
    public static long getMethodHash(Method meth) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            ByteArrayOutputStream digest_out = new ByteArrayOutputStream();
            DataOutputStream data_out = new DataOutputStream(digest_out);
            CPStringBuilder sbuf = new CPStringBuilder();
            sbuf.append(meth.getName());
            sbuf.append('(');
            Class<?>[] params = meth.getParameterTypes();
            int i = 0;
            while (i < params.length) {
                sbuf.append(TypeSignature.getEncodingOfClass(params[i]));
                ++i;
            }
            sbuf.append(')');
            Class<?> rcls = meth.getReturnType();
            if (rcls != Void.TYPE) {
                sbuf.append(TypeSignature.getEncodingOfClass(rcls));
            } else {
                sbuf.append('V');
            }
            data_out.writeUTF(sbuf.toString());
            data_out.flush();
            data_out.close();
            md.update(digest_out.toByteArray());
            byte[] sha = md.digest();
            long result = 0L;
            int len = sha.length < 8 ? sha.length : 8;
            int i2 = 0;
            while (i2 < len) {
                result += (long)(sha[i2] & 0xFF) << 8 * i2;
                ++i2;
            }
            return result;
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public static long getInterfaceHash(Class clazz) {
        return clazz.hashCode();
    }
}

