/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.swing;

import gnu.classpath.SystemProperties;
import gnu.java.awt.peer.swing.SwingComponentPeer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.util.LinkedList;

public class SwingContainerPeer
extends SwingComponentPeer
implements ContainerPeer {
    private LinkedList heavyweightDescendents = new LinkedList();
    private Image backbuffer;
    private Component focusOwner = null;

    public SwingContainerPeer(Container awtCont) {
    }

    protected synchronized void addHeavyweightDescendent(Component comp) {
        this.heavyweightDescendents.add(comp);
        this.focusOwner = null;
    }

    protected synchronized void removeHeavyweightDescendent(Component comp) {
        this.heavyweightDescendents.remove(comp);
        this.focusOwner = null;
    }

    protected Component[] getHeavyweightDescendents() {
        Component[] heavyweights = new Component[this.heavyweightDescendents.size()];
        heavyweights = this.heavyweightDescendents.toArray((S[])heavyweights);
        return heavyweights;
    }

    public Insets insets() {
        Insets retVal = this.swingComponent != null ? this.swingComponent.getJComponent().getInsets() : new Insets(0, 0, 0, 0);
        return retVal;
    }

    public Insets getInsets() {
        return this.insets();
    }

    public void beginValidate() {
    }

    public void endValidate() {
    }

    public void beginLayout() {
    }

    public void endLayout() {
    }

    public boolean isPaintPending() {
        return false;
    }

    public boolean isRestackSupported() {
        return false;
    }

    public void cancelPendingPaint(int x, int y, int width, int height) {
    }

    public void restack() {
    }

    protected void peerPaint(Graphics g, boolean update) {
        if (this.isDoubleBuffering()) {
            int width = this.awtComponent.getWidth();
            int height = this.awtComponent.getHeight();
            if (this.backbuffer == null || this.backbuffer.getWidth(this.awtComponent) < width || this.backbuffer.getHeight(this.awtComponent) < height) {
                this.backbuffer = this.awtComponent.createImage(width, height);
            }
            Graphics g2 = this.backbuffer.getGraphics();
            Rectangle clip = g.getClipRect();
            try {
                g2.setClip(clip);
                super.peerPaint(g2, update);
                this.peerPaintChildren(g2);
            }
            finally {
                g2.dispose();
            }
            g.drawImage(this.backbuffer, 0, 0, this.awtComponent);
        } else {
            super.peerPaint(g, update);
            this.peerPaintChildren(g);
        }
    }

    private boolean isDoubleBuffering() {
        String prop = SystemProperties.getProperty("gnu.awt.swing.doublebuffering", "false");
        return prop.equals("true");
    }

    protected synchronized void peerPaintChildren(Graphics g) {
        for (Component child : this.heavyweightDescendents) {
            ComponentPeer peer = child.getPeer();
            if (!(peer instanceof SwingComponentPeer) || !child.isVisible()) continue;
            Graphics g2 = g.create(child.getX(), child.getY(), child.getWidth(), child.getHeight());
            try {
                ((SwingComponentPeer)peer).peerPaint(g2, false);
            }
            finally {
                g2.dispose();
            }
        }
    }

    protected void handleMouseEvent(MouseEvent ev) {
        Component comp = this.awtComponent.getComponentAt(ev.getPoint());
        if (comp == null) {
            comp = this.awtComponent;
        }
        ComponentPeer peer = comp.getPeer();
        if (this.awtComponent != comp && !comp.isLightweight() && peer instanceof SwingComponentPeer) {
            ev.translatePoint(comp.getX(), comp.getY());
            ev.setSource(comp);
            ((SwingComponentPeer)peer).handleMouseEvent(ev);
        }
    }

    protected void handleMouseMotionEvent(MouseEvent ev) {
        Component comp = this.awtComponent.getComponentAt(ev.getPoint());
        if (comp != null) {
            ComponentPeer peer = comp.getPeer();
            if (this.awtComponent != comp && !comp.isLightweight() && peer instanceof SwingComponentPeer) {
                ev.translatePoint(comp.getX(), comp.getY());
                ((SwingComponentPeer)peer).handleMouseMotionEvent(ev);
            }
        }
    }

    protected void handleKeyEvent(KeyEvent e) {
        Component owner = this.getFocusOwner();
        if (owner != null) {
            owner.getPeer().handleEvent(e);
        } else {
            super.handleKeyEvent(e);
        }
    }

    private Component getFocusOwner() {
        if (this.focusOwner == null) {
            for (Component child : this.heavyweightDescendents) {
                if (!child.isFocusable()) continue;
                this.focusOwner = child;
                break;
            }
        }
        return this.focusOwner;
    }
}

