/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import gnu.classpath.SystemProperties;
import gnu.java.awt.LowPriorityEvent;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InvocationEvent;
import java.awt.image.VolatileImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class RepaintManager {
    static WeakHashMap currentRepaintManagers;
    private static Rectangle rectCache;
    private HashMap dirtyComponents = new HashMap();
    private HashMap dirtyComponentsWork = new HashMap();
    private RepaintWorker repaintWorker;
    private ArrayList invalidComponents = new ArrayList();
    private boolean doubleBufferingEnabled;
    private WeakHashMap offscreenBuffers;
    private Dimension doubleBufferMaximumSize;

    static {
        rectCache = new Rectangle();
    }

    public RepaintManager() {
        this.repaintWorker = new RepaintWorker();
        this.doubleBufferMaximumSize = new Dimension(2000, 2000);
        this.doubleBufferingEnabled = SystemProperties.getProperty("gnu.swing.doublebuffering", "true").equals("true");
        this.offscreenBuffers = new WeakHashMap();
    }

    public static RepaintManager currentManager(Component component) {
        ThreadGroup threadGroup;
        RepaintManager currentManager;
        if (currentRepaintManagers == null) {
            currentRepaintManagers = new WeakHashMap();
        }
        if ((currentManager = (RepaintManager)currentRepaintManagers.get(threadGroup = Thread.currentThread().getThreadGroup())) == null) {
            currentManager = new RepaintManager();
            currentRepaintManagers.put(threadGroup, currentManager);
        }
        return currentManager;
    }

    public static RepaintManager currentManager(JComponent component) {
        return RepaintManager.currentManager((Component)component);
    }

    public static void setCurrentManager(RepaintManager manager) {
        if (currentRepaintManagers == null) {
            currentRepaintManagers = new WeakHashMap();
        }
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        currentRepaintManagers.put(threadGroup, manager);
    }

    public void addInvalidComponent(JComponent component) {
        Container validateRoot = null;
        Container c = component;
        while (c != null) {
            if (c instanceof CellRendererPane || !c.isDisplayable()) {
                return;
            }
            if (c instanceof JComponent && ((JComponent)c).isValidateRoot()) {
                validateRoot = c;
                break;
            }
            c = c.getParent();
        }
        if (validateRoot == null) {
            return;
        }
        c = validateRoot;
        while (c != null) {
            if (!c.isVisible() || !c.isDisplayable()) {
                return;
            }
            c = c.getParent();
        }
        if (this.invalidComponents.contains(validateRoot)) {
            return;
        }
        this.invalidComponents.add(validateRoot);
        if (!this.repaintWorker.isLive()) {
            this.repaintWorker.setLive(true);
            this.invokeLater(this.repaintWorker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInvalidComponent(JComponent component) {
        ArrayList arrayList = this.invalidComponents;
        synchronized (arrayList) {
            this.invalidComponents.remove(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDirtyRegion(JComponent component, int x, int y, int w, int h) {
        if (w <= 0 || h <= 0 || !component.isShowing()) {
            return;
        }
        component.computeVisibleRect(rectCache);
        SwingUtilities.computeIntersection(x, y, w, h, rectCache);
        if (!rectCache.isEmpty()) {
            HashMap hashMap = this.dirtyComponents;
            synchronized (hashMap) {
                Rectangle dirtyRect = (Rectangle)this.dirtyComponents.get(component);
                if (dirtyRect != null) {
                    SwingUtilities.computeUnion(RepaintManager.rectCache.x, RepaintManager.rectCache.y, RepaintManager.rectCache.width, RepaintManager.rectCache.height, dirtyRect);
                } else {
                    this.dirtyComponents.put(component, rectCache.getBounds());
                }
            }
            if (!this.repaintWorker.isLive()) {
                this.repaintWorker.setLive(true);
                this.invokeLater(this.repaintWorker);
            }
        }
    }

    public Rectangle getDirtyRegion(JComponent component) {
        Rectangle dirty = (Rectangle)this.dirtyComponents.get(component);
        if (dirty == null) {
            dirty = new Rectangle();
        }
        return dirty;
    }

    public void markCompletelyDirty(JComponent component) {
        this.addDirtyRegion(component, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCompletelyClean(JComponent component) {
        HashMap hashMap = this.dirtyComponents;
        synchronized (hashMap) {
            this.dirtyComponents.remove(component);
        }
    }

    public boolean isCompletelyDirty(JComponent component) {
        boolean dirty = false;
        Rectangle r = this.getDirtyRegion(component);
        if (r.width == Integer.MAX_VALUE && r.height == Integer.MAX_VALUE) {
            dirty = true;
        }
        return dirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateInvalidComponents() {
        while (this.invalidComponents.size() > 0) {
            Component comp;
            ArrayList arrayList = this.invalidComponents;
            synchronized (arrayList) {
                comp = (Component)this.invalidComponents.remove(0);
            }
            if (!comp.isVisible() || !comp.isShowing()) continue;
            comp.validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintDirtyRegions() {
        if (this.dirtyComponents.size() == 0) {
            return;
        }
        HashMap hashMap = this.dirtyComponents;
        synchronized (hashMap) {
            HashMap swap = this.dirtyComponents;
            this.dirtyComponents = this.dirtyComponentsWork;
            this.dirtyComponentsWork = swap;
        }
        HashSet repaintRoots = new HashSet();
        Set components = this.dirtyComponentsWork.keySet();
        for (JComponent dirty : components) {
            this.compileRepaintRoots(this.dirtyComponentsWork, dirty, repaintRoots);
        }
        for (JComponent comp : repaintRoots) {
            Rectangle damaged = (Rectangle)this.dirtyComponentsWork.remove(comp);
            if (damaged == null || damaged.isEmpty()) continue;
            comp.paintImmediately(damaged);
        }
        this.dirtyComponentsWork.clear();
    }

    private void compileRepaintRoots(HashMap dirtyRegions, JComponent dirty, HashSet roots) {
        Container parent;
        Container current = dirty;
        Container root = dirty;
        Rectangle originalDirtyRect = (Rectangle)dirtyRegions.get(dirty);
        rectCache.setBounds(originalDirtyRect);
        int x = dirty.getX();
        int y = dirty.getY();
        int w = dirty.getWidth();
        int h = dirty.getHeight();
        rectCache = SwingUtilities.computeIntersection(0, 0, w, h, rectCache);
        if (rectCache.isEmpty()) {
            return;
        }
        int dx = 0;
        int dy = 0;
        int rootDx = 0;
        int rootDy = 0;
        while ((parent = current.getParent()) != null && parent instanceof JComponent) {
            current = parent;
            dx += x;
            dy += y;
            RepaintManager.rectCache.x += x;
            RepaintManager.rectCache.y += y;
            x = current.getX();
            y = current.getY();
            w = current.getWidth();
            rectCache = SwingUtilities.computeIntersection(0, 0, w, h = current.getHeight(), rectCache);
            if (rectCache.isEmpty()) {
                return;
            }
            if (!dirtyRegions.containsKey(parent)) continue;
            root = current;
            rootDx = dx;
            rootDy = dy;
        }
        if (root != dirty) {
            RepaintManager.rectCache.x += rootDx - dx;
            RepaintManager.rectCache.y += rootDy - dy;
            Rectangle dirtyRect = (Rectangle)dirtyRegions.get(root);
            SwingUtilities.computeUnion(RepaintManager.rectCache.x, RepaintManager.rectCache.y, RepaintManager.rectCache.width, RepaintManager.rectCache.height, dirtyRect);
        }
        if (!roots.contains(root)) {
            roots.add(root);
        }
    }

    public Image getOffscreenBuffer(Component component, int proposedWidth, int proposedHeight) {
        Window root = SwingUtilities.getWindowAncestor(component);
        Image buffer = (Image)this.offscreenBuffers.get(root);
        if (buffer == null || buffer.getWidth(null) < proposedWidth || buffer.getHeight(null) < proposedHeight) {
            int width = Math.max(proposedWidth, root.getWidth());
            width = Math.min(this.doubleBufferMaximumSize.width, width);
            int height = Math.max(proposedHeight, root.getHeight());
            height = Math.min(this.doubleBufferMaximumSize.height, height);
            buffer = component.createImage(width, height);
            this.offscreenBuffers.put(root, buffer);
        }
        return buffer;
    }

    void commitBuffer(Component comp, int x, int y, int w, int h) {
        Component root = comp;
        while (root != null && !(root instanceof Window) && !(root instanceof Applet)) {
            x += root.getX();
            y += root.getY();
            root = root.getParent();
        }
        if (root != null) {
            Graphics g = root.getGraphics();
            Image buffer = (Image)this.offscreenBuffers.get(root);
            if (buffer != null) {
                g.clipRect(x, y, w, h);
                g.drawImage(buffer, 0, 0, root);
                g.dispose();
            }
        }
    }

    public Image getVolatileOffscreenBuffer(Component comp, int proposedWidth, int proposedHeight) {
        Window root = SwingUtilities.getWindowAncestor(comp);
        Image buffer = (Image)this.offscreenBuffers.get(root);
        if (buffer == null || buffer.getWidth(null) < proposedWidth || buffer.getHeight(null) < proposedHeight || !(buffer instanceof VolatileImage)) {
            int width = Math.max(proposedWidth, root.getWidth());
            width = Math.min(this.doubleBufferMaximumSize.width, width);
            int height = Math.max(proposedHeight, root.getHeight());
            buffer = root.createVolatileImage(width, height = Math.min(this.doubleBufferMaximumSize.height, height));
            if (buffer != null) {
                this.offscreenBuffers.put(root, buffer);
            }
        }
        return buffer;
    }

    public Dimension getDoubleBufferMaximumSize() {
        return this.doubleBufferMaximumSize;
    }

    public void setDoubleBufferMaximumSize(Dimension size) {
        this.doubleBufferMaximumSize = size;
    }

    public void setDoubleBufferingEnabled(boolean buffer) {
        this.doubleBufferingEnabled = buffer;
    }

    public boolean isDoubleBufferingEnabled() {
        return this.doubleBufferingEnabled;
    }

    public String toString() {
        return "RepaintManager";
    }

    private void invokeLater(Runnable runnable) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        EventQueue evQueue = tk.getSystemEventQueue();
        RepaintWorkerEvent ev = new RepaintWorkerEvent(evQueue, runnable, null, false);
        evQueue.postEvent(ev);
    }

    private class RepaintWorker
    implements Runnable {
        boolean live = false;

        public synchronized void setLive(boolean b) {
            this.live = b;
        }

        public synchronized boolean isLive() {
            return this.live;
        }

        public void run() {
            try {
                ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                RepaintManager rm = (RepaintManager)currentRepaintManagers.get(threadGroup);
                rm.validateInvalidComponents();
                rm.paintDirtyRegions();
            }
            finally {
                this.setLive(false);
            }
        }
    }

    private static class RepaintWorkerEvent
    extends InvocationEvent
    implements LowPriorityEvent {
        public RepaintWorkerEvent(Object source, Runnable runnable, Object notifier, boolean catchEx) {
            super(source, runnable, notifier, catchEx);
        }

        public void dispatch() {
            super.dispatch();
        }
    }
}

