/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;

public class PipedOutputStream
extends OutputStream {
    PipedInputStream sink;
    boolean closed;

    public PipedOutputStream() {
    }

    public PipedOutputStream(PipedInputStream sink) throws IOException {
        sink.connect(this);
    }

    public void connect(PipedInputStream sink) throws IOException {
        if (this.sink != null || sink.source != null) {
            throw new IOException("Already connected");
        }
        sink.connect(this);
    }

    public void write(int b) throws IOException {
        if (this.sink == null) {
            throw new IOException("Not connected");
        }
        if (this.closed) {
            throw new IOException("Pipe closed");
        }
        this.sink.receive(b);
    }

    public void write(byte[] buffer, int offset, int len) throws IOException {
        if (this.sink == null) {
            throw new IOException("Not connected");
        }
        if (this.closed) {
            throw new IOException("Pipe closed");
        }
        this.sink.receive(buffer, offset, len);
    }

    public void flush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.sink != null) {
            this.closed = true;
            PipedInputStream pipedInputStream = this.sink;
            synchronized (pipedInputStream) {
                this.sink.notifyAll();
            }
        }
    }
}

