/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.java.security.sig.rsa.RSA;
import gnu.javax.net.ssl.provider.Util;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.logging.Level;

public class SSLRSASignatureImpl
extends SignatureSpi {
    private static final SystemLogger logger = SystemLogger.SYSTEM;
    private RSAPublicKey pubkey;
    private RSAPrivateKey privkey;
    private final MessageDigest md5 = MessageDigest.getInstance("MD5");
    private final MessageDigest sha = MessageDigest.getInstance("SHA-1");
    private boolean initSign = false;
    private boolean initVerify = false;

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        try {
            this.pubkey = (RSAPublicKey)publicKey;
            this.initVerify = true;
            this.initSign = false;
            this.privkey = null;
        }
        catch (ClassCastException cce) {
            throw new InvalidKeyException(cce);
        }
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        try {
            this.privkey = (RSAPrivateKey)privateKey;
            this.initSign = true;
            this.initVerify = false;
            this.pubkey = null;
        }
        catch (ClassCastException cce) {
            throw new InvalidKeyException(cce);
        }
    }

    protected void engineUpdate(byte b) throws SignatureException {
        if (!this.initSign && !this.initVerify) {
            throw new IllegalStateException("not initialized");
        }
        logger.log((Level)Component.SSL_HANDSHAKE, "SSL/RSA update 0x{0}", Util.formatInt(b & 0xFF, 16, 2));
        this.md5.update(b);
        this.sha.update(b);
    }

    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        if (!this.initSign && !this.initVerify) {
            throw new IllegalStateException("not initialized");
        }
        logger.log((Level)Component.SSL_HANDSHAKE, "SSL/RSA update\n{0}", Util.hexDump(b, off, len, ">> "));
        this.md5.update(b, off, len);
        this.sha.update(b, off, len);
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] d;
        if (!this.initSign) {
            throw new SignatureException("not initialized for signing");
        }
        int k = this.privkey.getModulus().bitLength() + 7 >>> 3;
        if (k - 11 < (d = Util.concat(this.md5.digest(), this.sha.digest())).length) {
            throw new SignatureException("message too long");
        }
        byte[] eb = new byte[k];
        eb[0] = 0;
        eb[1] = 1;
        int i = 2;
        while (i < k - d.length - 1) {
            eb[i] = -1;
            ++i;
        }
        System.arraycopy(d, 0, eb, k - d.length, d.length);
        BigInteger EB = new BigInteger(eb);
        BigInteger EM = RSA.sign(this.privkey, EB);
        return Util.trim(EM);
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        if (!this.initVerify) {
            throw new SignatureException("not initialized for verifying");
        }
        BigInteger EM = new BigInteger(1, sigBytes);
        BigInteger EB = RSA.verify(this.pubkey, EM);
        int i = 0;
        byte[] eb = EB.toByteArray();
        if (eb[0] == 0) {
            i = 0;
            while (i < eb.length && eb[i] == 0) {
                ++i;
            }
        } else if (eb[0] == 1) {
            i = 1;
            while (i < eb.length && eb[i] != 0) {
                if (eb[i] != -1) {
                    throw new SignatureException("bad padding");
                }
                ++i;
            }
            ++i;
        } else {
            throw new SignatureException("decryption failed");
        }
        byte[] d1 = Util.trim(eb, i, eb.length - i);
        byte[] d2 = Util.concat(this.md5.digest(), this.sha.digest());
        logger.logv(Component.SSL_HANDSHAKE, "SSL/RSA d1:{0} d2:{1}", Util.toHexString(d1, ':'), Util.toHexString(d2, ':'));
        return Arrays.equals(d1, d2);
    }

    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new InvalidParameterException("parameters not supported");
    }

    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new InvalidParameterException("parameters not supported");
    }
}

