/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPDecoder;
import gnu.javax.imageio.bmp.BMPException;
import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class DecodeRLE8
extends BMPDecoder {
    private static final byte ESCAPE = 0;
    private static final byte EOL = 0;
    private static final byte EOB = 1;
    private static final byte DELTA = 2;

    public DecodeRLE8(BMPFileHeader fh, BMPInfoHeader ih) {
        super(fh, ih);
    }

    public BufferedImage decode(ImageInputStream in) throws IOException, BMPException {
        IndexColorModel palette = this.readPalette(in);
        this.skipToImage(in);
        Dimension d = this.infoHeader.getSize();
        int h = (int)d.getHeight();
        int w = (int)d.getWidth();
        byte[] data = this.uncompress(w, h, in);
        SinglePixelPackedSampleModel sm = new SinglePixelPackedSampleModel(0, w, h, new int[]{255});
        DataBufferByte db = new DataBufferByte(data, w * h, 0);
        WritableRaster raster = Raster.createWritableRaster(sm, db, null);
        return new BufferedImage(palette, raster, false, null);
    }

    private byte[] uncompress(int w, int h, ImageInputStream in) throws BMPException, IOException {
        byte[] cmd = new byte[2];
        byte[] data = new byte[w * h];
        int x = 0;
        int y = 0;
        try {
            while (x + y * w < w * h) {
                if (in.read(cmd) != 2) {
                    throw new IOException("Error reading compressed data.");
                }
                if (cmd[0] == 0) {
                    switch (cmd[1]) {
                        case 1: {
                            return data;
                        }
                        case 0: {
                            x = 0;
                            ++y;
                            break;
                        }
                        case 2: {
                            if (in.read(cmd) != 2) {
                                throw new IOException("Error reading compressed data.");
                            }
                            int dx = cmd[0] & 0xFF;
                            int dy = cmd[1] & 0xFF;
                            x += dx;
                            y += dy;
                            break;
                        }
                        default: {
                            int length;
                            int copylength = length = cmd[1] & 0xFF;
                            length += length & 1;
                            byte[] run = new byte[length];
                            if (in.read(run) != length) {
                                throw new IOException("Error reading compressed data.");
                            }
                            System.arraycopy(run, 0, data, x + w * (h - y - 1), copylength);
                            x += copylength;
                            break;
                        }
                    }
                    continue;
                }
                int length = cmd[0] & 0xFF;
                int i = 0;
                while (i < length) {
                    data[(h - y - 1) * w + x++] = cmd[1];
                    ++i;
                }
            }
            return data;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new BMPException("Invalid RLE data.");
        }
    }
}

