/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.keyring;

import gnu.java.security.Registry;
import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.java.security.util.PRNG;
import gnu.java.security.util.Util;
import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.keyring.Entry;
import gnu.javax.crypto.keyring.MalformedKeyringException;
import gnu.javax.crypto.keyring.MaskableEnvelopeEntry;
import gnu.javax.crypto.keyring.PasswordProtectedEntry;
import gnu.javax.crypto.keyring.Properties;
import gnu.javax.crypto.mode.IMode;
import gnu.javax.crypto.mode.ModeFactory;
import gnu.javax.crypto.pad.IPad;
import gnu.javax.crypto.pad.PadFactory;
import gnu.javax.crypto.pad.WrongPaddingException;
import gnu.javax.crypto.prng.PRNGFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.util.HashMap;
import java.util.logging.Logger;

public class PasswordEncryptedEntry
extends MaskableEnvelopeEntry
implements PasswordProtectedEntry,
Registry {
    private static final Logger log = Logger.getLogger(PasswordEncryptedEntry.class.getName());
    public static final int TYPE = 1;

    public PasswordEncryptedEntry(String cipher, String mode, int keylen, Properties properties) {
        super(1, properties);
        if (cipher == null || cipher.length() == 0 || mode == null || mode.length() == 0) {
            throw new IllegalArgumentException("cipher nor mode can be empty");
        }
        this.properties.put("cipher", cipher);
        this.properties.put("mode", mode);
        this.properties.put("keylen", String.valueOf(keylen));
        this.setMasked(false);
    }

    private PasswordEncryptedEntry() {
        super(1);
        this.setMasked(true);
    }

    public static PasswordEncryptedEntry decode(DataInputStream in, char[] password) throws IOException {
        PasswordEncryptedEntry entry = PasswordEncryptedEntry.decode(in);
        try {
            entry.decrypt(password);
        }
        catch (WrongPaddingException wrongPaddingException) {
            throw new MalformedKeyringException("wrong padding in decrypted data");
        }
        return entry;
    }

    public static PasswordEncryptedEntry decode(DataInputStream in) throws IOException {
        PasswordEncryptedEntry entry = new PasswordEncryptedEntry();
        entry.defaultDecode(in);
        return entry;
    }

    public void decrypt(char[] password) throws IllegalArgumentException, WrongPaddingException {
        if (this.isMasked() && this.payload != null) {
            long tt = -System.currentTimeMillis();
            IMode mode = this.getMode(password, 2);
            IPad padding = PadFactory.getInstance("PKCS7");
            padding.init(mode.currentBlockSize());
            byte[] buf = new byte[this.payload.length];
            int count = 0;
            while (count + mode.currentBlockSize() <= this.payload.length) {
                mode.update(this.payload, count, buf, count);
                count += mode.currentBlockSize();
            }
            int padlen = padding.unpad(buf, 0, buf.length);
            this.setMasked(false);
            int len = buf.length - padlen;
            ByteArrayInputStream baos = new ByteArrayInputStream(buf, 0, len);
            DataInputStream in = new DataInputStream(baos);
            try {
                this.decodeEnvelope(in);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("decryption failed");
            }
            log.fine("Decrypted in " + (tt += System.currentTimeMillis()) + "ms.");
        }
    }

    public void encrypt(char[] password) throws IOException {
        System.currentTimeMillis();
        System.currentTimeMillis();
        byte[] salt = new byte[8];
        PRNG.getInstance().nextBytes(salt);
        System.currentTimeMillis();
        this.properties.put("salt", Util.toString(salt));
        IMode mode = this.getMode(password, 1);
        IPad pad = PadFactory.getInstance("PKCS7");
        pad.init(mode.currentBlockSize());
        ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
        DataOutputStream out2 = new DataOutputStream(bout);
        for (Entry entry : this.entries) {
            long cfr_ignored_0 = -System.currentTimeMillis();
            entry.encode(out2);
            System.currentTimeMillis();
        }
        byte[] plaintext = bout.toByteArray();
        byte[] padding = pad.pad(plaintext, 0, plaintext.length);
        this.payload = new byte[plaintext.length + padding.length];
        byte[] lastBlock = new byte[mode.currentBlockSize()];
        int l = mode.currentBlockSize() - padding.length;
        System.arraycopy(plaintext, plaintext.length - l, lastBlock, 0, l);
        System.arraycopy(padding, 0, lastBlock, l, padding.length);
        int count = 0;
        while (count + mode.currentBlockSize() < plaintext.length) {
            mode.update(plaintext, count, this.payload, count);
            count += mode.currentBlockSize();
        }
        mode.update(lastBlock, 0, this.payload, count);
        this.setMasked(true);
        System.currentTimeMillis();
    }

    public void encode(DataOutputStream out, char[] password) throws IOException {
        this.encrypt(password);
        this.encode(out);
    }

    protected void encodePayload() throws IOException {
        if (this.payload == null) {
            throw new IllegalStateException("not encrypted");
        }
    }

    private IMode getMode(char[] password, int state) {
        String modeName;
        IMode mode;
        String s = this.properties.get("salt");
        if (s == null) {
            throw new IllegalArgumentException("no salt");
        }
        byte[] salt = Util.toBytesFromString(s);
        IBlockCipher cipher = CipherFactory.getInstance(this.properties.get("cipher"));
        if (cipher == null) {
            throw new IllegalArgumentException("no such cipher: " + this.properties.get("cipher"));
        }
        int blockSize = cipher.defaultBlockSize();
        if (this.properties.containsKey("block-size")) {
            try {
                blockSize = Integer.parseInt(this.properties.get("block-size"));
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("bad block size: " + nfe.getMessage());
            }
        }
        if ((mode = ModeFactory.getInstance(modeName = this.properties.get("mode"), cipher, blockSize)) == null) {
            throw new IllegalArgumentException("no such mode: " + modeName);
        }
        HashMap<String, Object> pbAttr = new HashMap<String, Object>();
        pbAttr.put("gnu.crypto.pbe.password", password);
        pbAttr.put("gnu.crypto.pbe.salt", salt);
        pbAttr.put("gnu.crypto.pbe.iteration.count", ITERATION_COUNT);
        IRandom kdf = PRNGFactory.getInstance("PBKDF2-HMAC-SHA");
        kdf.init(pbAttr);
        int keylen = 0;
        if (!this.properties.containsKey("keylen")) {
            throw new IllegalArgumentException("no key length");
        }
        try {
            keylen = Integer.parseInt(this.properties.get("keylen"));
        }
        catch (NumberFormatException numberFormatException) {}
        byte[] dk = new byte[keylen];
        byte[] iv = new byte[blockSize];
        try {
            kdf.nextBytes(dk, 0, keylen);
            kdf.nextBytes(iv, 0, blockSize);
        }
        catch (LimitReachedException shouldNotHappen) {
            throw new Error(shouldNotHappen.toString());
        }
        HashMap<String, Object> modeAttr = new HashMap<String, Object>();
        modeAttr.put("gnu.crypto.cipher.key.material", dk);
        modeAttr.put("gnu.crypto.mode.state", state);
        modeAttr.put("gnu.crypto.mode.iv", iv);
        try {
            mode.init(modeAttr);
        }
        catch (InvalidKeyException ike) {
            throw new IllegalArgumentException(ike.toString());
        }
        return mode;
    }
}

