/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.key;

import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.cipher.IBlockCipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class SecretKeyGeneratorImpl
extends KeyGeneratorSpi {
    protected final int defaultKeySize;
    protected final List keySizes;
    protected final String algorithm;
    protected boolean init;
    protected int currentKeySize;
    protected SecureRandom random;

    protected SecretKeyGeneratorImpl(String algorithm) {
        this.algorithm = algorithm;
        IBlockCipher cipher = CipherFactory.getInstance(algorithm);
        if (cipher == null) {
            throw new IllegalArgumentException("no such cipher: " + algorithm);
        }
        this.defaultKeySize = cipher.defaultKeySize();
        this.keySizes = new LinkedList();
        Iterator it = cipher.keySizes();
        while (it.hasNext()) {
            this.keySizes.add(it.next());
        }
        this.init = false;
    }

    protected SecretKey engineGenerateKey() {
        if (!this.init) {
            throw new IllegalStateException("not initialized");
        }
        byte[] buf = new byte[this.currentKeySize];
        this.random.nextBytes(buf);
        return new SecretKeySpec(buf, this.algorithm);
    }

    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException(String.valueOf(this.algorithm) + " does not support algorithm paramaters");
    }

    protected void engineInit(int keySize, SecureRandom random) {
        if (!this.keySizes.contains(keySize >>>= 3)) {
            throw new InvalidParameterException("unsupported key size: " + keySize + ", valid sizes are: " + this.keySizes);
        }
        this.currentKeySize = keySize;
        this.random = random;
        this.init = true;
    }

    protected void engineInit(SecureRandom random) {
        this.engineInit(this.defaultKeySize << 3, random);
    }
}

